/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.query;

import java.util.Map;
import org.intermine.sql.query.AbstractConstraint;
import org.intermine.sql.query.AbstractTable;
import org.intermine.sql.query.Constraint;
import org.intermine.sql.query.SubQueryConstraint;

public class NotConstraint
extends AbstractConstraint {
    protected AbstractConstraint con;

    public NotConstraint(AbstractConstraint con) {
        this.con = con;
    }

    @Override
    public String getSQLString() {
        if (this.con instanceof Constraint) {
            Constraint conC = (Constraint)this.con;
            if ("null".equals(conC.right.getSQLString())) {
                return conC.getLeft().getSQLString() + " IS NOT NULL";
            }
            String op = null;
            switch (conC.operation) {
                case 1: {
                    op = " != ";
                    break;
                }
                case 2: {
                    op = " >= ";
                    break;
                }
                case 3: {
                    op = " NOT LIKE ";
                    break;
                }
                default: {
                    throw new Error("Unrecognised operation " + conC.operation);
                }
            }
            return conC.left.getSQLString() + op + conC.right.getSQLString();
        }
        if (this.con instanceof SubQueryConstraint) {
            SubQueryConstraint conC = (SubQueryConstraint)this.con;
            if (conC.right.getSelect().size() != 1) {
                throw new IllegalStateException("Right must have one result column only");
            }
            return conC.left.getSQLString() + " NOT IN (" + conC.right.getSQLString() + ")";
        }
        return "NOT (" + this.con.getSQLString() + ")";
    }

    @Override
    public int compare(AbstractConstraint obj, Map<AbstractTable, AbstractTable> tableMap, Map<AbstractTable, AbstractTable> reverseTableMap) {
        return NotConstraint.alterComparisonNotThis(this.con.compare(obj, tableMap, reverseTableMap));
    }

    @Override
    public int hashCode() {
        return -this.con.hashCode();
    }

    public AbstractConstraint getConstraint() {
        return this.con;
    }
}

