/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.query;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.intermine.sql.query.AbstractConstraint;
import org.intermine.sql.query.AbstractTable;
import org.intermine.sql.query.AbstractValue;
import org.intermine.sql.query.Constant;
import org.intermine.sql.query.NotConstraint;

public class InListConstraint
extends AbstractConstraint {
    protected AbstractValue left;
    protected Set<Constant> right;

    public InListConstraint(AbstractValue left) {
        if (left == null) {
            throw new NullPointerException("left cannot be null");
        }
        this.left = left;
        this.right = new HashSet<Constant>();
    }

    public void add(Constant c) {
        this.right.add(c);
    }

    public void addAll(Collection<? extends Constant> c) {
        for (Constant constant : c) {
            this.right.add(constant);
        }
    }

    public AbstractValue getLeft() {
        return this.left;
    }

    public Set<Constant> getRight() {
        return Collections.unmodifiableSet(this.right);
    }

    @Override
    public String getSQLString() {
        StringBuffer retval = new StringBuffer(this.left.getSQLString()).append(" IN (");
        boolean needComma = false;
        for (Constant con : this.right) {
            if (needComma) {
                retval.append(", ");
            }
            needComma = true;
            retval.append(con.getSQLString());
        }
        retval.append(")");
        return retval.toString();
    }

    @Override
    public int compare(AbstractConstraint obj, Map<AbstractTable, AbstractTable> tableMap, Map<AbstractTable, AbstractTable> reverseTableMap) {
        if (obj instanceof InListConstraint) {
            InListConstraint objC = (InListConstraint)obj;
            return this.left.valueEquals(objC.left, tableMap, reverseTableMap) && ((Object)this.right).equals(objC.right) ? 9 : 15;
        }
        if (obj instanceof NotConstraint) {
            NotConstraint objNC = (NotConstraint)obj;
            return InListConstraint.alterComparisonNotObj(this.compare(objNC.con, tableMap, reverseTableMap));
        }
        return 15;
    }

    @Override
    public int hashCode() {
        return 3 * this.left.hashCode() + 5 * ((Object)this.right).hashCode();
    }
}

