/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.intermine.sql.query.AbstractTable;
import org.intermine.sql.query.AbstractValue;
import org.intermine.util.IdentityMap;

public class Function
extends AbstractValue {
    protected int operation;
    protected List<AbstractValue> operands;
    public static final int COUNT = 1;
    public static final int MAX = 2;
    public static final int MIN = 3;
    public static final int SUM = 4;
    public static final int AVG = 5;
    public static final int PLUS = 6;
    public static final int MINUS = 7;
    public static final int MULTIPLY = 8;
    public static final int DIVIDE = 9;
    public static final int POWER = 10;
    public static final int MODULO = 11;
    public static final int TYPECAST = 12;
    public static final int STRPOS = 13;
    public static final int SUBSTR = 14;
    public static final int COALESCE = 15;
    public static final int LOWER = 16;
    public static final int UPPER = 17;
    public static final int STDDEV = 18;
    private static final String[] REPRESENTATIONS = new String[]{"", "COUNT(*)", "MAX(", "MIN(", "SUM(", "AVG(", " + ", " - ", " * ", " / ", " ^ ", " % ", "::", "STRPOS(", "SUBSTR(", "COALESCE(", "LOWER(", "UPPER(", "STDDEV("};

    public Function(int operation) {
        if (operation < 1 || operation > 18) {
            throw new IllegalArgumentException("operation is not valid");
        }
        this.operation = operation;
        this.operands = new ArrayList<AbstractValue>();
    }

    public void add(AbstractValue obj) {
        switch (this.operation) {
            case 1: {
                throw new IllegalArgumentException("COUNT does not take any operands");
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 16: 
            case 17: 
            case 18: {
                if (this.operands.size() < 1) break;
                throw new IllegalArgumentException("This function may only take one operand");
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                if (this.operands.size() < 2) break;
                throw new IllegalArgumentException("This function may only taketwo operands");
            }
            case 14: {
                if (this.operands.size() < 3) break;
                throw new IllegalArgumentException("This function may only take three operands");
            }
        }
        this.operands.add(obj);
    }

    @Override
    public String getSQLString() {
        switch (this.operation) {
            case 1: {
                return "COUNT(*)";
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 16: 
            case 17: 
            case 18: {
                if (this.operands.size() < 1) {
                    throw new IllegalStateException("This function needs an operand");
                }
                return REPRESENTATIONS[this.operation] + this.operands.get(0).getSQLString() + ")";
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                if (this.operands.size() < 2) {
                    throw new IllegalStateException("This function needs two operands");
                }
                String retval = "";
                if (this.operation != 12) {
                    retval = retval + "(";
                }
                boolean needComma = false;
                for (AbstractValue v : this.operands) {
                    if (needComma) {
                        retval = retval + REPRESENTATIONS[this.operation];
                    }
                    needComma = true;
                    retval = retval + v.getSQLString();
                }
                if (this.operation != 12) {
                    retval = retval + ")";
                }
                return retval;
            }
            case 13: 
            case 14: 
            case 15: {
                if (this.operands.size() < 2) {
                    throw new IllegalStateException("This function needs two operands");
                }
                String retval = REPRESENTATIONS[this.operation];
                boolean needComma = false;
                for (AbstractValue v : this.operands) {
                    if (needComma) {
                        retval = retval + ", ";
                    }
                    needComma = true;
                    retval = retval + v.getSQLString();
                }
                retval = retval + ")";
                return retval;
            }
        }
        throw new Error("Unrecognised operation " + this.operation);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Function) {
            Function objF = (Function)obj;
            if (this.operation == objF.operation) {
                if (this.operation == 6 || this.operation == 8) {
                    HashMap<AbstractValue, Integer> a = new HashMap<AbstractValue, Integer>();
                    for (AbstractValue operand : this.operands) {
                        if (!a.containsKey(operand)) {
                            a.put(operand, new Integer(1));
                            continue;
                        }
                        Integer i = (Integer)a.get(operand);
                        a.put(operand, new Integer(1 + i));
                    }
                    HashMap<AbstractValue, Integer> b = new HashMap<AbstractValue, Integer>();
                    for (AbstractValue operand : objF.operands) {
                        if (!b.containsKey(operand)) {
                            b.put(operand, new Integer(1));
                            continue;
                        }
                        Integer i = (Integer)b.get(operand);
                        b.put(operand, new Integer(1 + i));
                    }
                    return ((Object)a).equals(b);
                }
                return ((Object)this.operands).equals(objF.operands);
            }
        }
        return false;
    }

    @Override
    public int compare(AbstractValue obj, Map<AbstractTable, AbstractTable> tableMap, Map<AbstractTable, AbstractTable> reverseTableMap) {
        if (tableMap instanceof IdentityMap) {
            return this.equals(obj) ? 0 : 4;
        }
        return 0;
    }

    @Override
    public int hashCode() {
        int multiplier = 5;
        int state = this.operation * 3;
        for (AbstractValue operand : this.operands) {
            state += multiplier * operand.hashCode();
            if (this.operation == 6 || this.operation == 8) continue;
            multiplier += 2;
        }
        return state;
    }

    public int getOperation() {
        return this.operation;
    }

    public List<AbstractValue> getOperands() {
        return this.operands;
    }

    @Override
    public boolean isAggregate() {
        switch (this.operation) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 18: {
                return true;
            }
        }
        for (AbstractValue operand : this.operands) {
            if (!operand.isAggregate()) continue;
            return true;
        }
        return false;
    }
}

