/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.query;

import java.util.Map;
import org.intermine.sql.query.AbstractTable;
import org.intermine.sql.query.AbstractValue;

public class Field
extends AbstractValue {
    protected String name;
    protected AbstractTable table;

    public Field(String name, AbstractTable table) {
        if (name == null) {
            throw new NullPointerException("Field names cannot be null");
        }
        if (table == null) {
            throw new NullPointerException("Cannot accept null values for table");
        }
        this.name = name;
        this.table = table;
    }

    @Override
    public String getSQLString() {
        return this.table.getAlias() + "." + this.name;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Field) {
            Field objField = (Field)obj;
            return this.name.equals(objField.name) && this.table.equals(objField.table);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() + this.table.hashCode();
    }

    public boolean equalsTableOnlyAlias(AbstractValue obj) {
        if (obj instanceof Field) {
            Field objField = (Field)obj;
            return this.name.equals(objField.name) && this.table.equalsOnlyAlias(objField.table);
        }
        return false;
    }

    public AbstractTable getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int compare(AbstractValue obj, Map<AbstractTable, AbstractTable> tableMap, Map<AbstractTable, AbstractTable> reverseTableMap) {
        if (obj instanceof Field) {
            Field objField = (Field)obj;
            AbstractTable t = tableMap.get(this.table);
            AbstractTable revT = reverseTableMap.get(objField.table);
            if (t == null && revT == null) {
                return 0;
            }
            if (t == null || revT == null) {
                return 4;
            }
            return this.name.equals(objField.name) && t.equalsOnlyAlias(objField.table) ? 0 : 4;
        }
        return 4;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }
}

