/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.intermine.sql.query.DummyExplainResult;
import org.intermine.sql.query.PostgresExplainResult;
import org.intermine.sql.query.Query;

public class ExplainResult {
    protected long rows;
    protected long start;
    protected long complete;
    protected long width;
    protected long estimatedRows;

    public static ExplainResult getInstance(String query, Connection database) throws SQLException {
        if (database == null) {
            return new DummyExplainResult(new Query(query));
        }
        return new PostgresExplainResult(query, database);
    }

    public static ExplainResult getInstance(Query query, Connection database) throws SQLException {
        if (database == null) {
            return new DummyExplainResult(query);
        }
        return new PostgresExplainResult(query, database);
    }

    public static ExplainResult getInstance(PreparedStatement stmt) throws SQLException {
        return new PostgresExplainResult(stmt);
    }

    public long getRows() {
        return this.rows;
    }

    public long getStart() {
        return this.start;
    }

    public long getComplete() {
        return this.complete;
    }

    public long getWidth() {
        return this.width;
    }

    public void setEstimatedRows(long estimatedRows) {
        this.estimatedRows = estimatedRows;
    }

    public long getEstimatedRows() {
        return this.estimatedRows;
    }

    public long getTime() {
        return (long)((double)this.complete * (double)this.estimatedRows / (double)this.rows);
    }

    public String toString() {
        return "ExplainResult: rows=" + this.rows + " start=" + this.start + " complete=" + this.complete + " width=" + this.width;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExplainResult)) {
            return false;
        }
        ExplainResult e = (ExplainResult)o;
        return e.rows == this.rows && e.start == this.start && e.complete == this.complete && e.width == this.width;
    }

    public int hashCode() {
        return (int)(2L * this.rows + 3L * this.start + 5L * this.complete + 7L * this.width);
    }
}

