/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.query;

import java.util.Map;
import java.util.Set;
import org.intermine.sql.query.AbstractConstraint;
import org.intermine.sql.query.AbstractTable;
import org.intermine.sql.query.NotConstraint;
import org.intermine.util.ConsistentSet;

public class ConstraintSet
extends AbstractConstraint {
    protected Set<AbstractConstraint> cons = new ConsistentSet<AbstractConstraint>();

    public void add(AbstractConstraint obj) {
        if (obj instanceof ConstraintSet) {
            throw new IllegalArgumentException("A ConstraintSet cannot contain a ConstraintSet.");
        }
        if (obj instanceof NotConstraint) {
            NotConstraint objNC = (NotConstraint)obj;
            if (objNC.con instanceof ConstraintSet) {
                throw new IllegalArgumentException("A ConstraintSet cannot contain a ConstraintSet, even inside a NotConstraint.");
            }
        }
        this.cons.add(obj);
    }

    @Override
    public String getSQLString() {
        boolean needOR = false;
        boolean needParentheses = false;
        String retval = "";
        for (AbstractConstraint con : this.cons) {
            if (needOR) {
                retval = retval + " OR ";
                needParentheses = true;
            }
            needOR = true;
            retval = retval + con.getSQLString();
        }
        return needOR ? (needParentheses ? "(" + retval + ")" : retval) : "FALSE";
    }

    @Override
    public int compare(AbstractConstraint obj, Map<AbstractTable, AbstractTable> tableMap, Map<AbstractTable, AbstractTable> reverseTableMap) {
        if (obj instanceof ConstraintSet) {
            return ConstraintSet.alterComparisonAnd(this.internalCompare(obj, tableMap, reverseTableMap), ConstraintSet.alterComparisonSwitch(((ConstraintSet)obj).internalCompare(this, reverseTableMap, tableMap)));
        }
        if (obj instanceof NotConstraint) {
            NotConstraint objNC = (NotConstraint)obj;
            return ConstraintSet.alterComparisonNotObj(this.compare(objNC.con, tableMap, reverseTableMap));
        }
        return this.internalCompare(obj, tableMap, reverseTableMap);
    }

    protected int internalCompare(AbstractConstraint obj, Map<AbstractTable, AbstractTable> tableMap, Map<AbstractTable, AbstractTable> reverseTableMap) {
        int currentComp = 3;
        for (AbstractConstraint con : this.cons) {
            currentComp = ConstraintSet.alterComparisonSwitch(ConstraintSet.alterComparisonAORB(ConstraintSet.alterComparisonSwitch(currentComp), ConstraintSet.alterComparisonSwitch(con.compare(obj, tableMap, reverseTableMap))));
        }
        return currentComp;
    }

    @Override
    public int hashCode() {
        int retval = 0;
        for (AbstractConstraint con : this.cons) {
            retval += con.hashCode();
        }
        return retval;
    }

    public Set<AbstractConstraint> getConstraints() {
        return this.cons;
    }
}

