/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.query;

import java.util.Map;
import org.intermine.sql.query.AbstractConstraint;
import org.intermine.sql.query.AbstractTable;
import org.intermine.sql.query.AbstractValue;
import org.intermine.sql.query.ConstraintSet;
import org.intermine.sql.query.NotConstraint;

public class Constraint
extends AbstractConstraint {
    public static final int EQ = 1;
    public static final int LT = 2;
    public static final int LIKE = 3;
    public static final int GORNULL = 4;
    protected AbstractValue left;
    protected AbstractValue right;
    protected int operation;

    public Constraint(AbstractValue left, int operation, AbstractValue right) {
        this.left = left;
        this.right = right;
        if (operation < 1 || operation > 4) {
            throw new IllegalArgumentException("Invalid value for operation: " + operation);
        }
        this.operation = operation;
    }

    public String toString() {
        return this.getSQLString();
    }

    @Override
    public String getSQLString() {
        if ("null".equals(this.right.getSQLString())) {
            return this.left.getSQLString() + " IS NULL";
        }
        if (this.operation == 4) {
            return "(" + this.left.getSQLString() + " > " + this.right.getSQLString() + " OR " + this.left.getSQLString() + " IS NULL)";
        }
        String op = null;
        switch (this.operation) {
            case 1: {
                op = " = ";
                break;
            }
            case 2: {
                op = " < ";
                break;
            }
            case 3: {
                op = " LIKE ";
                break;
            }
            default: {
                throw new Error("Unrecognised operation " + this.operation);
            }
        }
        return this.left.getSQLString() + op + this.right.getSQLString();
    }

    @Override
    public int compare(AbstractConstraint obj, Map<AbstractTable, AbstractTable> tableMap, Map<AbstractTable, AbstractTable> reverseTableMap) {
        if (obj instanceof Constraint) {
            Constraint objC = (Constraint)obj;
            block0 : switch (this.operation) {
                case 1: {
                    switch (objC.operation) {
                        case 1: {
                            if (this.left.valueEquals(objC.left, tableMap, reverseTableMap)) {
                                return this.right.valueEquals(objC.right, tableMap, reverseTableMap) ? 9 : (this.right.notEqualTo(objC.right, tableMap, reverseTableMap) ? 7 : 15);
                            }
                            if (this.left.valueEquals(objC.right, tableMap, reverseTableMap)) {
                                return this.right.valueEquals(objC.left, tableMap, reverseTableMap) ? 9 : (this.right.notEqualTo(objC.left, tableMap, reverseTableMap) ? 7 : 15);
                            }
                            if (this.right.valueEquals(objC.left, tableMap, reverseTableMap)) {
                                return this.left.notEqualTo(objC.right, tableMap, reverseTableMap) ? 7 : 15;
                            }
                            if (this.right.valueEquals(objC.right, tableMap, reverseTableMap)) {
                                return this.left.notEqualTo(objC.left, tableMap, reverseTableMap) ? 7 : 15;
                            }
                            return 15;
                        }
                        case 2: {
                            if (this.left.valueEquals(objC.left, tableMap, reverseTableMap)) {
                                return this.right.lessThan(objC.right, tableMap, reverseTableMap) ? 11 : (this.right.greaterOrEqual(objC.right, tableMap, reverseTableMap) ? 7 : 15);
                            }
                            if (this.left.valueEquals(objC.right, tableMap, reverseTableMap)) {
                                return this.right.greaterThan(objC.left, tableMap, reverseTableMap) ? 11 : (this.right.lessOrEqual(objC.left, tableMap, reverseTableMap) ? 7 : 15);
                            }
                            if (this.right.valueEquals(objC.left, tableMap, reverseTableMap)) {
                                return this.left.lessThan(objC.right, tableMap, reverseTableMap) ? 11 : (this.left.greaterOrEqual(objC.right, tableMap, reverseTableMap) ? 7 : 15);
                            }
                            if (this.right.valueEquals(objC.right, tableMap, reverseTableMap)) {
                                return this.left.greaterThan(objC.left, tableMap, reverseTableMap) ? 11 : (this.left.lessOrEqual(objC.left, tableMap, reverseTableMap) ? 7 : 15);
                            }
                            return 15;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (objC.operation) {
                        case 1: {
                            if (this.left.valueEquals(objC.left, tableMap, reverseTableMap)) {
                                return objC.right.lessThan(this.right, reverseTableMap, tableMap) ? 13 : (objC.right.greaterOrEqual(this.right, reverseTableMap, tableMap) ? 7 : 15);
                            }
                            if (this.left.valueEquals(objC.right, tableMap, reverseTableMap)) {
                                return objC.left.lessThan(this.right, reverseTableMap, tableMap) ? 13 : (objC.left.greaterOrEqual(this.right, reverseTableMap, tableMap) ? 7 : 15);
                            }
                            if (this.right.valueEquals(objC.left, tableMap, reverseTableMap)) {
                                return objC.right.greaterThan(this.left, reverseTableMap, tableMap) ? 13 : (objC.right.lessOrEqual(this.left, reverseTableMap, tableMap) ? 7 : 15);
                            }
                            if (this.right.valueEquals(objC.right, tableMap, reverseTableMap)) {
                                return objC.left.greaterThan(this.left, reverseTableMap, tableMap) ? 13 : (objC.left.lessOrEqual(this.left, reverseTableMap, tableMap) ? 7 : 15);
                            }
                            return 15;
                        }
                        case 2: {
                            if (this.left.valueEquals(objC.left, tableMap, reverseTableMap)) {
                                if (this.right.valueEquals(objC.right, tableMap, reverseTableMap)) {
                                    return 9;
                                }
                                if (this.right.lessThan(objC.right, tableMap, reverseTableMap)) {
                                    return 11;
                                }
                                if (this.right.greaterThan(objC.right, tableMap, reverseTableMap)) {
                                    return 13;
                                }
                                return 15;
                            }
                            if (this.left.valueEquals(objC.right, tableMap, reverseTableMap)) {
                                if (this.right.valueEquals(objC.left, tableMap, reverseTableMap) || this.right.lessThan(objC.left, tableMap, reverseTableMap)) {
                                    return 7;
                                }
                                if (this.right.greaterThan(objC.left, tableMap, reverseTableMap)) {
                                    return 14;
                                }
                                return 15;
                            }
                            if (this.right.valueEquals(objC.left, tableMap, reverseTableMap)) {
                                if (this.left.valueEquals(objC.right, tableMap, reverseTableMap) || this.left.greaterThan(objC.right, tableMap, reverseTableMap)) {
                                    return 7;
                                }
                                if (this.left.lessThan(objC.right, tableMap, reverseTableMap)) {
                                    return 14;
                                }
                                return 15;
                            }
                            if (!this.right.valueEquals(objC.right, tableMap, reverseTableMap)) break block0;
                            if (this.left.valueEquals(objC.left, tableMap, reverseTableMap)) {
                                return 9;
                            }
                            if (this.left.greaterThan(objC.left, tableMap, reverseTableMap)) {
                                return 11;
                            }
                            if (this.left.lessThan(objC.left, tableMap, reverseTableMap)) {
                                return 13;
                            }
                            return 15;
                        }
                    }
                    break;
                }
                case 3: {
                    if (objC.operation != 3) break;
                    return this.left.valueEquals(objC.left, tableMap, reverseTableMap) && this.right.valueEquals(objC.right, tableMap, reverseTableMap) ? 9 : 15;
                }
                case 4: {
                    if (objC.operation != 4 || !this.left.valueEquals(objC.left, tableMap, reverseTableMap)) break;
                    if (this.right.valueEquals(objC.right, tableMap, reverseTableMap)) {
                        return 9;
                    }
                    if (this.right.lessThan(objC.right, tableMap, reverseTableMap)) {
                        return 13;
                    }
                    if (!this.right.greaterThan(objC.right, tableMap, reverseTableMap)) break;
                    return 11;
                }
            }
        } else {
            if (obj instanceof NotConstraint) {
                NotConstraint objNC = (NotConstraint)obj;
                return Constraint.alterComparisonNotObj(this.compare(objNC.con));
            }
            if (obj instanceof ConstraintSet) {
                return Constraint.alterComparisonSwitch(obj.compare(this));
            }
        }
        return 15;
    }

    @Override
    public int hashCode() {
        return 3 * this.left.hashCode() + 5 * this.operation + (this.operation == 1 ? 3 : 7) * this.right.hashCode();
    }

    public AbstractValue getLeft() {
        return this.left;
    }

    public AbstractValue getRight() {
        return this.right;
    }

    public int getOperation() {
        return this.operation;
    }
}

