/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.query;

import java.math.BigDecimal;
import java.util.Map;
import org.intermine.sql.query.AbstractTable;
import org.intermine.sql.query.AbstractValue;

public class Constant
extends AbstractValue {
    protected String value;

    public Constant(String value) {
        if (value == null) {
            throw new NullPointerException("Constants cannot have a null value");
        }
        this.value = value;
    }

    @Override
    public String getSQLString() {
        return this.value;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Constant) {
            Constant objConstant = (Constant)obj;
            return this.compare(objConstant, null, null) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int compare(AbstractValue obj, Map<AbstractTable, AbstractTable> tableMap, Map<AbstractTable, AbstractTable> reverseTableMap) {
        if (obj instanceof Constant) {
            boolean objIsString;
            Constant objC = (Constant)obj;
            if (this.value.equals(objC.value)) {
                return 0;
            }
            boolean thisIsString = this.value.toUpperCase().charAt(0) == 'E' && this.value.charAt(1) == '\'' && this.value.charAt(this.value.length() - 1) == '\'';
            boolean bl = objIsString = objC.value.toUpperCase().charAt(0) == 'E' && objC.value.charAt(1) == '\'' && objC.value.charAt(objC.value.length() - 1) == '\'';
            if (thisIsString && objIsString) {
                return this.value.compareTo(objC.value) < 0 ? 1 : 2;
            }
            thisIsString = this.value.charAt(0) == '\'' && this.value.charAt(this.value.length() - 1) == '\'';
            boolean bl2 = objIsString = objC.value.charAt(0) == '\'' && objC.value.charAt(objC.value.length() - 1) == '\'';
            if (thisIsString && objIsString) {
                return this.value.compareTo(objC.value) < 0 ? 1 : 2;
            }
            boolean thisIsNumber = false;
            BigDecimal thisNumber = null;
            boolean objIsNumber = false;
            BigDecimal objNumber = null;
            try {
                thisNumber = this.value.toUpperCase().endsWith("::REAL") ? new BigDecimal(Float.valueOf(this.value.substring(0, this.value.length() - 6)).doubleValue()) : new BigDecimal(this.value);
                thisIsNumber = true;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                objNumber = objC.value.toUpperCase().endsWith("::REAL") ? new BigDecimal(Float.valueOf(objC.value.substring(0, objC.value.length() - 6)).doubleValue()) : new BigDecimal(objC.value);
                objIsNumber = true;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (thisIsNumber && objIsString || objIsNumber && thisIsString) {
                return 3;
            }
            if (thisIsNumber && objIsNumber) {
                int comparison = thisNumber.compareTo(objNumber);
                if (comparison == 0) {
                    return 0;
                }
                if (comparison > 0) {
                    return 2;
                }
                return 1;
            }
        }
        return 4;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    public String toString() {
        return this.value;
    }
}

