/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.query;

import java.util.Map;
import org.intermine.sql.query.AbstractTable;
import org.intermine.sql.query.SQLStringable;

public abstract class AbstractValue
implements SQLStringable {
    public static final int EQUAL = 0;
    public static final int LESS = 1;
    public static final int GREATER = 2;
    public static final int NOT_EQUAL = 3;
    public static final int INCOMPARABLE = 4;

    @Override
    public abstract String getSQLString();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract int compare(AbstractValue var1, Map<AbstractTable, AbstractTable> var2, Map<AbstractTable, AbstractTable> var3);

    public boolean lessThan(AbstractValue obj, Map<AbstractTable, AbstractTable> tableMap, Map<AbstractTable, AbstractTable> reverseTableMap) {
        return this.compare(obj, tableMap, reverseTableMap) == 1;
    }

    public boolean greaterThan(AbstractValue obj, Map<AbstractTable, AbstractTable> tableMap, Map<AbstractTable, AbstractTable> reverseTableMap) {
        return this.compare(obj, tableMap, reverseTableMap) == 2;
    }

    public boolean notEqualTo(AbstractValue obj, Map<AbstractTable, AbstractTable> tableMap, Map<AbstractTable, AbstractTable> reverseTableMap) {
        int compareVal = this.compare(obj, tableMap, reverseTableMap);
        return compareVal == 3 || compareVal == 1 || compareVal == 2;
    }

    public boolean greaterOrEqual(AbstractValue obj, Map<AbstractTable, AbstractTable> tableMap, Map<AbstractTable, AbstractTable> reverseTableMap) {
        int compareVal = this.compare(obj, tableMap, reverseTableMap);
        return compareVal == 2 || compareVal == 0;
    }

    public boolean lessOrEqual(AbstractValue obj, Map<AbstractTable, AbstractTable> tableMap, Map<AbstractTable, AbstractTable> reverseTableMap) {
        int compareVal = this.compare(obj, tableMap, reverseTableMap);
        return compareVal == 1 || compareVal == 0;
    }

    public boolean valueEquals(AbstractValue obj, Map<AbstractTable, AbstractTable> tableMap, Map<AbstractTable, AbstractTable> reverseTableMap) {
        int compareVal = this.compare(obj, tableMap, reverseTableMap);
        return compareVal == 0;
    }

    public abstract boolean isAggregate();
}

