/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.query;

import java.util.Map;
import org.intermine.sql.query.AbstractTable;
import org.intermine.sql.query.SQLStringable;
import org.intermine.util.IdentityMap;

public abstract class AbstractConstraint
implements SQLStringable {
    public static final int INDEPENDENT = 15;
    public static final int IMPLIED_BY = 13;
    public static final int IMPLIES = 11;
    public static final int EQUAL = 9;
    public static final int OPPOSITE = 6;
    public static final int EXCLUDES = 7;
    public static final int OR = 14;
    public static final int BOTH_TRUE = 8;
    public static final int BOTH_FALSE = 1;
    public static final int LEFT_TRUE_RIGHT_FALSE = 4;
    public static final int LEFT_FALSE_RIGHT_TRUE = 2;
    public static final int LEFT_TRUE = 12;
    public static final int LEFT_FALSE = 3;
    public static final int RIGHT_TRUE = 10;
    public static final int RIGHT_FALSE = 5;

    @Override
    public abstract String getSQLString();

    public int compare(AbstractConstraint obj) {
        IdentityMap<AbstractTable> id = IdentityMap.getInstance();
        return this.compare(obj, id, id);
    }

    public abstract int compare(AbstractConstraint var1, Map<AbstractTable, AbstractTable> var2, Map<AbstractTable, AbstractTable> var3);

    public boolean equals(Object obj) {
        if (obj instanceof AbstractConstraint) {
            AbstractConstraint objC = (AbstractConstraint)obj;
            int compareVal = this.compare(objC);
            return AbstractConstraint.checkComparisonEquals(compareVal);
        }
        return false;
    }

    public abstract int hashCode();

    protected static int alterComparisonNotThis(int comp) {
        boolean nThisNObj = (comp & 1) == 1;
        boolean nThisObj = (comp & 2) == 2;
        boolean thisNObj = (comp & 4) == 4;
        boolean thisObj = (comp & 8) == 8;
        return (nThisNObj ? 4 : 0) + (nThisObj ? 8 : 0) + (thisNObj ? 1 : 0) + (thisObj ? 2 : 0);
    }

    protected static int alterComparisonNotObj(int comp) {
        boolean nThisNObj = (comp & 1) == 1;
        boolean nThisObj = (comp & 2) == 2;
        boolean thisNObj = (comp & 4) == 4;
        boolean thisObj = (comp & 8) == 8;
        return (nThisNObj ? 2 : 0) + (nThisObj ? 1 : 0) + (thisNObj ? 8 : 0) + (thisObj ? 4 : 0);
    }

    protected static int alterComparisonSwitch(int comp) {
        boolean nThisNObj = (comp & 1) == 1;
        boolean nThisObj = (comp & 2) == 2;
        boolean thisNObj = (comp & 4) == 4;
        boolean thisObj = (comp & 8) == 8;
        return (nThisNObj ? 1 : 0) + (nThisObj ? 4 : 0) + (thisNObj ? 2 : 0) + (thisObj ? 8 : 0);
    }

    protected static int alterComparisonAORB(int compA, int compB) {
        boolean nThisNA = (compA & 1) == 1;
        boolean nThisA = (compA & 2) == 2;
        boolean thisNA = (compA & 4) == 4;
        boolean thisA = (compA & 8) == 8;
        boolean nThisNB = (compB & 1) == 1;
        boolean nThisB = (compB & 2) == 2;
        boolean thisNB = (compB & 4) == 4;
        boolean thisB = (compB & 8) == 8;
        return (nThisNA && nThisNB ? 1 : 0) + (nThisA || nThisB ? 2 : 0) + (thisNA && thisNB ? 4 : 0) + (thisA || thisB ? 8 : 0);
    }

    protected static int alterComparisonAnd(int compA, int compB) {
        boolean nThisNA = (compA & 1) == 1;
        boolean nThisA = (compA & 2) == 2;
        boolean thisNA = (compA & 4) == 4;
        boolean thisA = (compA & 8) == 8;
        boolean nThisNB = (compB & 1) == 1;
        boolean nThisB = (compB & 2) == 2;
        boolean thisNB = (compB & 4) == 4;
        boolean thisB = (compB & 8) == 8;
        return (nThisNA && nThisNB ? 1 : 0) + (nThisA && nThisB ? 2 : 0) + (thisNA && thisNB ? 4 : 0) + (thisA && thisB ? 8 : 0);
    }

    public static boolean checkComparisonImplies(int comparison) {
        return (comparison & 4) == 0;
    }

    public static boolean checkComparisonEquals(int comparison) {
        return comparison == 9 || comparison == 8 || comparison == 1;
    }
}

