/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.precompute;

public class QueryOptimiserContext {
    public static final String MODE_NORMAL = "MODE_NORMAL";
    public static final String MODE_VERBOSE = "MODE_VERBOSE";
    public static final String MODE_VERBOSE_LIST = "MODE_VERBOSE_LIST";
    public static final String MODE_VERBOSE_SUMMARY = "MODE_VERBOSE_SUMMARY";
    private String mode = "MODE_NORMAL";
    private long timeLimit = -1L;
    public static final QueryOptimiserContext DEFAULT = new QueryOptimiserContext(){

        @Override
        public void setMode(String mode) {
            throw new IllegalStateException("This is the default QueryOptimiserContext - it cannot be altered");
        }

        @Override
        public String getMode() {
            return QueryOptimiserContext.MODE_NORMAL;
        }

        @Override
        public void setTimeLimit(long timeLimit) {
            throw new IllegalStateException("This is the default QueryOptimiserContext - it cannot be altered");
        }

        @Override
        public long getTimeLimit() {
            return -1L;
        }
    };

    public void setMode(String mode) {
        if (mode != MODE_NORMAL && mode != MODE_VERBOSE && mode != MODE_VERBOSE_LIST && mode != MODE_VERBOSE_SUMMARY) {
            throw new IllegalArgumentException("Invalid mode " + mode);
        }
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public void setTimeLimit(long timeLimit) {
        if (timeLimit < -1L) {
            throw new IllegalArgumentException("Invalid time limit " + timeLimit);
        }
        this.timeLimit = timeLimit;
    }

    public long getTimeLimit() {
        return this.timeLimit;
    }

    public boolean isVerbose() {
        return MODE_VERBOSE == this.mode || MODE_VERBOSE_LIST == this.mode || MODE_VERBOSE_SUMMARY == this.mode;
    }
}

