/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.precompute;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.intermine.sql.Database;
import org.intermine.sql.precompute.BestQuery;
import org.intermine.sql.precompute.BestQueryException;
import org.intermine.sql.precompute.BestQueryExplainer;
import org.intermine.sql.precompute.BestQueryExplainerVerbose;
import org.intermine.sql.precompute.BestQueryFallback;
import org.intermine.sql.precompute.BestQueryLogger;
import org.intermine.sql.precompute.EncloseSubqueryBestQuery;
import org.intermine.sql.precompute.LimitOffsetQuery;
import org.intermine.sql.precompute.OptimiserCache;
import org.intermine.sql.precompute.OptimiserMappingChecker;
import org.intermine.sql.precompute.PrecomputedTable;
import org.intermine.sql.precompute.PrecomputedTableManager;
import org.intermine.sql.precompute.QueryOptimiserContext;
import org.intermine.sql.precompute.QueryOptimiserException;
import org.intermine.sql.query.AbstractConstraint;
import org.intermine.sql.query.AbstractTable;
import org.intermine.sql.query.AbstractValue;
import org.intermine.sql.query.Constant;
import org.intermine.sql.query.Constraint;
import org.intermine.sql.query.ConstraintSet;
import org.intermine.sql.query.Field;
import org.intermine.sql.query.Function;
import org.intermine.sql.query.InListConstraint;
import org.intermine.sql.query.NotConstraint;
import org.intermine.sql.query.OrderDescending;
import org.intermine.sql.query.Query;
import org.intermine.sql.query.SelectValue;
import org.intermine.sql.query.SubQuery;
import org.intermine.sql.query.SubQueryConstraint;
import org.intermine.sql.query.Table;
import org.intermine.util.ConsistentSet;
import org.intermine.util.IdentityMap;
import org.intermine.util.MappingUtil;
import org.intermine.util.StringUtil;

public final class QueryOptimiser {
    private static final Logger LOG = Logger.getLogger(QueryOptimiser.class);
    private static final int REPORT_INTERVAL = 10000;
    private static final String ALIAS_PREFIX = "P";
    private static int callCount = 0;

    private QueryOptimiser() {
    }

    public static String optimise(String query, Database database) throws SQLException {
        return QueryOptimiser.optimise(query, database, QueryOptimiserContext.DEFAULT);
    }

    public static String optimise(String query, Database database, QueryOptimiserContext context) throws SQLException {
        return QueryOptimiser.optimise(query, null, database, null, context).getBestQueryString();
    }

    protected static Query optimise(Query query, Database database) throws SQLException {
        return QueryOptimiser.optimise(query, database, QueryOptimiserContext.DEFAULT);
    }

    protected static Query optimise(Query query, Database database, QueryOptimiserContext context) throws SQLException {
        return QueryOptimiser.optimise(query.toString(), query, database, null, context).getBestQuery();
    }

    public static BestQuery optimise(String query, Query originalQuery, Object precompLookup, Connection explainConnection, QueryOptimiserContext context) throws SQLException {
        Database database = null;
        PrecomputedTableManager ptm = null;
        if (precompLookup instanceof Database) {
            database = (Database)precompLookup;
            ptm = PrecomputedTableManager.getInstance(database);
        } else if (precompLookup instanceof Connection) {
            ptm = PrecomputedTableManager.getInstance((Connection)precompLookup);
        } else if (precompLookup instanceof PrecomputedTableManager) {
            ptm = (PrecomputedTableManager)precompLookup;
        } else {
            throw new SQLException("Cannot get a PrecomputedTableManager for lookup object " + precompLookup);
        }
        if (ptm.getPrecomputedTables().isEmpty()) {
            if (context.isVerbose()) {
                System.out.println("QueryOptimiser: no Precomputed Tables");
            }
            return new BestQueryFallback(null, query);
        }
        Set<PrecomputedTable> precomputedTables = ptm.getPrecomputedTables();
        OptimiserCache cache = OptimiserCache.getInstance(database);
        return QueryOptimiser.optimiseWith(query, originalQuery, database, explainConnection, context, precomputedTables, cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BestQuery optimiseWith(String query, Query originalQuery, Database database, Connection explainConnection, QueryOptimiserContext context, Set<PrecomputedTable> precomputedTables, OptimiserCache cache) throws SQLException {
        if (++callCount % 10000 == 0) {
            LOG.info((Object)("Optimiser called " + callCount + " times"));
        }
        long start = new Date().getTime();
        long parseTime = 0L;
        LimitOffsetQuery limitOffsetQuery = new LimitOffsetQuery(query);
        LOG.debug((Object)("Original Query: " + limitOffsetQuery.getQuery() + ", " + limitOffsetQuery.getLimit() + ", " + limitOffsetQuery.getOffset()));
        String cachedQuery = null;
        if (!context.isVerbose()) {
            cachedQuery = cache.lookup(limitOffsetQuery.getQuery(), limitOffsetQuery.getLimit());
        }
        if (cachedQuery != null) {
            LOG.debug((Object)("Optimising query took " + (new Date().getTime() - start) + " ms - cache hit: " + query));
            return new BestQueryFallback(null, limitOffsetQuery.reconstruct(cachedQuery));
        }
        try {
            boolean openedConnection = false;
            if (explainConnection == null) {
                openedConnection = true;
                explainConnection = database.getConnection();
            }
            BestQuery bestQuery = context.getMode() == "MODE_VERBOSE" ? new BestQueryExplainerVerbose(explainConnection, context.getTimeLimit()) : (context.getMode() == "MODE_VERBOSE_LIST" ? new BestQueryLogger(true) : (context.getMode() == "MODE_VERBOSE_SUMMARY" ? new BestQueryLogger(false) : new BestQueryExplainer(explainConnection, context.getTimeLimit())));
            String optimisedQuery = null;
            int expectedTime = 0;
            try {
                bestQuery.add(query);
                if (originalQuery == null) {
                    originalQuery = new Query(query);
                }
                parseTime = new Date().getTime();
                QueryOptimiser.recursiveOptimiseCheckSubquery(precomputedTables, originalQuery, bestQuery);
            }
            catch (BestQueryException e) {
                if (context.isVerbose()) {
                    System.out.println("QueryOptimiser: bailing out early: " + e);
                }
            }
            finally {
                if (context.isVerbose()) {
                    System.out.println("Optimised SQL: " + bestQuery.getBestQueryString());
                } else {
                    bestQuery.getBestQueryString();
                }
                if (openedConnection) {
                    explainConnection.close();
                }
            }
            optimisedQuery = bestQuery.getBestQueryString();
            LimitOffsetQuery limitOffsetOptimisedQuery = new LimitOffsetQuery(optimisedQuery);
            LOG.debug((Object)("New cache line produced - limit = " + limitOffsetQuery.getLimit()));
            cache.addCacheLine(limitOffsetQuery.getQuery(), limitOffsetOptimisedQuery.getQuery(), limitOffsetQuery.getLimit());
            LOG.debug((Object)("Optimising " + (expectedTime == 0 ? "" : expectedTime + " ms ") + "query took " + (new Date().getTime() - start) + (parseTime == 0L ? " ms without parsing " : " ms including " + (parseTime - start) + " ms for parse ") + "- cache miss: " + query));
            return bestQuery;
        }
        catch (RuntimeException e) {
            if (context.isVerbose()) {
                e.printStackTrace(System.out);
            }
            LOG.debug((Object)("Optimising query took " + (new Date().getTime() - start) + " ms - unparsable query: " + query));
            if (context.isVerbose()) {
                System.out.println("QueryOptimiser: unparsable query");
            }
            return new BestQueryFallback(originalQuery, query);
        }
    }

    protected static void remapAliasesToAvoidPrecomputePrefix(Query query) {
        for (AbstractTable table : query.getFrom()) {
            if (!table.getAlias().startsWith(ALIAS_PREFIX)) continue;
            table.setAlias(ALIAS_PREFIX + StringUtil.uniqueString());
        }
    }

    public static void recursiveOptimiseCheckSubquery(Set<PrecomputedTable> precomputedTables, Query query, BestQuery bestQuery) throws BestQueryException, SQLException {
        AbstractTable at;
        if (query.getFrom().size() == 1 && (at = query.getFrom().iterator().next()) instanceof SubQuery) {
            Query subQuery = ((SubQuery)at).getQuery();
            String originalQuery = query.getSQLString();
            String subQueryString = subQuery.getSQLString();
            int position = originalQuery.indexOf(subQueryString);
            bestQuery = new EncloseSubqueryBestQuery(bestQuery, originalQuery.substring(0, position), originalQuery.substring(position + subQueryString.length()));
            QueryOptimiser.recursiveOptimiseCheckSubquery(precomputedTables, subQuery, bestQuery);
            return;
        }
        QueryOptimiser.remapAliasesToAvoidPrecomputePrefix(query);
        QueryOptimiser.recursiveOptimise(precomputedTables, query, bestQuery, query);
    }

    public static void recursiveOptimise(Set<PrecomputedTable> precomputedTables, Query query, BestQuery bestQuery, Query originalQuery) throws BestQueryException, SQLException {
        SortedMap<PrecomputedTable, Set<Query>> map = QueryOptimiser.mergeMultiple(precomputedTables, query, originalQuery);
        for (Map.Entry<PrecomputedTable, Set<Query>> mapEntry : map.entrySet()) {
            PrecomputedTable p = mapEntry.getKey();
            Set<Query> queries = mapEntry.getValue();
            Set<PrecomputedTable> newPrecomputedTables = map.headMap(p).keySet();
            for (Query optimisedQuery : queries) {
                bestQuery.add(optimisedQuery);
                QueryOptimiser.recursiveOptimise(newPrecomputedTables, optimisedQuery, bestQuery, originalQuery);
            }
        }
    }

    protected static SortedMap<PrecomputedTable, Set<Query>> mergeMultiple(Set<PrecomputedTable> precomputedTables, Query query, Query originalQuery) {
        TreeMap<PrecomputedTable, Set<Query>> result = new TreeMap<PrecomputedTable, Set<Query>>();
        PrecomputedTable[] sorted = precomputedTables.toArray(new PrecomputedTable[0]);
        Arrays.sort(sorted, new Comparator<PrecomputedTable>(){

            @Override
            public int compare(PrecomputedTable a, PrecomputedTable b) {
                return b.getQuery().getFrom().size() - a.getQuery().getFrom().size();
            }
        });
        for (int i = 0; i < sorted.length; ++i) {
            PrecomputedTable p = sorted[i];
            Set<Query> mergeResult = QueryOptimiser.merge(p, query, originalQuery);
            if (mergeResult.isEmpty()) continue;
            result.put(p, mergeResult);
        }
        return result;
    }

    protected static Set<Query> merge(PrecomputedTable precomputedTable, Query query, Query originalQuery) {
        Query precompQuery = precomputedTable.getQuery();
        if (!precompQuery.getGroupBy().isEmpty()) {
            return QueryOptimiser.mergeGroupBy(precomputedTable, query, originalQuery);
        }
        if (precompQuery.isDistinct() && !query.isDistinct()) {
            return Collections.emptySet();
        }
        if (precompQuery.isDistinct() && query.isDistinct()) {
            boolean hasAggregate;
            boolean bl = hasAggregate = !query.getGroupBy().isEmpty();
            if (!hasAggregate) {
                Iterator<SelectValue> iter = query.getSelect().iterator();
                while (iter.hasNext() && !hasAggregate) {
                    SelectValue sv = iter.next();
                    AbstractValue av = sv.getValue();
                    hasAggregate = hasAggregate || av.isAggregate();
                }
            }
            if (hasAggregate) {
                return Collections.emptySet();
            }
        }
        LinkedHashSet<Query> retval = new LinkedHashSet<Query>();
        ConsistentSet mappings = new ConsistentSet();
        Set<Map<AbstractTable, AbstractTable>> c = MappingUtil.findCombinations(precompQuery.getFrom(), query.getFrom(), new AbstractTableComparator(), new OptimiserMappingChecker(precompQuery.getWhere(), query.getWhere()));
        mappings.addAll(c);
        Map<AbstractValue, SelectValue> valueMap = precomputedTable.getValueMap();
        Iterator mappingsIter = mappings.iterator();
        while (mappingsIter.hasNext()) {
            Map mapping = (Map)mappingsIter.next();
            QueryOptimiser.remapAliases(mapping, originalQuery.getFrom());
            LinkedHashSet<AbstractConstraint> whereConstraintEqualsSet = new LinkedHashSet<AbstractConstraint>();
            if (QueryOptimiser.compareConstraints(precompQuery.getWhere(), query.getWhere(), whereConstraintEqualsSet)) continue;
            mappingsIter.remove();
        }
        Set multipleMappings = MappingUtil.findMultipleCombinations(mappings);
        for (Set multipleMapping : multipleMappings) {
            Query currentQuery = query;
            try {
                for (Map<AbstractTable, AbstractTable> map : multipleMapping) {
                    QueryOptimiser.remapAliases(map, originalQuery.getFrom());
                    LinkedHashSet<AbstractConstraint> whereConstraintEqualsSet = new LinkedHashSet<AbstractConstraint>();
                    QueryOptimiser.compareConstraints(precompQuery.getWhere(), currentQuery.getWhere(), whereConstraintEqualsSet);
                    Table precomputedSqlTable = new Table(precomputedTable.getName(), ALIAS_PREFIX + StringUtil.uniqueString());
                    Query newQuery = new Query();
                    QueryOptimiser.reconstructSelectValues(currentQuery.getSelect(), precomputedSqlTable, valueMap, precompQuery.getFrom(), false, newQuery);
                    newQuery.addFrom(precomputedSqlTable);
                    QueryOptimiser.addNonCoveredFrom(currentQuery.getFrom(), precompQuery.getFrom(), newQuery.getFrom());
                    Set<AbstractConstraint> empty = Collections.emptySet();
                    QueryOptimiser.reconstructAbstractConstraints(currentQuery.getHaving(), precomputedSqlTable, valueMap, precompQuery.getFrom(), false, newQuery.getHaving(), empty, null, 0, null, false, false);
                    Field orderByField = null;
                    List<AbstractValue> precompOrderBy = precompQuery.getOrderBy();
                    if (precomputedTable.getOrderByField() == null || !query.getGroupBy().isEmpty()) {
                        QueryOptimiser.reconstructAbstractValues(currentQuery.getOrderBy(), precomputedSqlTable, valueMap, precompQuery.getFrom(), false, newQuery.getOrderBy());
                    } else {
                        ArrayList<AbstractValue> tempOrderBy = new ArrayList<AbstractValue>();
                        QueryOptimiser.reconstructAbstractValues(currentQuery.getOrderBy(), precomputedSqlTable, valueMap, precompQuery.getFrom(), false, tempOrderBy);
                        List<AbstractValue> newOrderBy = newQuery.getOrderBy();
                        Iterator orderByIter = tempOrderBy.iterator();
                        if (orderByIter.hasNext()) {
                            int i;
                            boolean matches = true;
                            boolean matchesDesc = true;
                            for (i = 0; i < precompOrderBy.size() && (matches || matchesDesc) && orderByIter.hasNext(); ++i) {
                                AbstractValue precompOrderByField = precompOrderBy.get(i);
                                AbstractValue nextPrecompOrderBy = precompOrderByField instanceof OrderDescending ? new OrderDescending(new Field(valueMap.get(((OrderDescending)precompOrderByField).getValue()).getAlias(), precomputedSqlTable)) : new Field(valueMap.get(precompOrderByField).getAlias(), precomputedSqlTable);
                                AbstractValue origValue = (AbstractValue)orderByIter.next();
                                boolean bl = matches = matches && origValue.equals(nextPrecompOrderBy);
                                matchesDesc = origValue instanceof OrderDescending ? matchesDesc && ((OrderDescending)origValue).getValue().equals(nextPrecompOrderBy) : (nextPrecompOrderBy instanceof OrderDescending ? matchesDesc && ((OrderDescending)nextPrecompOrderBy).getValue().equals(origValue) : false);
                            }
                            if ((matches || matchesDesc) && currentQuery.isDistinct()) {
                                LinkedHashSet<AbstractValue> newS = new LinkedHashSet<AbstractValue>();
                                for (SelectValue newSelectSV : newQuery.getSelect()) {
                                    newS.add(newSelectSV.getValue());
                                }
                                while (i < precompOrderBy.size() && (matches || matchesDesc)) {
                                    AbstractValue precompOrderByField = precompOrderBy.get(i);
                                    Field nextPrecompOrderBy = precompOrderByField instanceof OrderDescending ? new Field(valueMap.get(((OrderDescending)precompOrderByField).getValue()).getAlias(), precomputedSqlTable) : new Field(valueMap.get(precompOrderByField).getAlias(), precomputedSqlTable);
                                    matches = matches && newS.contains(nextPrecompOrderBy);
                                    matchesDesc = matchesDesc && newS.contains(nextPrecompOrderBy);
                                    ++i;
                                }
                            }
                            if (matches) {
                                orderByField = new Field(precomputedTable.getOrderByField(), precomputedSqlTable);
                                newOrderBy.add(orderByField);
                            } else if (matchesDesc) {
                                orderByField = new Field(precomputedTable.getOrderByField(), precomputedSqlTable);
                                newOrderBy.add(new OrderDescending(orderByField));
                            } else {
                                orderByIter = tempOrderBy.iterator();
                            }
                        }
                        while (orderByIter.hasNext()) {
                            newOrderBy.add((AbstractValue)orderByIter.next());
                        }
                        if (orderByField != null && currentQuery.isDistinct()) {
                            newQuery.addSelect(new SelectValue(orderByField, "orderby_field_from_pt"));
                        }
                    }
                    if (orderByField == null || !query.getGroupBy().isEmpty()) {
                        QueryOptimiser.reconstructAbstractConstraints(currentQuery.getWhere(), precomputedSqlTable, valueMap, precompQuery.getFrom(), false, newQuery.getWhere(), whereConstraintEqualsSet, null, 0, null, false, false);
                    } else {
                        AbstractValue maybeDesc = precompOrderBy.get(0);
                        boolean reverse = false;
                        if (maybeDesc instanceof OrderDescending) {
                            maybeDesc = ((OrderDescending)maybeDesc).getValue();
                            reverse = true;
                        }
                        Field firstPrecompOrderBy = new Field(valueMap.get(maybeDesc).getAlias(), precomputedSqlTable);
                        QueryOptimiser.reconstructAbstractConstraints(currentQuery.getWhere(), precomputedSqlTable, valueMap, precompQuery.getFrom(), false, newQuery.getWhere(), whereConstraintEqualsSet, firstPrecompOrderBy, precompOrderBy.size(), orderByField, precomputedTable.getFirstOrderByHasNoNulls(), reverse);
                    }
                    QueryOptimiser.reconstructAbstractValues(currentQuery.getGroupBy(), precomputedSqlTable, valueMap, precompQuery.getFrom(), false, newQuery.getGroupBy());
                    newQuery.setDistinct(currentQuery.isDistinct());
                    newQuery.setExplain(currentQuery.isExplain());
                    newQuery.setLimitOffset(currentQuery.getLimit(), currentQuery.getOffset());
                    currentQuery = newQuery;
                }
                retval.add(currentQuery);
            }
            catch (QueryOptimiserException e) {}
        }
        return retval;
    }

    protected static Set<Query> mergeGroupBy(PrecomputedTable precomputedTable, Query query, Query originalQuery) {
        Query precompQuery = precomputedTable.getQuery();
        LinkedHashSet<Query> retval = new LinkedHashSet<Query>();
        if (precompQuery.getGroupBy().size() != query.getGroupBy().size()) {
            return retval;
        }
        if (precompQuery.getFrom().size() != query.getFrom().size()) {
            return retval;
        }
        Set<Map<AbstractTable, AbstractTable>> mappings = MappingUtil.findCombinations(precompQuery.getFrom(), query.getFrom(), new AbstractTableComparator());
        Map<AbstractValue, SelectValue> valueMap = precomputedTable.getValueMap();
        for (Map<AbstractTable, AbstractTable> mapping : mappings) {
            QueryOptimiser.remapAliases(mapping, originalQuery.getFrom());
            if (!((Object)precompQuery.getWhere()).equals(query.getWhere()) || !((Object)precompQuery.getGroupBy()).equals(query.getGroupBy())) continue;
            LinkedHashSet<AbstractConstraint> constraintEqualsSet = new LinkedHashSet<AbstractConstraint>();
            if (!QueryOptimiser.compareConstraints(precompQuery.getHaving(), query.getHaving(), constraintEqualsSet) || precompQuery.isDistinct() && !query.isDistinct()) continue;
            Table precomputedSqlTable = new Table(precomputedTable.getName(), ALIAS_PREFIX + StringUtil.uniqueString());
            Query newQuery = new Query();
            try {
                QueryOptimiser.reconstructSelectValues(query.getSelect(), precomputedSqlTable, valueMap, precompQuery.getFrom(), true, newQuery);
                newQuery.addFrom(precomputedSqlTable);
                QueryOptimiser.reconstructAbstractConstraints(query.getHaving(), precomputedSqlTable, valueMap, precompQuery.getFrom(), true, newQuery.getWhere(), constraintEqualsSet, null, 0, null, true, false);
                QueryOptimiser.reconstructAbstractValues(query.getOrderBy(), precomputedSqlTable, valueMap, precompQuery.getFrom(), true, newQuery.getOrderBy());
                newQuery.setDistinct(query.isDistinct());
                newQuery.setExplain(query.isExplain());
                newQuery.setLimitOffset(query.getLimit(), query.getOffset());
            }
            catch (QueryOptimiserException e) {
                continue;
            }
            retval.add(newQuery);
        }
        return retval;
    }

    protected static boolean compareConstraints(Set<AbstractConstraint> set1, Set<AbstractConstraint> set2, Set<AbstractConstraint> equalsSet) {
        IdentityMap<AbstractTable> identity = IdentityMap.getInstance();
        return QueryOptimiser.compareConstraints(set1, set2, equalsSet, identity, identity);
    }

    protected static boolean compareConstraints(Set<AbstractConstraint> set1, Set<AbstractConstraint> set2, Set<AbstractConstraint> equalsSet, Map<AbstractTable, AbstractTable> tableMap, Map<AbstractTable, AbstractTable> reverseTableMap) {
        for (AbstractConstraint constraint1 : set1) {
            boolean match = false;
            for (AbstractConstraint constraint2 : set2) {
                int compareResult = constraint2.compare(constraint1, reverseTableMap, tableMap);
                if (!AbstractConstraint.checkComparisonImplies(compareResult)) continue;
                match = true;
                if (!AbstractConstraint.checkComparisonEquals(compareResult)) continue;
                equalsSet.add(constraint2);
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    protected static boolean compareSelectLists(List<SelectValue> list1, List<SelectValue> list2) {
        LinkedHashSet<AbstractValue> allValues = new LinkedHashSet<AbstractValue>();
        for (SelectValue selectValue : list2) {
            allValues.add(selectValue.getValue());
        }
        for (SelectValue selectValue : list1) {
            if (allValues.contains(selectValue.getValue())) continue;
            return false;
        }
        return true;
    }

    protected static void remapAliases(Map<AbstractTable, AbstractTable> map, Set<AbstractTable> tables) {
        for (Map.Entry<AbstractTable, AbstractTable> mapEntry : map.entrySet()) {
            AbstractTable firstTable = mapEntry.getKey();
            AbstractTable secondTable = mapEntry.getValue();
            String firstAlias = firstTable.getAlias();
            AbstractTable matchingTable = QueryOptimiser.findTableForAlias(firstAlias, tables);
            if (matchingTable != null && !matchingTable.equals(secondTable)) {
                String alternativeName = null;
                while (QueryOptimiser.findTableForAlias(alternativeName = ALIAS_PREFIX + StringUtil.uniqueString(), tables) != null) {
                }
                matchingTable.setAlias(alternativeName);
            }
            secondTable.setAlias(firstTable.getAlias());
        }
    }

    protected static AbstractTable findTableForAlias(String alias, Set<AbstractTable> set) {
        for (AbstractTable matchingTable : set) {
            if (!matchingTable.getAlias().equals(alias)) continue;
            return matchingTable;
        }
        return null;
    }

    protected static AbstractValue reconstructAbstractValue(AbstractValue original, Table precomputedSqlTable, Map<AbstractValue, SelectValue> valueMap, Set<AbstractTable> tableSet, boolean groupBy) throws QueryOptimiserException {
        SelectValue precompSelectValue = valueMap.get(original);
        if (precompSelectValue != null) {
            String precompAlias = precompSelectValue.getAlias();
            return new Field(precompAlias, precomputedSqlTable);
        }
        if (original instanceof Constant) {
            return original;
        }
        if (original instanceof Field) {
            AbstractTable t = ((Field)original).getTable();
            if (tableSet.contains(t)) {
                throw new QueryOptimiserException("Field not present in PrecomputedTable.");
            }
            return original;
        }
        if (original instanceof Function) {
            Function originalFunction = (Function)original;
            if (originalFunction.isAggregate()) {
                if (groupBy) {
                    throw new QueryOptimiserException("Aggregate not present in PrecomputedTable.");
                }
                if (originalFunction.getOperation() == 1) {
                    return original;
                }
                Iterator<AbstractValue> operandIter = originalFunction.getOperands().iterator();
                AbstractValue value = operandIter.next();
                value = QueryOptimiser.reconstructAbstractValue(value, precomputedSqlTable, valueMap, tableSet, groupBy);
                Function newFunction = new Function(originalFunction.getOperation());
                newFunction.add(value);
                return newFunction;
            }
            Function newFunction = new Function(originalFunction.getOperation());
            for (AbstractValue value : originalFunction.getOperands()) {
                value = QueryOptimiser.reconstructAbstractValue(value, precomputedSqlTable, valueMap, tableSet, groupBy);
                newFunction.add(value);
            }
            return newFunction;
        }
        if (original instanceof OrderDescending) {
            return new OrderDescending(QueryOptimiser.reconstructAbstractValue(((OrderDescending)original).getValue(), precomputedSqlTable, valueMap, tableSet, groupBy));
        }
        throw new IllegalArgumentException("Unknown type of AbstractValue.");
    }

    protected static void reconstructSelectValues(List<SelectValue> oldSelect, Table precomputedSqlTable, Map<AbstractValue, SelectValue> valueMap, Set<AbstractTable> tableSet, boolean groupBy, Query newQuery) throws QueryOptimiserException {
        for (SelectValue selectValue : oldSelect) {
            AbstractValue value = selectValue.getValue();
            AbstractValue newValue = QueryOptimiser.reconstructAbstractValue(value, precomputedSqlTable, valueMap, tableSet, groupBy);
            SelectValue newSelectValue = new SelectValue(newValue, selectValue.getAlias());
            newQuery.addSelect(newSelectValue);
        }
    }

    protected static void reconstructAbstractConstraints(Set<AbstractConstraint> oldConstraints, Table precomputedSqlTable, Map<AbstractValue, SelectValue> valueMap, Set<AbstractTable> tableSet, boolean groupBy, Set<AbstractConstraint> newConstraints, Set<AbstractConstraint> constraintEqualsSet, Field firstPrecompOrderBy, int precompOrderBySize, Field orderByField, boolean firstPrecompOrderByHasNoNulls, boolean reverseOrderBy) throws QueryOptimiserException {
        for (AbstractConstraint old : oldConstraints) {
            if (constraintEqualsSet.contains(old)) continue;
            AbstractConstraint newConstraint = QueryOptimiser.reconstructAbstractConstraint(old, precomputedSqlTable, valueMap, tableSet, groupBy, firstPrecompOrderBy, precompOrderBySize, orderByField, firstPrecompOrderByHasNoNulls, reverseOrderBy);
            newConstraints.add(newConstraint);
        }
    }

    protected static AbstractConstraint reconstructAbstractConstraint(AbstractConstraint oldConstraint, Table precomputedSqlTable, Map<AbstractValue, SelectValue> valueMap, Set<AbstractTable> tableSet, boolean groupBy, Field firstPrecompOrderBy, int precompOrderBySize, Field orderByField, boolean firstPrecompOrderByHasNoNulls, boolean reverseOrderBy) throws QueryOptimiserException {
        if (oldConstraint instanceof Constraint) {
            AbstractValue left = ((Constraint)oldConstraint).getLeft();
            AbstractValue right = ((Constraint)oldConstraint).getRight();
            left = QueryOptimiser.reconstructAbstractValue(left, precomputedSqlTable, valueMap, tableSet, groupBy);
            right = QueryOptimiser.reconstructAbstractValue(right, precomputedSqlTable, valueMap, tableSet, groupBy);
            int operation = ((Constraint)oldConstraint).getOperation();
            if (left.equals(firstPrecompOrderBy) && operation == 4 && right instanceof Constant) {
                String value = ((Constant)right).toString();
                for (int i = 1; i < precompOrderBySize; ++i) {
                    value = new BigInteger(value + "00000000000000000000").add(new BigInteger("50000000000000000000")).toString();
                }
                if (reverseOrderBy) {
                    return new Constraint(orderByField, 2, new Constant(new BigInteger(value).negate().toString()));
                }
                return new Constraint(new Constant(value), 2, orderByField);
            }
            if (right.equals(firstPrecompOrderBy) && operation == 2 && left instanceof Constant && firstPrecompOrderByHasNoNulls) {
                String value = ((Constant)left).toString();
                for (int i = 1; i < precompOrderBySize; ++i) {
                    value = new BigInteger(value + "00000000000000000000").add(new BigInteger("50000000000000000000")).toString();
                }
                if (reverseOrderBy) {
                    return new Constraint(orderByField, 2, new Constant(new BigInteger(value).negate().toString()));
                }
                return new Constraint(new Constant(value), 2, orderByField);
            }
            if (left.equals(firstPrecompOrderBy) && operation == 2 && right instanceof Constant) {
                String value = ((Constant)right).toString();
                for (int i = 1; i < precompOrderBySize; ++i) {
                    value = new BigInteger(value + "00000000000000000000").add(new BigInteger("50000000000000000000")).toString();
                }
                if (reverseOrderBy) {
                    return new Constraint(new Constant(new BigInteger(value).negate().toString()), 2, orderByField);
                }
                return new Constraint(orderByField, 2, new Constant(value));
            }
            return new Constraint(left, operation, right);
        }
        if (oldConstraint instanceof NotConstraint) {
            AbstractConstraint inner = ((NotConstraint)oldConstraint).getConstraint();
            inner = QueryOptimiser.reconstructAbstractConstraint(inner, precomputedSqlTable, valueMap, tableSet, groupBy, firstPrecompOrderBy, precompOrderBySize, orderByField, firstPrecompOrderByHasNoNulls, reverseOrderBy);
            return new NotConstraint(inner);
        }
        if (oldConstraint instanceof ConstraintSet) {
            Set<AbstractConstraint> cons = ((ConstraintSet)oldConstraint).getConstraints();
            ConstraintSet retval = new ConstraintSet();
            for (AbstractConstraint con : cons) {
                con = QueryOptimiser.reconstructAbstractConstraint(con, precomputedSqlTable, valueMap, tableSet, groupBy, firstPrecompOrderBy, precompOrderBySize, orderByField, firstPrecompOrderByHasNoNulls, reverseOrderBy);
                retval.add(con);
            }
            return retval;
        }
        if (oldConstraint instanceof SubQueryConstraint) {
            throw new UnsupportedOperationException("Need to think about SubQueryConstraints.");
        }
        if (oldConstraint instanceof InListConstraint) {
            AbstractValue left = ((InListConstraint)oldConstraint).getLeft();
            Set<Constant> right = ((InListConstraint)oldConstraint).getRight();
            left = QueryOptimiser.reconstructAbstractValue(left, precomputedSqlTable, valueMap, tableSet, groupBy);
            InListConstraint retval = new InListConstraint(left);
            retval.addAll(right);
            return retval;
        }
        throw new IllegalArgumentException("Unknown constraint type.");
    }

    public static void reconstructAbstractValues(Collection<AbstractValue> oldValues, Table precomputedSqlTable, Map<AbstractValue, SelectValue> valueMap, Set<AbstractTable> tableSet, boolean groupBy, Collection<AbstractValue> newValues) throws QueryOptimiserException {
        for (AbstractValue value : oldValues) {
            value = QueryOptimiser.reconstructAbstractValue(value, precomputedSqlTable, valueMap, tableSet, groupBy);
            newValues.add(value);
        }
    }

    public static <T> void addNonCoveredFrom(Set<T> input, Set<T> subtract, Set<T> output) {
        for (T inObj : input) {
            if (subtract.contains(inObj)) continue;
            output.add(inObj);
        }
    }

    protected static class AbstractTableComparator
    implements Comparator<AbstractTable> {
        @Override
        public int compare(AbstractTable a, AbstractTable b) {
            return a.equalsIgnoreAlias(b) ? 0 : -1;
        }
    }
}

