/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.precompute;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.intermine.sql.Database;
import org.intermine.sql.DatabaseUtil;
import org.intermine.sql.precompute.BestQuery;
import org.intermine.sql.precompute.OptimiserCache;
import org.intermine.sql.precompute.PrecomputedTable;
import org.intermine.sql.precompute.QueryOptimiser;
import org.intermine.sql.precompute.QueryOptimiserContext;
import org.intermine.sql.query.AbstractTable;
import org.intermine.sql.query.AbstractValue;
import org.intermine.sql.query.OrderDescending;
import org.intermine.sql.query.Query;
import org.intermine.sql.query.SelectValue;
import org.intermine.sql.query.Table;

public class PrecomputedTableManager {
    private static final Logger LOG = Logger.getLogger(PrecomputedTableManager.class);
    protected TreeSet<PrecomputedTable> precomputedTables = new TreeSet();
    protected Map<String, Map<String, PrecomputedTable>> types = new HashMap<String, Map<String, PrecomputedTable>>();
    protected Database database = null;
    protected Connection conn = null;
    protected static final String TABLE_INDEX = "precompute_index";
    protected static Map<Object, PrecomputedTableManager> instances = new HashMap<Object, PrecomputedTableManager>();

    protected PrecomputedTableManager(Connection conn) throws SQLException {
        if (conn == null) {
            throw new NullPointerException("conn cannot be null");
        }
        this.synchroniseWithDatabase(conn);
        this.conn = conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PrecomputedTableManager(Database database) throws SQLException {
        if (database == null) {
            throw new NullPointerException("database cannot be null");
        }
        Connection con = null;
        try {
            con = database.getConnection();
            con.setAutoCommit(true);
            this.synchroniseWithDatabase(con);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        this.database = database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrecomputedTableManager getInstance(Connection conn) throws SQLException {
        Map<Object, PrecomputedTableManager> map = instances;
        synchronized (map) {
            if (!instances.containsKey(conn)) {
                instances.put(conn, new PrecomputedTableManager(conn));
            }
        }
        return instances.get(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrecomputedTableManager getInstance(Database database) throws SQLException {
        Map<Object, PrecomputedTableManager> map = instances;
        synchronized (map) {
            if (!instances.containsKey(database)) {
                instances.put(database, new PrecomputedTableManager(database));
            }
        }
        return instances.get(database);
    }

    public void add(PrecomputedTable pt) throws SQLException {
        this.add(pt, null);
    }

    public void add(PrecomputedTable pt, Collection<String> indexes) throws SQLException {
        if (pt == null) {
            throw new NullPointerException("PrecomputedTable cannot be null");
        }
        String queryString = pt.getOriginalSql();
        Map<String, PrecomputedTable> queryStrings = this.types.get(pt.getCategory());
        if (queryStrings == null) {
            queryStrings = new HashMap<String, PrecomputedTable>();
            this.types.put(pt.getCategory(), queryStrings);
        }
        if (queryStrings.containsKey(queryString)) {
            throw new IllegalArgumentException("Precomputed table already exists");
        }
        this.addTableToDatabase(pt, indexes, true);
        this.precomputedTables.add(pt);
        queryStrings.put(queryString, pt);
    }

    public void dropEverything() throws SQLException {
        Iterator<PrecomputedTable> iter = this.precomputedTables.iterator();
        while (iter.hasNext()) {
            PrecomputedTable pt = iter.next();
            this.deleteTableFromDatabase(pt.getName());
            iter.remove();
        }
        this.types.clear();
    }

    public void dropAffected(Set<String> tablesAltered) throws SQLException {
        Iterator<PrecomputedTable> iter = this.precomputedTables.iterator();
        while (iter.hasNext()) {
            PrecomputedTable pt = iter.next();
            Query q = pt.getQuery();
            boolean drop = false;
            for (AbstractTable table : q.getFrom()) {
                if (!(table instanceof Table) || !tablesAltered.contains(((Table)table).getName())) continue;
                drop = true;
                break;
            }
            if (!drop) continue;
            this.deleteTableFromDatabase(pt.getName());
            iter.remove();
            String queryString = pt.getOriginalSql();
            Map<String, PrecomputedTable> queryStrings = this.types.get(pt.getCategory());
            queryStrings.remove(queryString);
        }
    }

    public void delete(PrecomputedTable pt) throws SQLException {
        if (pt == null) {
            throw new NullPointerException("PrecomputedTable cannot be null");
        }
        if (!this.precomputedTables.contains(pt)) {
            throw new IllegalArgumentException("Table is not valid: " + pt);
        }
        this.deleteTableFromDatabase(pt.getName());
        this.precomputedTables.remove(pt);
        String queryString = pt.getOriginalSql();
        Map<String, PrecomputedTable> queryStrings = this.types.get(pt.getCategory());
        queryStrings.remove(queryString);
    }

    public Set<PrecomputedTable> getPrecomputedTables() {
        return this.precomputedTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTableToDatabase(PrecomputedTable pt, Collection<String> indexes, boolean record) throws SQLException {
        Connection con = null;
        try {
            con = this.conn == null ? this.database.getConnection() : this.conn;
            con.setAutoCommit(true);
            if (indexes == null) {
                indexes = new LinkedHashSet<String>();
            }
            Statement stmt = con.createStatement();
            String sql = pt.getSQLString();
            BestQuery bq = QueryOptimiser.optimise(sql, null, this, con, QueryOptimiserContext.DEFAULT);
            sql = "CREATE TABLE " + pt.getName() + " AS " + bq.getBestQueryString();
            LOG.info((Object)("Creating new precomputed table " + sql));
            stmt.execute(sql);
            String orderByField = pt.getOrderByField();
            if (orderByField != null) {
                LOG.info((Object)("Creating orderby_field index on precomputed table " + pt.getName()));
                indexes.add(orderByField);
            } else {
                List<AbstractValue> orderBy = pt.getQuery().getOrderBy();
                if (!orderBy.isEmpty()) {
                    boolean needComma = false;
                    StringBuilder sb = new StringBuilder();
                    for (AbstractValue ob : orderBy) {
                        while (ob instanceof OrderDescending) {
                            ob = ((OrderDescending)ob).getValue();
                        }
                        if (needComma) {
                            sb.append(", ");
                        }
                        needComma = true;
                        SelectValue obv = pt.getValueMap().get(ob);
                        sb.append(obv.getAlias());
                    }
                    indexes.add(sb.toString());
                }
            }
            indexes = PrecomputedTableManager.canonicaliseIndexes(indexes);
            LOG.info((Object)("Creating " + indexes.size() + " indexes for " + pt.getName()));
            for (String indexName : indexes) {
                LOG.info((Object)("Creating index on " + pt.getName() + " (" + indexName + ")"));
                this.addIndex(pt.getName(), indexName, con);
                if (!indexName.startsWith("lower(")) continue;
                String newIndexName = indexName.replaceFirst("^lower\\(([^,]+)\\)(.*)", "lower($1) text_pattern_ops$2");
                this.addIndex(pt.getName(), newIndexName, con);
            }
            LOG.info((Object)("ANALYSEing precomputed table " + pt.getName()));
            con.createStatement().execute("ANALYSE " + pt.getName());
            if (record) {
                PreparedStatement pstmt = con.prepareStatement("INSERT INTO precompute_index VALUES(?,?,?)");
                pstmt.setString(1, pt.getName());
                pstmt.setString(2, pt.getOriginalSql());
                pstmt.setString(3, pt.getCategory());
                pstmt.execute();
            }
            LOG.info((Object)("Finished creating precomputed table " + pt.getName() + " for category " + pt.getCategory()));
        }
        finally {
            if (con != null && this.conn == null) {
                con.close();
            }
        }
    }

    protected static Set<String> canonicaliseIndexes(Collection<String> indexes) {
        LinkedHashSet<String> retval = new LinkedHashSet<String>();
        HashSet<String> indexesCovered = new HashSet<String>();
        for (String index : indexes) {
            if (indexesCovered.contains(index)) continue;
            String tmp = index;
            while (tmp != null) {
                indexesCovered.add(tmp);
                retval.remove(tmp);
                int pos = tmp.lastIndexOf(", ");
                if (pos >= 0) {
                    tmp = tmp.substring(0, pos);
                    continue;
                }
                tmp = null;
            }
            retval.add(index);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTableFromDatabase(String name) throws SQLException {
        OptimiserCache oc = OptimiserCache.getInstance(this.database);
        oc.flush();
        Connection con = null;
        try {
            con = this.conn == null ? this.database.getConnection() : this.conn;
            PreparedStatement pstmt = con.prepareStatement("DELETE FROM precompute_index WHERE name = ?");
            pstmt.setString(1, name);
            pstmt.execute();
            Statement stmt = con.createStatement();
            stmt.execute("DROP TABLE " + name);
            if (!con.getAutoCommit()) {
                con.commit();
            }
            LOG.info((Object)("Dropped precomputed table " + name));
        }
        finally {
            if (con != null && this.conn == null) {
                con.close();
            }
        }
    }

    protected void addIndex(String table, String field, Connection con) {
        int i;
        byte[] digest;
        MessageDigest md;
        String simpleTable;
        String simpleField = field;
        if (simpleField.charAt(0) == '\"') {
            simpleField = simpleField.substring(1, simpleField.length() - 1);
        }
        if ((simpleTable = table).length() > 30) {
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            md.update(simpleTable.getBytes());
            digest = md.digest();
            simpleTable = "";
            for (i = 0; i < 16; ++i) {
                simpleTable = simpleTable + (char)(97 + (digest[i] & 0xFF) * 26 / 256);
            }
        }
        if (simpleField.length() > 30) {
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            md.update(simpleField.getBytes());
            digest = md.digest();
            simpleField = "";
            for (i = 0; i < 16; ++i) {
                simpleField = simpleField + (char)(97 + (digest[i] & 0xFF) * 26 / 256);
            }
        } else {
            simpleField = simpleField.replace(',', '_').replace(' ', '_').replace('(', '_').replace(')', '_');
        }
        String sql = "CREATE INDEX " + simpleTable + "_" + simpleField + " ON " + table + " (" + (field.equals(field.toLowerCase()) ? field : "\"" + field + "\"") + ")";
        try {
            Statement stmt = con.createStatement();
            stmt.execute(sql);
        }
        catch (SQLException e) {
            LOG.warn((Object)("Error while executing " + sql), (Throwable)e);
        }
    }

    protected void synchroniseWithDatabase(Connection con) throws SQLException {
        if (!DatabaseUtil.tableExists(con, TABLE_INDEX)) {
            this.setupDatabase(con);
        }
        long start = System.currentTimeMillis();
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery("SELECT name, statement, category FROM precompute_index");
        int failedCount = 0;
        while (res.next()) {
            String tableName = res.getString(1);
            String queryString = res.getString(2);
            String category = res.getString(3);
            try {
                PrecomputedTable pt = new PrecomputedTable(new Query(queryString, true), queryString, tableName, category, con);
                this.precomputedTables.add(pt);
                Map<String, PrecomputedTable> queryStrings = this.types.get(category);
                if (queryStrings == null) {
                    queryStrings = new HashMap<String, PrecomputedTable>();
                    this.types.put(pt.getCategory(), queryStrings);
                }
                queryStrings.put(queryString, pt);
            }
            catch (IllegalArgumentException e) {
                ++failedCount;
            }
        }
        LOG.info((Object)("Loaded " + this.precomputedTables.size() + " precomputed table descriptions (plus " + failedCount + " failed) in " + (System.currentTimeMillis() - start) + " ms"));
    }

    protected void setupDatabase(Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        stmt.execute("CREATE TABLE precompute_index(name text, statement text, category text)");
        if (!con.getAutoCommit()) {
            con.commit();
        }
    }

    public PrecomputedTable lookupSql(String category, String sql) {
        Map<String, PrecomputedTable> queryStrings = this.types.get(category);
        if (queryStrings != null) {
            return queryStrings.get(sql);
        }
        return null;
    }

    public PrecomputedTable lookupSql(String sql) {
        for (Map<String, PrecomputedTable> queryStrings : this.types.values()) {
            PrecomputedTable pt = queryStrings.get(sql);
            if (pt == null) continue;
            return pt;
        }
        return null;
    }

    public Map<String, PrecomputedTable> lookupCategory(String category) {
        Map<String, PrecomputedTable> queryStrings = this.types.get(category);
        if (queryStrings == null) {
            queryStrings = new HashMap<String, PrecomputedTable>();
            this.types.put(category, queryStrings);
        }
        return queryStrings;
    }
}

