/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.precompute;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.intermine.sql.query.AbstractTable;
import org.intermine.sql.query.AbstractValue;
import org.intermine.sql.query.Field;
import org.intermine.sql.query.OrderDescending;
import org.intermine.sql.query.Query;
import org.intermine.sql.query.SQLStringable;
import org.intermine.sql.query.SelectValue;
import org.intermine.sql.query.Table;

public class PrecomputedTable
implements SQLStringable,
Comparable<PrecomputedTable> {
    private static final Logger LOG = Logger.getLogger(PrecomputedTable.class);
    public static final String ORDERBY_FIELD = "orderby_field";
    protected Query q;
    protected String originalSql;
    protected String name;
    protected String category;
    protected Map<AbstractValue, SelectValue> valueMap;
    protected String orderByField;
    protected String generationSqlString;
    protected boolean firstOrderByHasNoNulls = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PrecomputedTable(Query q, String originalSql, String name, String category, Connection conn) {
        if (q == null) {
            throw new NullPointerException("q cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("the name of a precomputed table cannot be null");
        }
        if (originalSql == null) {
            throw new NullPointerException("Original sql string cannot be null");
        }
        this.q = q;
        this.originalSql = originalSql;
        this.name = name;
        this.category = category;
        this.valueMap = new HashMap<AbstractValue, SelectValue>();
        for (SelectValue value : q.getSelect()) {
            this.valueMap.put(value.getValue(), value);
        }
        boolean useOrderByField = q.getOrderBy().size() > 1 && q.getUnion().size() == 1;
        try {
            ResultSet r;
            String columnName;
            String tableName;
            AbstractTable table;
            if (useOrderByField) {
                for (AbstractValue column : q.getOrderBy()) {
                    if (column instanceof OrderDescending) {
                        column = ((OrderDescending)column).getValue();
                    }
                    if (this.valueMap.containsKey(column)) {
                        if (column instanceof Field) {
                            table = ((Field)column).getTable();
                            if (table instanceof Table) {
                                block33: {
                                    tableName = ((Table)table).getName().toLowerCase();
                                    columnName = ((Field)column).getName().toLowerCase();
                                    r = conn.getMetaData().getColumns(null, null, tableName, columnName);
                                    if (r.next()) {
                                        if (tableName.equals(r.getString(3)) && columnName.equals(r.getString(4))) {
                                            int columnType = r.getInt(5);
                                            if (columnType != 5 && columnType != 4 && columnType != -5) {
                                                useOrderByField = false;
                                                LOG.debug((Object)("Cannot generate order field for precomputed table - column " + column.getSQLString() + " is type " + columnType));
                                                break;
                                            }
                                            break block33;
                                        } else {
                                            useOrderByField = false;
                                            LOG.warn((Object)("getColumns returned wrong data for column " + column.getSQLString()));
                                            break;
                                        }
                                    }
                                    useOrderByField = false;
                                    LOG.warn((Object)("getColumns return no data for column " + column.getSQLString() + " in table " + tableName));
                                    break;
                                }
                                if (!r.next()) continue;
                                useOrderByField = false;
                                LOG.warn((Object)("getColumns returned too much data for column " + column.getSQLString()));
                                break;
                            }
                            useOrderByField = false;
                            LOG.debug((Object)("Cannot generate order field for precomputed table -column " + column.getSQLString() + " does not belong to a Table"));
                            break;
                        }
                        useOrderByField = false;
                        LOG.debug((Object)("Cannot generate order field for precomputed table - column " + column.getSQLString() + " is not a Field"));
                        break;
                    }
                    useOrderByField = false;
                    LOG.debug((Object)("Cannot generate order field for precomputed table - column " + column.getSQLString() + " is not present in the precomputed" + " table"));
                    break;
                }
            }
            for (AbstractValue column : q.getOrderBy()) {
                block36: {
                    block35: {
                        if (column instanceof OrderDescending) {
                            column = ((OrderDescending)column).getValue();
                        }
                        if (!(column instanceof Field) || !((table = ((Field)column).getTable()) instanceof Table)) continue;
                        tableName = ((Table)table).getName().toLowerCase();
                        columnName = ((Field)column).getName().toLowerCase();
                        r = conn.getMetaData().getColumns(null, null, tableName, columnName);
                        if (!r.next()) break block35;
                        if (tableName.equals(r.getString(3)) && columnName.equals(r.getString(4))) {
                            int nullable = r.getInt(11);
                            if (0 == nullable) {
                                this.firstOrderByHasNoNulls = true;
                            }
                            break block36;
                        } else {
                            LOG.warn((Object)("getColumns returned wrong data for column " + column.getSQLString()));
                        }
                        break block36;
                    }
                    LOG.warn((Object)("getColumns returned no data for column " + column.getSQLString()));
                }
                if (!r.next()) continue;
                LOG.warn((Object)("getColumns returned too much data for column " + column.getSQLString()));
            }
        }
        catch (SQLException e) {
            useOrderByField = false;
            LOG.warn((Object)("Caught SQLException while examining order by fields: " + e));
        }
        if (!useOrderByField) {
            this.orderByField = null;
            this.generationSqlString = q.getSQLString();
            return;
        }
        this.orderByField = ORDERBY_FIELD;
        List<AbstractValue> orderBy = q.getOrderBy();
        StringBuffer extraBuffer = new StringBuffer();
        int i = 0;
        while (true) {
            if (i >= orderBy.size()) {
                extraBuffer.append(" AS orderby_field");
                this.generationSqlString = q.getSQLStringForPrecomputedTable(extraBuffer.toString());
                return;
            }
            AbstractValue newOrderByField = orderBy.get(i);
            if (newOrderByField instanceof OrderDescending) {
                newOrderByField = ((OrderDescending)newOrderByField).getValue();
                if (i == 0) {
                    extraBuffer.append("-");
                } else {
                    extraBuffer.append(" - ");
                }
            } else if (i != 0) {
                extraBuffer.append(" + ");
            }
            if (i < orderBy.size() - 1) {
                extraBuffer.append("(");
            }
            extraBuffer.append("COALESCE(" + newOrderByField.getSQLString() + "::numeric, 49999999999999999999)");
            if (i < orderBy.size() - 1) {
                extraBuffer.append(" * 1");
            }
            for (int o = 0; o < orderBy.size() - 1 - i; ++o) {
                extraBuffer.append("00000000000000000000");
            }
            if (i < orderBy.size() - 1) {
                extraBuffer.append(")");
            }
            ++i;
        }
    }

    public Query getQuery() {
        return this.q;
    }

    public String getOriginalSql() {
        return this.originalSql;
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public Map<AbstractValue, SelectValue> getValueMap() {
        return this.valueMap;
    }

    @Override
    public String getSQLString() {
        return this.generationSqlString;
    }

    public String getOrderByField() {
        return this.orderByField;
    }

    public boolean getFirstOrderByHasNoNulls() {
        return this.firstOrderByHasNoNulls;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PrecomputedTable) {
            PrecomputedTable objTable = (PrecomputedTable)obj;
            return this.q.equals(objTable.q) && this.name.equals(objTable.name);
        }
        return false;
    }

    public int hashCode() {
        return 3 * this.q.hashCode() + 5 * this.name.hashCode();
    }

    @Override
    public int compareTo(PrecomputedTable obj) {
        int retval = obj.q.getFrom().size() - this.q.getFrom().size();
        if (retval == 0) {
            retval = this.name.compareTo(obj.name);
        }
        return retval;
    }

    public String toString() {
        return this.name + "/" + this.category + " (" + this.q.getFrom().size() + " tables)";
    }
}

