/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.precompute;

public class OptimiserCacheLine {
    private static final double MAX_LIMIT_FACTOR = 4.0;
    private String optimised;
    private int limit;
    private String original;

    public OptimiserCacheLine(String optimised, int limit, String original) {
        this.optimised = optimised;
        this.limit = limit;
        this.original = original;
    }

    public double score(int limit) {
        double limitFactor = limit > this.limit ? Math.log(limit) - Math.log(this.limit) : Math.log(this.limit) - Math.log(limit);
        return limitFactor / Math.log(4.0);
    }

    public String getOptimised() {
        return this.optimised;
    }

    public String getOriginal() {
        return this.original;
    }
}

