/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.precompute;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.intermine.sql.Database;
import org.intermine.sql.precompute.OptimiserCacheLine;
import org.intermine.util.CacheMap;

public class OptimiserCache {
    public static final int MAX_LINESETS = 1000;
    public static final int EXPIRE_INTERVAL = 100;
    private static Map<Database, OptimiserCache> caches = new HashMap<Database, OptimiserCache>();
    protected Map<String, Set<OptimiserCacheLine>> cacheLines = new CacheMap<String, Set<OptimiserCacheLine>>();

    public static synchronized OptimiserCache getInstance(Database db) {
        if (!caches.containsKey(db)) {
            caches.put(db, new OptimiserCache());
        }
        return caches.get(db);
    }

    public synchronized void flush() {
        this.cacheLines.clear();
    }

    public synchronized void addCacheLine(String original, String optimised, int limit) {
        Set<OptimiserCacheLine> lines;
        if (original.toUpperCase().startsWith("EXPLAIN ")) {
            original = original.substring(8);
        }
        if (optimised.toUpperCase().startsWith("EXPLAIN ")) {
            optimised = optimised.substring(8);
        }
        if ((lines = this.cacheLines.get(original)) == null) {
            lines = new HashSet<OptimiserCacheLine>();
            this.cacheLines.put(original, lines);
        }
        OptimiserCacheLine line = new OptimiserCacheLine(optimised, limit, original);
        lines.add(line);
    }

    public synchronized String lookup(String original, int limit) {
        Set<OptimiserCacheLine> lines;
        boolean originalWasExplain = false;
        if (original.toUpperCase().startsWith("EXPLAIN ")) {
            original = original.substring(8);
            originalWasExplain = true;
        }
        if ((lines = this.cacheLines.get(original)) == null) {
            return null;
        }
        double bestScore = Double.POSITIVE_INFINITY;
        OptimiserCacheLine bestLine = null;
        for (OptimiserCacheLine line : lines) {
            double score = line.score(limit);
            if (!(score < bestScore)) continue;
            bestScore = score;
            bestLine = line;
        }
        if (bestScore > 1.0) {
            return null;
        }
        return (originalWasExplain ? "EXPLAIN " : "") + bestLine.getOptimised();
    }
}

