/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.precompute;

import java.sql.Connection;
import java.sql.SQLException;
import org.intermine.sql.precompute.BestQueryException;
import org.intermine.sql.precompute.BestQueryExplainer;
import org.intermine.sql.query.ExplainResult;
import org.intermine.sql.query.Query;

public class BestQueryExplainerVerbose
extends BestQueryExplainer {
    private int unexplained = 0;

    public BestQueryExplainerVerbose(Connection con, long timeLimit) {
        super(con, timeLimit);
    }

    @Override
    protected ExplainResult getExplainResult(Query q) throws SQLException {
        if (this.unexplained != 0) {
            System.out.println("Did not explain " + this.unexplained + " queries");
            this.unexplained = 0;
        }
        long startTime = System.currentTimeMillis();
        ExplainResult retval = ExplainResult.getInstance(q, this.con);
        System.out.println("Optimiser: Explained query " + q + ", took " + (System.currentTimeMillis() - startTime) + " ms, " + retval.toString());
        return retval;
    }

    @Override
    protected ExplainResult getExplainResult(String q) throws SQLException {
        if (this.unexplained != 0) {
            System.out.println("Did not explain " + this.unexplained + " queries");
            this.unexplained = 0;
        }
        long startTime = System.currentTimeMillis();
        ExplainResult retval = ExplainResult.getInstance(q, this.con);
        System.out.println("Optimiser: Explained query " + q + ", took " + (System.currentTimeMillis() - startTime) + " ms, " + retval.toString());
        return retval;
    }

    @Override
    protected void didNotExplain(BestQueryExplainer.Candidate c) {
        ++this.unexplained;
    }

    @Override
    public void throwBestQueryException(String message) throws BestQueryException {
        System.out.println(message);
        super.throwBestQueryException(message);
    }
}

