/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.precompute;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.intermine.sql.precompute.BestQuery;
import org.intermine.sql.precompute.BestQueryException;
import org.intermine.sql.query.ExplainResult;
import org.intermine.sql.query.Query;

public class BestQueryExplainer
extends BestQuery {
    private static final int OVERHEAD = 300;
    protected static final int ALWAYS_EXPLAIN_TABLES = 3;
    protected static final int NEVER_EXPLAIN_TABLES = 8;
    protected List<Candidate> candidates = new ArrayList<Candidate>();
    protected int candidateTables = Integer.MAX_VALUE;
    protected Candidate bestCandidate;
    protected Connection con;
    protected Date start = new Date();
    protected long timeLimit = 0L;

    public BestQueryExplainer() {
        this.timeLimit = -1L;
    }

    public BestQueryExplainer(Connection con, long timeLimit) {
        if (con == null) {
            throw new NullPointerException();
        }
        this.con = con;
        this.timeLimit = timeLimit;
    }

    @Override
    public void add(Query q) throws BestQueryException, SQLException {
        Candidate c = new Candidate(q);
        this.add(c);
    }

    @Override
    public void add(String q) throws BestQueryException, SQLException {
        Candidate c = new Candidate(q);
        this.add(c);
    }

    protected void add(Candidate c) throws BestQueryException, SQLException {
        boolean doExplain;
        int tableCount = c.getTableCount();
        boolean bl = doExplain = tableCount <= 3;
        if (tableCount < this.candidateTables) {
            this.candidateTables = tableCount;
            this.candidates.clear();
            if (tableCount < 8) {
                doExplain = true;
            }
        }
        if (doExplain) {
            if (c.betterThan(this.bestCandidate)) {
                this.bestCandidate = c;
            }
        } else {
            this.didNotExplain(c);
            if (tableCount == this.candidateTables) {
                this.candidates.add(c);
            }
        }
        long elapsed = System.currentTimeMillis() - this.start.getTime();
        if (this.timeLimit >= 0L && elapsed > this.timeLimit) {
            this.throwBestQueryException("Optimiser reached time limit (limit = " + this.timeLimit + "ms, elapsed = " + elapsed + "ms)");
        }
        if (this.bestCandidate != null && this.bestCandidate.getExplain().getTime() < elapsed + 300L) {
            this.throwBestQueryException("Explain time: " + this.bestCandidate.getExplain().getTime() + ", elapsed time: " + elapsed);
        }
    }

    protected ExplainResult getExplainResult(Query q) throws SQLException {
        return ExplainResult.getInstance(q, this.con);
    }

    protected ExplainResult getExplainResult(String q) throws SQLException {
        return ExplainResult.getInstance(q, this.con);
    }

    protected void didNotExplain(Candidate c) {
    }

    @Override
    public Query getBestQuery() throws SQLException {
        Candidate best = this.getBest();
        if (best == null) {
            return null;
        }
        return best.getQuery();
    }

    @Override
    public String getBestQueryString() throws SQLException {
        Candidate best = this.getBest();
        if (best == null) {
            return null;
        }
        return best.getQueryString();
    }

    public ExplainResult getBestExplainResult() throws SQLException {
        Candidate best = this.getBest();
        if (best == null) {
            return null;
        }
        return best.getExplain();
    }

    protected Candidate getBest() throws SQLException {
        Iterator<Candidate> iter = this.candidates.iterator();
        while (iter.hasNext()) {
            if (this.bestCandidate != null) {
                long elapsed = System.currentTimeMillis() - this.start.getTime();
                if (this.timeLimit >= 0L && elapsed > this.timeLimit) {
                    return this.bestCandidate;
                }
                if (this.bestCandidate.getExplain().getTime() < elapsed + 300L) {
                    return this.bestCandidate;
                }
            }
            Candidate c = iter.next();
            iter.remove();
            if (!c.betterThan(this.bestCandidate)) continue;
            this.bestCandidate = c;
        }
        return this.bestCandidate;
    }

    public void throwBestQueryException(String message) throws BestQueryException {
        throw new BestQueryException(message);
    }

    protected class Candidate {
        protected String queryString;
        protected Query query;
        protected ExplainResult explainResult = null;
        protected int tableCount;

        public Candidate(String queryString) {
            this.queryString = queryString;
            this.query = null;
            String afterFrom = queryString.substring(queryString.lastIndexOf(" FROM ") + 6);
            int wherePos = afterFrom.indexOf(" WHERE ");
            if (wherePos == -1) {
                wherePos = afterFrom.indexOf(" GROUP BY ");
            }
            if (wherePos == -1) {
                wherePos = afterFrom.indexOf(" HAVING ");
            }
            if (wherePos == -1) {
                wherePos = afterFrom.indexOf(" ORDER BY ");
            }
            if (wherePos != -1) {
                afterFrom = afterFrom.substring(0, wherePos);
            }
            this.tableCount = 1;
            int commaPos = afterFrom.indexOf(", ");
            while (commaPos != -1) {
                afterFrom = afterFrom.substring(commaPos + 2);
                ++this.tableCount;
                commaPos = afterFrom.indexOf(", ");
            }
        }

        public Candidate(Query query) {
            this.query = query;
            this.queryString = null;
            this.tableCount = query.getFrom().size();
        }

        public int getTableCount() {
            return this.tableCount;
        }

        public String getQueryString() {
            return this.queryString == null ? this.query.getSQLString() : this.queryString;
        }

        public Query getQuery() {
            return this.query == null ? new Query(this.queryString) : this.query;
        }

        public ExplainResult getExplain() throws SQLException {
            if (this.explainResult == null) {
                this.explainResult = this.query == null ? BestQueryExplainer.this.getExplainResult(this.queryString) : BestQueryExplainer.this.getExplainResult(this.query);
            }
            return this.explainResult;
        }

        public boolean betterThan(Candidate c) throws SQLException {
            return c == null ? true : this.getExplain().getTime() < c.getExplain().getTime();
        }

        public String toString() {
            return "tables = " + this.tableCount + (this.query != null ? ", query = " + this.query : ", queryString = " + this.queryString);
        }
    }
}

