/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql.logging;

import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.intermine.util.StringUtil;

public class DatabaseWriter
extends Writer {
    protected Connection con;
    protected String table;
    protected StringBuffer sb = new StringBuffer();
    protected int fields = 0;

    public DatabaseWriter() {
    }

    public DatabaseWriter(Connection con, String table) {
        if (con == null) {
            throw new NullPointerException("Connection cannot be null");
        }
        if (table == null) {
            throw new NullPointerException("Database table cannot be null");
        }
        this.con = con;
        this.table = table;
    }

    @Override
    public void write(char[] cbuff, int off, int len) throws IOException {
        if (cbuff == null) {
            return;
        }
        this.sb.append(cbuff, off, len);
        ArrayList<String> rows = new ArrayList<String>();
        int index = -1;
        while ((index = this.sb.indexOf(System.getProperty("line.separator"))) != -1) {
            rows.add(this.sb.substring(0, index));
            if (index >= this.sb.length()) continue;
            this.sb = new StringBuffer(this.sb.substring(index + 1));
        }
        this.writeRows(rows);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    protected String createSQLStatement(String table, String row) {
        if (table == null || row == null) {
            throw new NullPointerException("Arguments to createSQLStatement must not be null");
        }
        this.fields = StringUtil.countOccurances("\t", row) + 1;
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(table).append(" VALUES(");
        for (int i = 0; i < this.fields; ++i) {
            sql.append("?");
            if (i == this.fields - 1) continue;
            sql.append(", ");
        }
        sql.append(")");
        return sql.toString();
    }

    private void writeRows(List<String> rows) throws IOException {
        boolean autoCommit = false;
        if (rows.size() == 0) {
            return;
        }
        try {
            autoCommit = this.con.getAutoCommit();
            PreparedStatement pstmt = this.con.prepareStatement(this.createSQLStatement(this.table, rows.get(0)));
            for (String row : rows) {
                StringTokenizer st = new StringTokenizer(row, "\t", false);
                int j = 1;
                while (st.hasMoreTokens()) {
                    pstmt.setString(j++, st.nextToken().trim());
                }
                if (j <= this.fields) {
                    throw new IOException("Too few fields");
                }
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            this.con.commit();
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            try {
                this.con.setAutoCommit(autoCommit);
            }
            catch (SQLException e) {}
        }
    }
}

