/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.CollectionDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.proxy.ProxyReference;
import org.intermine.sql.Database;
import org.intermine.sql.writebatch.BatchWriterPostgresCopyImpl;
import org.intermine.sql.writebatch.FlushJob;
import org.intermine.sql.writebatch.TableBatch;
import org.intermine.util.StringUtil;
import org.intermine.util.TypeUtil;

public final class DatabaseUtil {
    private static final Logger LOG = Logger.getLogger(DatabaseUtil.class);
    private static final Set<String> RESERVED_WORDS = new HashSet<String>(Arrays.asList("ABS", "ABSOLUTE", "ACTION", "ADD", "ADMIN", "AFTER", "AGGREGATE", "ALIAS", "ALL", "ALLOCATE", "ALTER", "ANALYSE", "ANALYZE", "AND", "ANY", "ARE", "ARRAY", "AS", "ASC", "ASENSITIVE", "ASSERTION", "ASYMMETRIC", "AT", "ATOMIC", "AUTHORIZATION", "AVG", "BEFORE", "BEGIN", "BETWEEN", "BIGINT", "BINARY", "BIT", "BIT_LENGTH", "BLOB", "BOOLEAN", "BOTH", "BREADTH", "BY", "CALL", "CALLED", "CARDINALITY", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CEIL", "CEILING", "CHAR", "CHARACTER", "CHARACTER_LENGTH", "CHAR_LENGTH", "CHECK", "CLASS", "CLOB", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLLECT", "COLUMN", "COMMIT", "COMPLETION", "CONDITION", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONSTRUCTOR", "CONTINUE", "CONVERT", "CORR", "CORRESPONDING", "COUNT", "COVAR_POP", "COVAR_SAMP", "CREATE", "CROSS", "CUBE", "CUME_DIST", "CURRENT", "CURRENT_DATE", "CURRENT_DEFAULT_TRAN", "CURRENT_PATH", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_TRANSFORM_GR", "CURRENT_USER", "CURSOR", "CYCLE", "DATA", "DATABASE", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DENSE_RANK", "DEPTH", "DEREF", "DESC", "DESCRIBE", "DESCRIPTOR", "DESTROY", "DESTRUCTOR", "DETERMINISTIC", "DIAGNOSTICS", "DICTIONARY", "DISCONNECT", "DISTINCT", "DO", "DOMAIN", "DOUBLE", "DROP", "DYNAMIC", "EACH", "ELEMENT", "ELSE", "END", "END-EXEC", "EQUALS", "ESCAPE", "EVERY", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXP", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FILTER", "FIRST", "FLOAT", "FLOOR", "FOR", "FOREIGN", "FOUND", "FREE", "FREEZE", "FROM", "FULL", "FUNCTION", "FUSION", "GENERAL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "GROUPING", "HAVING", "HOLD", "HOST", "HOUR", "IDENTITY", "IGNORE", "ILIKE", "IMMEDIATE", "IN", "INDICATOR", "INITIALIZE", "INITIALLY", "INNER", "INOUT", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERSECTION", "INTERVAL", "INTO", "IS", "ISNULL", "ISOLATION", "ITERATE", "JOIN", "KEY", "LANGUAGE", "LARGE", "LAST", "LATERAL", "LEADING", "LEFT", "LESS", "LEVEL", "LIKE", "LIMIT", "LN", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCATOR", "LOWER", "MAP", "MATCH", "MAX", "MEMBER", "MERGE", "METHOD", "MIN", "MINUTE", "MOD", "MODIFIES", "MODIFY", "MODULE", "MONTH", "MULTISET", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NCLOB", "NEW", "NEXT", "NO", "NONE", "NORMALIZE", "NOT", "NOTNULL", "NULL", "NULLIF", "NUMERIC", "OBJECT", "OBJECTCLASS", "OCTET_LENGTH", "OF", "OFF", "OFFSET", "OLD", "ON", "ONLY", "OPEN", "OPERATION", "OPTION", "OR", "ORDER", "ORDINALITY", "OUT", "OUTER", "OUTPUT", "OVER", "OVERLAPS", "OVERLAY", "PAD", "PARAMETER", "PARAMETERS", "PARTIAL", "PARTITION", "PATH", "PERCENTILE_CONT", "PERCENTILE_DISC", "PERCENT_RANK", "PLACING", "POSITION", "POSTFIX", "POWER", "PRECISION", "PREFIX", "PREORDER", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "RANGE", "READ", "READS", "REAL", "RECURSIVE", "REF", "REFERENCES", "REFERENCING", "REGR_AVGX", "REGR_AVGY", "REGR_COUNT", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXX", "REGR_SXY", "REGR_SYY", "RELATIVE", "RELEASE", "RESTRICT", "RESULT", "RETURN", "RETURNS", "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROLLUP", "ROUTINE", "ROW", "ROWS", "ROW_NUMBER", "SAVEPOINT", "SCHEMA", "SCOPE", "SCROLL", "SEARCH", "SECOND", "SECTION", "SELECT", "SENSITIVE", "SEQUENCE", "SESSION", "SESSION_USER", "SET", "SETOF", "SETS", "SIMILAR", "SIZE", "SMALLINT", "SOME", "SPACE", "SPECIFIC", "SPECIFICTYPE", "SQL", "SQLCODE", "SQLERROR", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "SQRT", "START", "STATE", "STATEMENT", "STATIC", "STDDEV_POP", "STDDEV_SAMP", "STRUCTURE", "SUBMULTISET", "SUBSTRING", "SUM", "SYMMETRIC", "SYSTEM", "SYSTEM_USER", "TABLE", "TABLESAMPLE", "TEMPORARY", "TERMINATE", "THAN", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TREAT", "TRIGGER", "TRIM", "TRUE", "UESCAPE", "UNDER", "UNION", "UNIQUE", "UNKNOWN", "UNNEST", "UPDATE", "UPPER", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARIABLE", "VARYING", "VAR_POP", "VAR_SAMP", "VERBOSE", "VIEW", "WHEN", "WHENEVER", "WHERE", "WIDTH_BUCKET", "WINDOW", "WITH", "WITHIN", "WITHOUT", "WORK", "WRITE", "YEAR", "ZONE"));

    private DatabaseUtil() {
    }

    public static boolean tableExists(Connection con, String tableName) throws SQLException {
        if (tableName == null) {
            throw new NullPointerException("tableName cannot be null");
        }
        ResultSet res = con.getMetaData().getTables(null, null, tableName, null);
        while (res.next()) {
            if (!res.getString(3).equals(tableName) || !"TABLE".equals(res.getString(4))) continue;
            return true;
        }
        return false;
    }

    public static boolean columnExists(Connection con, String tableName, String columnName) throws SQLException {
        if (tableName == null) {
            throw new NullPointerException("tableName cannot be null");
        }
        if (columnName == null) {
            throw new NullPointerException("columnName cannot be null");
        }
        ResultSet res = con.getMetaData().getColumns(null, null, tableName, columnName);
        while (res.next()) {
            if (!res.getString(3).equals(tableName) || !res.getString(4).equals(columnName)) continue;
            return true;
        }
        return false;
    }

    public static void removeAllTables(Connection con) throws SQLException {
        ResultSet res = con.getMetaData().getTables(null, null, "%", null);
        HashSet<String> tablenames = new HashSet<String>();
        while (res.next()) {
            String tablename = res.getString(3);
            if (!"TABLE".equals(res.getString(4))) continue;
            tablenames.add(tablename);
        }
        for (String tablename : tablenames) {
            LOG.info((Object)("Dropping table " + tablename));
            con.createStatement().execute("DROP TABLE " + tablename);
        }
    }

    public static String getTableName(ClassDescriptor cld) {
        return DatabaseUtil.generateSqlCompatibleName(cld.getUnqualifiedName());
    }

    public static String getColumnName(FieldDescriptor fd) {
        if (fd instanceof AttributeDescriptor) {
            return DatabaseUtil.generateSqlCompatibleName(fd.getName());
        }
        if (fd instanceof CollectionDescriptor) {
            return null;
        }
        if (fd instanceof ReferenceDescriptor) {
            return fd.getName() + "Id";
        }
        return null;
    }

    public static String getIndirectionTableName(CollectionDescriptor col) {
        String name2;
        if (4 != col.relationType()) {
            throw new IllegalArgumentException("Argument must be a CollectionDescriptor for a many-to-many relation");
        }
        String name1 = DatabaseUtil.getInwardIndirectionColumnName(col, 0);
        return name1.compareTo(name2 = DatabaseUtil.getOutwardIndirectionColumnName(col, 0)) < 0 ? name1 + name2 : name2 + name1;
    }

    public static String getInwardIndirectionColumnName(CollectionDescriptor col, int version) {
        if (4 != col.relationType()) {
            throw new IllegalArgumentException("Argument must be a CollectionDescriptor for a many-to-many relation");
        }
        if (version == 0) {
            return StringUtil.capitalise(DatabaseUtil.generateSqlCompatibleName(col.getName()));
        }
        if (version == 1) {
            ReferenceDescriptor rd = col.getReverseReferenceDescriptor();
            String colName = rd == null ? TypeUtil.unqualifiedName(col.getClassDescriptor().getName()) : rd.getName();
            return StringUtil.capitalise(DatabaseUtil.generateSqlCompatibleName(colName));
        }
        throw new IllegalArgumentException("Database version number " + version + " not recognised");
    }

    public static String getOutwardIndirectionColumnName(CollectionDescriptor col, int version) {
        if (4 != col.relationType()) {
            throw new IllegalArgumentException("Argument must be a CollectionDescriptor for a many-to-many relation");
        }
        if (version == 0) {
            ReferenceDescriptor rd = col.getReverseReferenceDescriptor();
            String colName = rd == null ? TypeUtil.unqualifiedName(col.getClassDescriptor().getName()) : rd.getName();
            return StringUtil.capitalise(DatabaseUtil.generateSqlCompatibleName(colName));
        }
        if (version == 1) {
            return StringUtil.capitalise(DatabaseUtil.generateSqlCompatibleName(col.getName()));
        }
        throw new IllegalArgumentException("Database version number " + version + " not recognised");
    }

    public static String generateSqlCompatibleName(String n) {
        String upper = n.toUpperCase();
        if (upper.startsWith("INTERMINE_") || RESERVED_WORDS.contains(upper)) {
            return "intermine_" + n;
        }
        return n;
    }

    public static String objectToString(Object o) {
        if (o instanceof Float) {
            return o.toString() + "::REAL";
        }
        if (o instanceof Number) {
            return o.toString();
        }
        if (o instanceof String) {
            String s = (String)o;
            if (s.indexOf(92) != -1) {
                return "E'" + StringUtil.escapeWithBackslashes(s) + "'";
            }
            return "'" + StringUtil.duplicateQuotes(s) + "'";
        }
        if (o instanceof CharSequence) {
            return DatabaseUtil.objectToString(((Object)((CharSequence)o)).toString());
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? "'true'" : "'false'";
        }
        if (o instanceof Class) {
            return DatabaseUtil.objectToString(((Class)o).getName());
        }
        if (o == null) {
            return "NULL";
        }
        throw new IllegalArgumentException("Can't convert " + o + " into an SQL String");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void analyse(Database db, boolean full) throws SQLException {
        Connection conn = db.getConnection();
        boolean autoCommit = conn.getAutoCommit();
        try {
            conn.setAutoCommit(true);
            Statement s = conn.createStatement();
            if (full) {
                s.execute("VACUUM FULL ANALYSE");
            } else {
                s.execute("ANALYSE");
            }
            conn.setAutoCommit(autoCommit);
        }
        finally {
            conn.setAutoCommit(autoCommit);
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void analyse(Database db, ClassDescriptor cld, boolean full) throws SQLException {
        HashSet<String> tables = new HashSet<String>();
        tables.add(DatabaseUtil.getTableName(cld));
        tables.addAll(DatabaseUtil.getIndirectionTableNames(cld));
        Connection conn = db.getConnection();
        boolean autoCommit = conn.getAutoCommit();
        try {
            conn.setAutoCommit(true);
            Statement s = conn.createStatement();
            for (String table : tables) {
                String sql;
                if (full) {
                    sql = "VACUUM FULL ANALYSE " + table;
                    LOG.info((Object)sql);
                    s.execute(sql);
                    continue;
                }
                sql = "ANALYSE " + table;
                LOG.info((Object)sql);
                s.execute(sql);
            }
            conn.setAutoCommit(autoCommit);
        }
        finally {
            conn.setAutoCommit(autoCommit);
            conn.close();
        }
    }

    public static Set<String> getIndirectionTableNames(ClassDescriptor cld) {
        HashSet<String> tables = new HashSet<String>();
        for (CollectionDescriptor col : cld.getAllCollectionDescriptors()) {
            if (4 != col.relationType()) continue;
            tables.add(DatabaseUtil.getIndirectionTableName(col));
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void grant(Database db, String user, String perm) throws SQLException {
        Connection conn = db.getConnection();
        boolean autoCommit = conn.getAutoCommit();
        try {
            conn.setAutoCommit(true);
            Statement s = conn.createStatement();
            ResultSet res = conn.getMetaData().getTables(null, null, null, null);
            while (res.next()) {
                if (!"TABLE".equals(res.getString(4))) continue;
                String sql = "GRANT " + perm + " ON " + res.getString(3) + " TO " + user;
                LOG.debug((Object)sql);
                s.execute(sql);
            }
            conn.setAutoCommit(autoCommit);
        }
        finally {
            conn.setAutoCommit(autoCommit);
            conn.close();
        }
    }

    public static void createBagTable(Database db, Connection con, String tableName, Collection<?> bag, Class<?> c) throws SQLException {
        String typeString;
        if (InterMineObject.class.isAssignableFrom(c)) {
            typeString = db.getColumnTypeString(Integer.class);
        } else {
            typeString = db.getColumnTypeString(c);
            if (typeString == null) {
                throw new IllegalArgumentException("unknown Class passed to createBagTable(): " + c.getName());
            }
        }
        String tableCreateSql = "CREATE TABLE " + tableName + " (value " + typeString + ")";
        Statement s = con.createStatement();
        s.execute(tableCreateSql);
        TableBatch tableBatch = new TableBatch();
        String[] colNames = new String[]{"value"};
        for (Object o : bag) {
            if (!c.isInstance(o) && (!InterMineObject.class.isAssignableFrom(c) || !ProxyReference.class.isInstance(o))) continue;
            if (o instanceof InterMineObject) {
                o = ((InterMineObject)o).getId();
            } else if (o instanceof Date) {
                o = new Long(((Date)o).getTime());
            }
            tableBatch.addRow(o, colNames, new Object[]{o});
        }
        List<FlushJob> flushJobs = new BatchWriterPostgresCopyImpl().write(con, Collections.singletonMap(tableName, tableBatch), null);
        for (FlushJob fj : flushJobs) {
            fj.flush();
        }
        String indexCreateSql = "CREATE INDEX " + tableName + "_index ON " + tableName + "(value)";
        s.execute(indexCreateSql);
        s.execute("ANALYSE " + tableName);
    }

    public static void createBagValuesTables(Connection con) throws SQLException {
        String sqlTable = "CREATE TABLE bagvalues (savedbagid integer, value text, extra text)";
        String sqlIndex = "CREATE UNIQUE INDEX bagvalues_index1 ON bagvalues (savedbagid, value, extra)";
        con.createStatement().execute(sqlTable);
        con.createStatement().execute(sqlIndex);
    }

    public static boolean isBagValuesEmpty(Connection con) throws SQLException {
        String sqlCount = "select count(*) from bagvalues";
        ResultSet result = con.createStatement().executeQuery(sqlCount);
        result.next();
        int bagValuesSize = result.getInt(1);
        return bagValuesSize == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addColumn(Database database, String tableName, String columnName, Type type) throws SQLException {
        Connection connection = database.getConnection();
        if (DatabaseUtil.tableExists(connection, tableName)) {
            try {
                DatabaseUtil.addColumn(connection, tableName, columnName, type);
            }
            finally {
                connection.close();
            }
        }
    }

    public static void addColumn(Connection con, String tableName, String columnName, Type type) throws SQLException {
        if (!DatabaseUtil.tableExists(con, tableName)) {
            throw new IllegalArgumentException("there is no table named " + tableName + " in this" + " database to add a new column to");
        }
        if (DatabaseUtil.columnExists(con, tableName, columnName)) {
            return;
        }
        if (!DatabaseUtil.isLegalColumnName(columnName)) {
            throw new IllegalArgumentException("This is not a legal column name: " + columnName);
        }
        String sql = "ALTER TABLE " + tableName + " ADD COLUMN " + columnName + " " + type.getSQLType();
        PreparedStatement stmt = con.prepareStatement(sql);
        LOG.info((Object)stmt.toString());
        stmt.executeUpdate();
    }

    protected static boolean isLegalColumnName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return false;
        }
        boolean isValid = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            isValid = isValid && (CharUtils.isAsciiAlphaLower((char)c) || CharUtils.isAsciiNumeric((char)c) || c == '_');
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateColumnValue(Database database, String tableName, String columnName, Object newValue) throws SQLException {
        Connection connection = database.getConnection();
        try {
            DatabaseUtil.updateColumnValue(connection, tableName, columnName, newValue);
        }
        finally {
            connection.close();
        }
    }

    public static void updateColumnValue(Connection con, String tableName, String columnName, Object newValue) throws SQLException {
        if (DatabaseUtil.columnExists(con, tableName, columnName)) {
            String sql = "UPDATE " + tableName + " SET " + columnName + " = ?";
            PreparedStatement stmt = con.prepareStatement(sql);
            stmt.setObject(1, newValue);
            LOG.info((Object)stmt.toString());
            stmt.executeUpdate();
        }
    }

    public static boolean verifyColumnType(Connection con, String tableName, String columnName, int columnType) {
        try {
            ResultSet res;
            if (DatabaseUtil.tableExists(con, tableName) && (res = con.getMetaData().getColumns(null, null, tableName, columnName)).next()) {
                return res.getString(3).equals(tableName) && columnName.equals(res.getString(4)) && res.getInt(5) == columnType;
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        return true;
    }

    public static enum Type {
        text("TEXT"),
        integer("integer"),
        bigint("bigint"),
        real("real"),
        double_precision("double precision"),
        timestamp("timestamp"),
        boolean_type("boolean");

        private final String sqlType;

        private Type(String sqlType) {
            this.sqlType = sqlType;
        }

        String getSQLType() {
            return this.sqlType;
        }
    }
}

