/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql;

import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.intermine.sql.Database;
import org.intermine.util.PropertiesUtil;
import org.intermine.util.WeakReferenceHashMap;

public final class DatabaseFactory {
    protected static Map<String, Database> databases = new WeakReferenceHashMap<String, Database>();

    private DatabaseFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Database getDatabase(String instance) throws SQLException, ClassNotFoundException {
        Database database;
        Map<String, Database> map = databases;
        synchronized (map) {
            if (databases.containsKey(instance)) {
                database = databases.get(instance);
            } else {
                Properties props = PropertiesUtil.getPropertiesStartingWith(instance);
                try {
                    database = new Database(PropertiesUtil.stripStart(instance, props));
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to initialise " + instance, e);
                }
            }
        }
        databases.put(instance, database);
        return database;
    }
}

