/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.sql;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.intermine.util.ShutdownHook;
import org.intermine.util.Shutdownable;
import org.intermine.util.StringUtil;
import org.postgresql.ds.PGPoolingDataSource;
import org.postgresql.jdbc2.optional.PoolingDataSource;
import org.postgresql.util.PSQLException;

public class Database
implements Shutdownable {
    private static final Logger LOG = Logger.getLogger(Database.class);
    protected DataSource datasource;
    protected String platform;
    protected String driver;
    protected int parallel = 4;
    protected Properties settings;
    private static final Map<Class<?>, String> POSTGRESQL_TYPE_STRING_MAP = new HashMap();
    private Set<SqlJob> pending = new HashSet<SqlJob>();
    private Set<Waiter> waiters = new HashSet<Waiter>();
    private ArrayBlockingQueue<SqlJob> queue = new ArrayBlockingQueue(30);
    private Set<Worker> workers = new HashSet<Worker>();
    private Exception reportedException = null;
    private int threadNo = 1;

    protected Database() {
    }

    protected Database(Properties props) throws ClassNotFoundException {
        this.settings = props;
        this.configure(props);
        try {
            LOG.info((Object)("Creating new Database " + this.getURL() + "(" + this.toString() + ") with ClassLoader " + this.getClass().getClassLoader() + " and parallelism " + this.parallel));
        }
        catch (Exception e) {
            LOG.info((Object)("Creating new invalid Database with ClassLoader " + this.getClass().getClassLoader()), (Throwable)e);
        }
        ShutdownHook.registerObject(new WeakReference<Database>(this));
    }

    public DataSource getDataSource() {
        return this.datasource;
    }

    public Connection getConnection() throws SQLException {
        Connection retval;
        if (this.datasource == null) {
            throw new NullPointerException("Datasource is null. Properties are: " + this.settings);
        }
        try {
            retval = this.datasource.getConnection();
        }
        catch (PSQLException e) {
            throw new RuntimeException("can't open datasource for " + this, e);
        }
        return retval;
    }

    @Override
    public void shutdown() {
        if (this.datasource instanceof PGPoolingDataSource) {
            LOG.info((Object)("Shutdown - Closing datasource for Database " + this.getURL() + "(" + this.toString() + ") with ClassLoader " + this.getClass().getClassLoader()));
            ((PGPoolingDataSource)this.datasource).close();
        } else if (this.datasource instanceof PoolingDataSource) {
            LOG.info((Object)("Shutdown - Closing datasource for Database " + this.getURL() + "(" + this.toString() + ") with ClassLoader " + this.getClass().getClassLoader()));
            ((PoolingDataSource)this.datasource).close();
        } else {
            LOG.warn((Object)("Shutdown - Could not close datasource for Database " + this.getURL() + "(" + this.toString() + ") with ClassLoader " + this.getClass().getClassLoader() + " - " + this.datasource.getClass().toString()));
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.datasource instanceof PGPoolingDataSource) {
            LOG.info((Object)("Finalise - Closing datasource for Database " + this.getURL() + "(" + this.toString() + ") with ClassLoader " + this.getClass().getClassLoader()));
            ((PGPoolingDataSource)this.datasource).close();
        } else if (this.datasource instanceof PoolingDataSource) {
            LOG.info((Object)("Finalise - Closing datasource for Database " + this.getURL() + "(" + this.toString() + ") with ClassLoader " + this.getClass().getClassLoader()));
            ((PoolingDataSource)this.datasource).close();
        } else {
            LOG.warn((Object)("Finalise - Could not close datasource for Database " + this.getURL() + "(" + this.toString() + ") with ClassLoader " + this.getClass().getClassLoader() + " - " + this.datasource.getClass().toString()));
        }
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUser() {
        return (String)this.settings.get("datasource.user");
    }

    public String getPassword() {
        return (String)this.settings.get("datasource.password");
    }

    public String getURL() {
        String url = "jdbc:" + this.platform.toLowerCase() + "://" + (String)this.settings.get("datasource.serverName") + "/" + (String)this.settings.get("datasource.databaseName");
        return url;
    }

    public String getName() {
        return (String)this.settings.get("datasource.databaseName");
    }

    protected void configure(Properties props) throws ClassNotFoundException {
        if (props == null) {
            throw new NullPointerException("Props cannot be null");
        }
        if (props.size() == 0) {
            throw new IllegalArgumentException("No configuration details");
        }
        Properties subProps = new Properties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            block21: {
                String propertyName = (String)entry.getKey();
                String propertyValue = (String)entry.getValue();
                Field field = null;
                String attribute = propertyName;
                String subAttribute = "";
                int index = propertyName.indexOf(".");
                if (index != -1) {
                    attribute = propertyName.substring(0, index);
                    subAttribute = propertyName.substring(index + 1);
                }
                try {
                    field = Database.class.getDeclaredField(attribute);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Ignoring field for Database: " + attribute));
                    continue;
                }
                if ("class".equals(subAttribute)) {
                    Object obj;
                    Class<?> clazz = Class.forName(propertyValue.toString());
                    try {
                        obj = clazz.newInstance();
                    }
                    catch (Exception e) {
                        throw new ClassNotFoundException("Cannot instantiate class " + clazz.getName() + " " + e.getMessage());
                    }
                    try {
                        field.set(this, obj);
                        break block21;
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                if ("".equals(subAttribute)) {
                    try {
                        field.set(this, propertyValue);
                        break block21;
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                Method m = null;
                try {
                    Object o = field.get(this);
                    if (o == null) {
                        subProps.put(propertyName, propertyValue);
                        continue;
                    }
                    Class<?> clazz = o.getClass();
                    m = clazz.getMethod("set" + StringUtil.capitalise(subAttribute), String.class);
                    if (m != null) {
                        m.invoke(field.get(this), propertyValue);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (m == null && (m = field.get(this).getClass().getMethod("set" + StringUtil.capitalise(subAttribute), Integer.TYPE)) != null) {
                        m.invoke(field.get(this), Integer.valueOf(propertyValue.toString()));
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (subProps.size() <= 0) continue;
            this.configure(subProps);
        }
    }

    public String getColumnTypeString(Class<?> c) {
        return POSTGRESQL_TYPE_STRING_MAP.get(c);
    }

    public String toString() {
        return "" + this.settings + " " + this.driver + " " + this.platform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSqlInParallel(String sql) throws SQLException {
        SqlJob job = new SqlJob(sql);
        Database database = this;
        synchronized (database) {
            this.pending.add(job);
        }
        boolean notDone = true;
        while (notDone) {
            try {
                this.queue.put(job);
                notDone = false;
            }
            catch (InterruptedException e) {}
        }
        Database database2 = this;
        synchronized (database2) {
            if (this.workers.size() < this.parallel) {
                Worker worker = new Worker(this.threadNo);
                Thread thread = new Thread(worker);
                thread.setDaemon(true);
                thread.setName("Database background thread " + this.threadNo);
                ++this.threadNo;
                this.workers.add(worker);
                thread.start();
            }
            if (this.reportedException != null) {
                SQLException re = new SQLException("Error while executing SQL");
                re.initCause(this.reportedException);
                this.reportedException = null;
                throw re;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCurrentJobs() throws SQLException {
        Waiter waiter;
        Database database = this;
        synchronized (database) {
            waiter = new Waiter(this.pending);
            this.waiters.add(waiter);
        }
        waiter.waitUntilFinished();
        database = this;
        synchronized (database) {
            this.waiters.remove(waiter);
            if (this.reportedException != null) {
                SQLException re = new SQLException("Error while executing SQL");
                re.initCause(this.reportedException);
                this.reportedException = null;
                throw re;
            }
        }
    }

    private synchronized void jobIsDone(SqlJob job) {
        this.pending.remove(job);
        for (Waiter waiter : this.waiters) {
            waiter.jobIsDone(job);
        }
    }

    private synchronized void reportException(Exception e) {
        if (this.reportedException == null) {
            this.reportedException = e;
        }
    }

    static {
        POSTGRESQL_TYPE_STRING_MAP.put(Boolean.class, "boolean");
        POSTGRESQL_TYPE_STRING_MAP.put(Float.class, "real");
        POSTGRESQL_TYPE_STRING_MAP.put(Double.class, "double precision");
        POSTGRESQL_TYPE_STRING_MAP.put(Short.class, "smallint");
        POSTGRESQL_TYPE_STRING_MAP.put(Integer.class, "integer");
        POSTGRESQL_TYPE_STRING_MAP.put(Long.class, "bigint");
        POSTGRESQL_TYPE_STRING_MAP.put(BigDecimal.class, "numeric");
        POSTGRESQL_TYPE_STRING_MAP.put(Date.class, "bigint");
        POSTGRESQL_TYPE_STRING_MAP.put(String.class, "text");
    }

    private class Waiter {
        private Set<SqlJob> waitingOn;

        public Waiter(Set<SqlJob> waitingOn) {
            this.waitingOn = new HashSet<SqlJob>(waitingOn);
        }

        public synchronized void jobIsDone(SqlJob job) {
            this.waitingOn.remove(job);
            if (this.waitingOn.isEmpty()) {
                this.notifyAll();
            }
        }

        public synchronized void waitUntilFinished() {
            while (!this.waitingOn.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class Worker
    implements Runnable {
        private int threadNo;

        public Worker(int threadNo) {
            this.threadNo = threadNo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                try {}
                catch (Throwable t) {
                    LOG.error((Object)("Database background thread " + this.threadNo + " exited unexpectedly"), t);
                    Database.this.workers.remove(this);
                    return;
                }
            }
            catch (Throwable throwable) {
                Database.this.workers.remove(this);
                throw throwable;
            }
            while (true) {
                SqlJob job = null;
                Connection c = null;
                try {
                    job = (SqlJob)Database.this.queue.take();
                    c = Database.this.getConnection();
                    c.setAutoCommit(true);
                    Statement s = c.createStatement();
                    s.execute(job.getSql());
                    continue;
                }
                catch (SQLException e) {
                    if (job != null) {
                        LOG.error((Object)("Exception while executing " + job.getSql()), (Throwable)e);
                    }
                    Database.this.reportException(e);
                    continue;
                }
                finally {
                    if (job != null) {
                        Database.this.jobIsDone(job);
                    }
                    if (c == null) continue;
                    c.close();
                    continue;
                }
                break;
            }
        }
    }

    private class SqlJob {
        String sql;

        public SqlJob(String sql) {
            this.sql = sql;
        }

        public String getSql() {
            return this.sql;
        }
    }
}

