/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.translating;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.intermine.metadata.MetaDataException;
import org.intermine.metadata.Model;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreAbstractImpl;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.ObjectStoreFactory;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.ResultsInfo;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.objectstore.translating.Translator;
import org.intermine.util.CacheMap;
import org.intermine.util.DynamicUtil;

public class ObjectStoreTranslatingImpl
extends ObjectStoreAbstractImpl {
    private static final Logger LOG = Logger.getLogger(ObjectStoreTranslatingImpl.class);
    private ObjectStore os;
    private Translator translator;
    private Map<Query, Query> queryCache = Collections.synchronizedMap(new WeakHashMap());
    private long timeSpentQuery = 0L;
    private long timeSpentExecute = 0L;
    private long timeSpentTranslate = 0L;
    private int queryCount = 0;
    private int objectCount = 0;
    private int internalGetObjectByIdCount = 0;

    public ObjectStoreTranslatingImpl(Model model, ObjectStore os, Translator translator) {
        super(model);
        this.os = os;
        this.translator = translator;
        translator.setObjectStore(this);
    }

    public static ObjectStoreTranslatingImpl getInstance(String osAlias, Properties props) throws ObjectStoreException {
        Translator t;
        Model classpathModel;
        ObjectStore sub;
        String subAlias = props.getProperty("os");
        if (subAlias == null) {
            throw new IllegalArgumentException("No 'os' property specified for Translating ObjectStore (check properties file)");
        }
        String translatorClass = props.getProperty("translatorClass");
        if (translatorClass == null) {
            throw new IllegalArgumentException("No 'translatorClass' property specified for Translating ObjectStore (check properties file)");
        }
        try {
            sub = ObjectStoreFactory.getObjectStore(subAlias);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to get sub-ObjectStore for Translating ObjectStore (check properties file)");
        }
        try {
            classpathModel = ObjectStoreTranslatingImpl.getModelFromClasspath(osAlias, props);
        }
        catch (MetaDataException metaDataException) {
            throw new ObjectStoreException("Cannot load model", metaDataException);
        }
        try {
            Class<?> c = Class.forName(translatorClass);
            Constructor<?> con = c.getConstructor(Model.class, ObjectStore.class);
            t = (Translator)con.newInstance(classpathModel, sub);
        }
        catch (Exception e) {
            Throwable thr = e.getCause();
            if (thr instanceof ObjectStoreException) {
                throw (ObjectStoreException)thr;
            }
            IllegalArgumentException e2 = new IllegalArgumentException("Cannot find specified Translator class for Translating ObjectStore (check properties file)");
            e2.initCause(e);
            throw e2;
        }
        return new ObjectStoreTranslatingImpl(classpathModel, sub, t);
    }

    public Translator getTranslator() {
        return this.translator;
    }

    @Override
    public List<ResultsRow<Object>> execute(Query q, int start, int limit, boolean optimise, boolean explain, Map<Object, Integer> sequence) throws ObjectStoreException {
        long time1 = System.currentTimeMillis();
        Query q2 = this.translateQuery(q);
        long time2 = System.currentTimeMillis();
        this.timeSpentQuery += time2 - time1;
        ArrayList<ResultsRow<Object>> results = new ArrayList<ResultsRow<Object>>();
        List<ResultsRow<Object>> origResults = this.os.execute(q2, start, limit, optimise, explain, sequence);
        time1 = System.currentTimeMillis();
        this.timeSpentExecute += time1 - time2;
        try {
            for (ResultsRow<Object> origRow : origResults) {
                ResultsRow<Object> row = new ResultsRow<Object>();
                for (Object e : origRow) {
                    if (e instanceof InterMineObject) {
                        Object imo = this.translator.translateFromDbObject(e);
                        row.add(imo);
                        if (imo instanceof InterMineObject) {
                            this.cacheObjectById(((InterMineObject)imo).getId(), (InterMineObject)imo);
                        }
                        ++this.objectCount;
                        continue;
                    }
                    row.add(e);
                }
                results.add(row);
            }
        }
        catch (MetaDataException e) {
            throw new ObjectStoreException(e);
        }
        time2 = System.currentTimeMillis();
        this.timeSpentTranslate += time2 - time1;
        ++this.queryCount;
        if (this.queryCount % 10000 == 0) {
            LOG.info((Object)("Translated " + this.queryCount + " queries, " + this.objectCount + " objects. Time" + " spent: Translate query: " + this.timeSpentQuery + ", Execute: " + this.timeSpentExecute + ", Translate objects: " + this.timeSpentTranslate));
        }
        return results;
    }

    @Override
    public ResultsInfo estimate(Query q) throws ObjectStoreException {
        return this.os.estimate(this.translateQuery(q));
    }

    @Override
    public int count(Query q, Map<Object, Integer> sequence) throws ObjectStoreException {
        return this.os.count(this.translateQuery(q), sequence);
    }

    private Query translateQuery(Query q) throws ObjectStoreException {
        Query retval = this.queryCache.get(q);
        if (retval == null) {
            retval = this.translator.translateQuery(q);
            this.queryCache.put(q, retval);
        }
        return retval;
    }

    @Override
    public InterMineObject getObjectByExample(InterMineObject o, Set<String> fieldNames) throws ObjectStoreException {
        throw new UnsupportedOperationException("getObjectByExample not supported byObjectStoreTranslatingImpl");
    }

    @Override
    public boolean isMultiConnection() {
        return this.os.isMultiConnection();
    }

    @Override
    public Set<Object> getComponentsForQuery(Query q) {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InterMineObject internalGetObjectById(Integer id, Class<? extends InterMineObject> clazz) throws ObjectStoreException {
        InterMineObject retval = super.internalGetObjectById(id, clazz);
        CacheMap cacheMap = this.cache;
        synchronized (cacheMap) {
            Exception e = new Exception();
            e.fillInStackTrace();
            LOG.warn((Object)("Probable inefficiency: internalGetObjectById called " + (retval == null ? "" : "to fetch a " + DynamicUtil.getFriendlyName(retval.getClass())) + " with id " + id + ", clazz " + clazz.toString() + ", cache size = " + this.cache.size() + " - maybe you should use" + " ObjectStoreFastCollectionsForTranslatorImpl"), (Throwable)e);
        }
        ++this.internalGetObjectByIdCount;
        if (this.internalGetObjectByIdCount % 1000 == 0) {
            LOG.info((Object)("internalGetObjectById run " + this.internalGetObjectByIdCount + " times"));
        }
        return retval;
    }

    @Override
    public Integer getSerial() throws ObjectStoreException {
        return this.os.getSerial();
    }
}

