/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.safe;

import java.util.List;
import java.util.Map;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.ObjectStorePassthruImpl;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryCloner;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsInfo;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.objectstore.query.SingletonResults;

public class ObjectStoreSafeImpl
extends ObjectStorePassthruImpl {
    public ObjectStoreSafeImpl(ObjectStore os) {
        super(os);
    }

    @Override
    public Results execute(Query q) {
        return this.os.execute(QueryCloner.cloneQuery(q));
    }

    @Override
    public Results execute(Query q, int batchSize, boolean optimise, boolean explain, boolean prefetch) {
        Results retval = new Results(q, this, this.getSequence(this.getComponentsForQuery(q)));
        if (batchSize != 0) {
            retval.setBatchSize(batchSize);
        }
        if (!optimise) {
            retval.setNoOptimise();
        }
        if (!explain) {
            retval.setNoExplain();
        }
        if (!prefetch) {
            retval.setNoPrefetch();
        }
        retval.setImmutable();
        return retval;
    }

    @Override
    public SingletonResults executeSingleton(Query q) {
        return this.os.executeSingleton(QueryCloner.cloneQuery(q));
    }

    @Override
    public SingletonResults executeSingleton(Query q, int batchSize, boolean optimise, boolean explain, boolean prefetch) {
        SingletonResults retval = new SingletonResults(q, this, this.getSequence(this.getComponentsForQuery(q)));
        if (batchSize != 0) {
            retval.setBatchSize(batchSize);
        }
        if (!optimise) {
            retval.setNoOptimise();
        }
        if (!explain) {
            retval.setNoExplain();
        }
        if (!prefetch) {
            retval.setNoPrefetch();
        }
        retval.setImmutable();
        return retval;
    }

    @Override
    public List<ResultsRow<Object>> execute(Query q, int start, int limit, boolean optimise, boolean explain, Map<Object, Integer> sequence) throws ObjectStoreException {
        return this.os.execute(QueryCloner.cloneQuery(q), start, limit, optimise, explain, sequence);
    }

    @Override
    public ResultsInfo estimate(Query q) throws ObjectStoreException {
        return this.os.estimate(QueryCloner.cloneQuery(q));
    }

    @Override
    public int count(Query q, Map<Object, Integer> sequence) throws ObjectStoreException {
        return this.os.count(QueryCloner.cloneQuery(q), sequence);
    }

    public String toString() {
        return "Safe(" + this.os + ")";
    }
}

