/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.querygen;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.model.FastPathObject;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryCollectionReference;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryHelper;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.util.DynamicUtil;
import org.intermine.util.TypeUtil;

public final class QueryGenUtil {
    private QueryGenUtil() {
    }

    protected static Set<String> getClassNames(ObjectStore os, String clsName) throws ObjectStoreException {
        boolean useSubClasses = false;
        LinkedHashSet<String> clsNames = new LinkedHashSet<String>();
        for (String part : clsName.split(",")) {
            ClassDescriptor cld;
            if (part.indexOf(46) != -1) {
                QueryAndClass qac = QueryGenUtil.createClassFindingQuery(os.getModel(), part);
                for (Object cls : os.executeSingleton(qac.getQuery(), 1000, false, false, false)) {
                    Class clazz = (Class)cls;
                    for (Class<?> classPart : DynamicUtil.decomposeClass(clazz)) {
                        if (!qac.getClazz().isAssignableFrom(classPart)) continue;
                        clsNames.add(TypeUtil.unqualifiedName(classPart.getName()));
                    }
                }
                continue;
            }
            if (part.startsWith("+")) {
                part = part.substring(1);
                useSubClasses = true;
            }
            if ((cld = os.getModel().getClassDescriptorByName(os.getModel().getPackageName() + "." + part)) == null) {
                throw new IllegalArgumentException("cannot find ClassDescriptor for " + part + " in argument \"" + clsName + "\"");
            }
            clsNames.add(part);
            if (!useSubClasses) continue;
            for (ClassDescriptor nextCld : os.getModel().getAllSubs(cld)) {
                clsNames.add(TypeUtil.unqualifiedName(nextCld.getName()));
            }
        }
        return clsNames;
    }

    protected static QueryAndClass createClassFindingQuery(Model model, String part) {
        try {
            String[] paths = part.split("\\.");
            Query q = new Query();
            QueryClass qc = new QueryClass(new Class[]{Class.forName(model.getPackageName() + "." + paths[0])});
            q.addFrom(qc);
            ConstraintSet cs = new ConstraintSet(ConstraintOp.AND);
            for (int i = 1; i < paths.length; ++i) {
                if (i == paths.length - 1) {
                    QueryField qf = new QueryField(qc, paths[i]);
                    q.addToSelect(qf);
                    continue;
                }
                try {
                    QueryObjectReference qor = new QueryObjectReference(qc, paths[i]);
                    qc = new QueryClass((Class<? extends FastPathObject>)qor.getType());
                    q.addFrom(qc);
                    cs.addConstraint(new ContainsConstraint((QueryReference)qor, ConstraintOp.CONTAINS, qc));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    QueryCollectionReference qcr = new QueryCollectionReference(qc, paths[i]);
                    qc = new QueryClass(TypeUtil.getElementType(qc.getType(), paths[i]));
                    q.addFrom(qc);
                    cs.addConstraint(new ContainsConstraint((QueryReference)qcr, ConstraintOp.CONTAINS, qc));
                }
            }
            q.setDistinct(true);
            int csSize = cs.getConstraints().size();
            if (csSize == 1) {
                q.setConstraint(cs.getConstraints().iterator().next());
            } else if (csSize > 1) {
                q.setConstraint(cs);
            }
            return new QueryAndClass(q, qc.getType());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class not found while processing " + part, e);
        }
    }

    public static void validatePath(String path, Model model) {
        String[] queryBits;
        int posOfOrder = path.indexOf(" ORDER BY ");
        if (posOfOrder != -1) {
            path = path.substring(0, posOfOrder);
        }
        if ((queryBits = path.split("[ \t]")).length <= 1 || queryBits.length % 2 == 0) {
            throw new IllegalArgumentException("Construct query path does not have valid  number of elements: " + path);
        }
        int i = 0;
        while (i + 2 < queryBits.length) {
            String prefix;
            String start = model.getPackageName() + "." + queryBits[i];
            String refName = queryBits[i + 1];
            String end = model.getPackageName() + "." + queryBits[i + 2];
            if (!model.hasClassDescriptor(start)) {
                throw new IllegalArgumentException("Class not found in model: " + start);
            }
            if (!model.hasClassDescriptor(end)) {
                throw new IllegalArgumentException("Class not found in model: " + end);
            }
            ClassDescriptor startCld = model.getClassDescriptorByName(start);
            ClassDescriptor endCld = model.getClassDescriptorByName(end);
            int dotPos = refName.indexOf(46);
            if (dotPos != -1 && !"reverse".equals(prefix = refName.substring(0, dotPos))) {
                int replacementStartNo;
                try {
                    replacementStartNo = Integer.parseInt(prefix) - 1;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Prefix " + prefix + " is not a number " + "or \"reverse\"", e);
                }
                if (replacementStartNo > i / 2 - 1) {
                    throw new IllegalArgumentException("Prefix " + prefix + " refers to future");
                }
                startCld = model.getClassDescriptorByName(model.getPackageName() + "." + queryBits[replacementStartNo * 2]);
                refName = refName.substring(dotPos + 1);
            }
            if (refName.startsWith("reverse.")) {
                ClassDescriptor tempCld = startCld;
                startCld = endCld;
                endCld = tempCld;
                refName = refName.substring(8);
            }
            if (startCld.getReferenceDescriptorByName(refName, true) == null && startCld.getCollectionDescriptorByName(refName, true) == null) {
                throw new IllegalArgumentException("Cannot find descriptor for " + refName + " in " + startCld.getName());
            }
            i += 2;
        }
    }

    public static Set<String> expandPath(ObjectStore os, String path) throws ObjectStoreException {
        String clsName;
        int posOfOrder = path.indexOf(" ORDER BY ");
        String order = "";
        if (posOfOrder != -1) {
            order = path.substring(posOfOrder);
            path = path.substring(0, posOfOrder);
        }
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        String refName = "";
        int refEnd = 0;
        if (path.indexOf(32) != -1) {
            int clsEnd = path.indexOf(32);
            clsName = path.substring(0, clsEnd);
            refEnd = path.indexOf(32, clsEnd + 1);
            refName = path.substring(clsEnd, refEnd);
        } else {
            clsName = path;
        }
        Set<String> subs = QueryGenUtil.getClassNames(os, clsName);
        for (String subName : subs) {
            LinkedHashSet<String> nextPaths = new LinkedHashSet<String>();
            if ("".equals(refName)) {
                nextPaths.addAll(subs);
                return nextPaths;
            }
            nextPaths.addAll(QueryGenUtil.expandPath(os, path.substring(refEnd + 1).trim()));
            for (String nextPath : nextPaths) {
                paths.add((subName + refName + " " + nextPath).trim() + order);
            }
        }
        return paths;
    }

    public static Query constructQuery(Model model, String path) throws ClassNotFoundException {
        QueryGenUtil.validatePath(path, model);
        int posOfOrder = path.indexOf(" ORDER BY ");
        String order = null;
        if (posOfOrder != -1) {
            order = path.substring(posOfOrder + 10);
            path = path.substring(0, posOfOrder);
        }
        String[] queryBits = path.split("[ \t]");
        Query q = new Query();
        q.setDistinct(false);
        QueryClass qcStart = new QueryClass(new Class[]{Class.forName(model.getPackageName() + "." + queryBits[0])});
        ArrayList<QueryClass> qcs = new ArrayList<QueryClass>();
        qcs.add(qcStart);
        int i = 0;
        while (i + 2 < queryBits.length) {
            String prefix;
            String refName = queryBits[i + 1];
            int dotPos = refName.indexOf(46);
            if (dotPos != -1 && !"reverse".equals(prefix = refName.substring(0, dotPos))) {
                int replacementStartNo;
                try {
                    replacementStartNo = Integer.parseInt(prefix) - 1;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Prefix " + prefix + " is not a number " + "or \"reverse\"", e);
                }
                qcStart = (QueryClass)qcs.get(replacementStartNo);
                refName = refName.substring(dotPos + 1);
            }
            QueryClass qcEnd = new QueryClass(new Class[]{Class.forName(model.getPackageName() + "." + queryBits[i + 2])});
            QueryGenUtil.addReferenceConstraint(model, q, qcStart, refName, qcEnd, i == 0);
            qcs.add(qcEnd);
            qcStart = qcEnd;
            i += 2;
        }
        if (order != null) {
            String[] orderBits;
            for (String orderBit : orderBits = order.split("[ \t]")) {
                int posOfDot = orderBit.indexOf(46);
                int classNo = Integer.parseInt(orderBit.substring(0, posOfDot)) - 1;
                String fieldName = orderBit.substring(posOfDot + 1);
                QueryField qf = new QueryField((QueryClass)qcs.get(classNo), fieldName);
                q.addToSelect(qf);
                q.addToOrderBy(qf);
            }
        }
        return q;
    }

    protected static void addReferenceConstraint(Model model, Query q, QueryClass qcStart, String refName, QueryClass qcEnd, boolean first) {
        if (first) {
            q.addFrom(qcStart);
            q.addToSelect(qcStart);
        }
        q.addFrom(qcEnd);
        q.addToSelect(qcEnd);
        if (refName.startsWith("reverse.")) {
            refName = refName.substring(8);
            ClassDescriptor endCld = model.getClassDescriptorByName(qcEnd.getType().getName());
            FieldDescriptor fd = endCld.getFieldDescriptorByName(refName);
            QueryReference qRef = fd.isReference() ? new QueryObjectReference(qcEnd, refName) : new QueryCollectionReference(qcEnd, refName);
            ContainsConstraint cc = new ContainsConstraint(qRef, ConstraintOp.CONTAINS, qcStart);
            QueryHelper.addAndConstraint(q, cc);
        } else {
            ClassDescriptor startCld = model.getClassDescriptorByName(qcStart.getType().getName());
            FieldDescriptor fd = startCld.getFieldDescriptorByName(refName);
            QueryReference qRef = fd.isReference() ? new QueryObjectReference(qcStart, refName) : new QueryCollectionReference(qcStart, refName);
            ContainsConstraint cc = new ContainsConstraint(qRef, ConstraintOp.CONTAINS, qcEnd);
            QueryHelper.addAndConstraint(q, cc);
        }
    }

    protected static class QueryAndClass {
        private Query query;
        private Class<?> clazz;

        public QueryAndClass(Query query, Class<?> clazz) {
            this.query = query;
            this.clazz = clazz;
        }

        public Query getQuery() {
            return this.query;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }
    }
}

