/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query.iql;

import antlr.DumpASTVisitor;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.query.BagConstraint;
import org.intermine.objectstore.query.ClassConstraint;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.ObjectStoreBag;
import org.intermine.objectstore.query.ObjectStoreBagCombination;
import org.intermine.objectstore.query.ObjectStoreBagsForObject;
import org.intermine.objectstore.query.OrderDescending;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryCast;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryClassBag;
import org.intermine.objectstore.query.QueryCollectionPathExpression;
import org.intermine.objectstore.query.QueryCollectionReference;
import org.intermine.objectstore.query.QueryEvaluable;
import org.intermine.objectstore.query.QueryExpression;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryForeignKey;
import org.intermine.objectstore.query.QueryFunction;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.objectstore.query.QueryObjectPathExpression;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryOrderable;
import org.intermine.objectstore.query.QueryPathExpressionWithSelect;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.QueryValue;
import org.intermine.objectstore.query.SimpleConstraint;
import org.intermine.objectstore.query.SubqueryConstraint;
import org.intermine.objectstore.query.SubqueryExistsConstraint;
import org.intermine.objectstore.query.UnknownTypeValue;
import org.intermine.objectstore.query.iql.IqlLexer;
import org.intermine.objectstore.query.iql.IqlParser;
import org.intermine.objectstore.query.iql.IqlQuery;

public final class IqlQueryParser {
    private IqlQueryParser() {
    }

    public static Query parse(IqlQuery iq) {
        Query q = new Query();
        q.setDistinct(false);
        String modelPackage = iq.getPackageName();
        String iql = iq.getQueryString();
        Iterator<?> iterator = iq.getParameters().iterator();
        AST ast = null;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(iql.getBytes());
            IqlLexer lexer = new IqlLexer(is);
            IqlParser parser = new IqlParser(lexer);
            parser.start_rule();
            ast = parser.getAST();
            if (ast == null) {
                throw new IllegalArgumentException("Invalid IQL string " + iql);
            }
            IqlQueryParser.processIqlStatementAST(ast, q, modelPackage, iterator);
            return q;
        }
        catch (RecognitionException e) {
            System.out.println("Dumping AST Tree:");
            DumpASTVisitor visitor = new DumpASTVisitor();
            visitor.visit(ast);
            StringBuffer message = new StringBuffer();
            try {
                Token token;
                ByteArrayInputStream is = new ByteArrayInputStream(iql.getBytes());
                IqlLexer lexer = new IqlLexer(is);
                boolean needComma = false;
                do {
                    token = lexer.nextToken();
                    if (needComma) {
                        message.append(", ");
                    }
                    needComma = true;
                    message.append(token.toString());
                } while (token.getType() != 1);
            }
            catch (TokenStreamException e3) {
                // empty catch block
            }
            IllegalArgumentException e2 = new IllegalArgumentException(e.getMessage() + ". Lexer stream: " + message.toString());
            e2.initCause(e);
            throw e2;
        }
        catch (TokenStreamException e) {
            System.out.println("Dumping AST Tree:");
            DumpASTVisitor visitor = new DumpASTVisitor();
            visitor.visit(ast);
            IllegalArgumentException e2 = new IllegalArgumentException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
        catch (IllegalArgumentException e) {
            System.out.println("Dumping AST Tree:");
            DumpASTVisitor visitor = new DumpASTVisitor();
            visitor.visit(ast);
            throw e;
        }
        catch (ClassCastException e) {
            System.out.println("Dumping AST Tree:");
            DumpASTVisitor visitor = new DumpASTVisitor();
            visitor.visit(ast);
            IllegalArgumentException e2 = new IllegalArgumentException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
    }

    private static void processIqlStatementAST(AST ast, Query q, String modelPackage, Iterator<?> iterator) {
        if (ast.getType() != 4) {
            throw new IllegalArgumentException("Expected: an IQL SELECT statement");
        }
        IqlQueryParser.processAST(ast.getFirstChild(), q, modelPackage, iterator);
        for (QuerySelectable qs : q.getSelect()) {
            QueryValue qv;
            if (!(qs instanceof QueryValue) || !UnknownTypeValue.class.equals((qv = (QueryValue)qs).getType()) || ((UnknownTypeValue)qv.getValue()).getApproximateType() != 2) continue;
            qv.youAreType(String.class);
        }
    }

    private static void processAST(AST ast, Query q, String modelPackage, Iterator<?> iterator) {
        AST selectAST = null;
        AST orderAST = null;
        do {
            switch (ast.getType()) {
                case 41: {
                    q.setDistinct(true);
                    break;
                }
                case 5: {
                    selectAST = ast;
                    break;
                }
                case 6: {
                    IqlQueryParser.processFromList(ast.getFirstChild(), q, modelPackage, iterator);
                    break;
                }
                case 7: {
                    q.setConstraint(IqlQueryParser.processConstraint(ast.getFirstChild(), q, modelPackage, iterator));
                    break;
                }
                case 8: {
                    IqlQueryParser.processGroupClause(ast.getFirstChild(), q, modelPackage, iterator);
                    break;
                }
                case 9: {
                    orderAST = ast;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
                }
            }
        } while ((ast = ast.getNextSibling()) != null);
        if (selectAST != null) {
            IqlQueryParser.processSelectList(selectAST.getFirstChild(), q, modelPackage, iterator);
        }
        if (orderAST != null) {
            IqlQueryParser.processOrderClause(orderAST.getFirstChild(), q, modelPackage, iterator);
        }
    }

    private static void processFromList(AST ast, Query q, String modelPackage, Iterator<?> iterator) {
        do {
            switch (ast.getType()) {
                case 13: {
                    IqlQueryParser.processNewTable(ast.getFirstChild(), q, modelPackage, iterator);
                    break;
                }
                case 15: {
                    IqlQueryParser.processNewSubQuery(ast.getFirstChild(), q, modelPackage, iterator);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
                }
            }
        } while ((ast = ast.getNextSibling()) != null);
    }

    private static void processNewTable(AST ast, Query q, String modelPackage, Iterator<?> iterator) {
        String tableAlias = null;
        String tableName = null;
        HashSet classes = new HashSet();
        boolean isBag = false;
        ObjectStoreBag osb = null;
        if (ast.getType() == 64) {
            isBag = true;
            ast = ast.getNextSibling();
        } else if (ast.getType() == 33) {
            isBag = true;
            osb = IqlQueryParser.processNewObjectStoreBag(ast.getFirstChild());
            ast = ast.getNextSibling();
        }
        do {
            switch (ast.getType()) {
                case 14: {
                    tableName = null;
                    AST tableNameAst = ast.getFirstChild();
                    do {
                        String temp = IqlQueryParser.unescape(tableNameAst.getText());
                        String string = tableName = tableName == null ? temp : tableName + "." + temp;
                    } while ((tableNameAst = tableNameAst.getNextSibling()) != null);
                    Class<?> c = null;
                    try {
                        c = Class.forName(tableName);
                    }
                    catch (ClassNotFoundException e) {
                        if (modelPackage != null) {
                            try {
                                c = Class.forName(modelPackage + "." + tableName);
                            }
                            catch (ClassNotFoundException e2) {
                                throw new IllegalArgumentException("Unknown class name " + tableName + " in package " + modelPackage);
                            }
                        }
                        throw new IllegalArgumentException("Unknown class name " + tableName);
                    }
                    classes.add(c);
                    break;
                }
                case 11: {
                    tableAlias = IqlQueryParser.unescape(ast.getFirstChild().getText());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
                }
            }
        } while ((ast = ast.getNextSibling()) != null);
        if (tableAlias == null) {
            if (classes.size() == 1) {
                int index = tableName.lastIndexOf(46);
                tableAlias = index == -1 ? tableName : tableName.substring(index + 1);
            } else {
                throw new IllegalArgumentException("Dynamic classes in the FROM clause must have an alias");
            }
        }
        if (isBag) {
            if (osb == null) {
                QueryClassBag qcb = new QueryClassBag(classes, (Collection)iterator.next());
                q.addFrom(qcb, tableAlias);
            } else {
                QueryClassBag qcb = new QueryClassBag(classes, osb);
                q.addFrom(qcb, tableAlias);
            }
        } else {
            QueryClass qc = new QueryClass(classes);
            q.addFrom(qc, tableAlias);
        }
    }

    private static void processNewSubQuery(AST ast, Query q, String modelPackage, Iterator<?> iterator) {
        AST subquery = null;
        String tableAlias = null;
        int limit = Integer.MAX_VALUE;
        block5: do {
            switch (ast.getType()) {
                case 4: {
                    if (subquery != null) continue block5;
                    subquery = ast;
                    break;
                }
                case 11: {
                    tableAlias = IqlQueryParser.unescape(ast.getFirstChild().getText());
                    break;
                }
                case 16: {
                    limit = Integer.parseInt(ast.getFirstChild().getText());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
                }
            }
        } while ((ast = ast.getNextSibling()) != null);
        Query sq = new Query();
        sq.setDistinct(false);
        IqlQueryParser.processIqlStatementAST(subquery, sq, modelPackage, iterator);
        sq.setLimit(limit);
        if (tableAlias == null) {
            throw new IllegalArgumentException("No alias for subquery");
        }
        q.addFrom(sq, tableAlias);
    }

    private static void processSelectList(AST ast, Query q, String modelPackage, Iterator<?> iterator) {
        do {
            switch (ast.getType()) {
                case 10: {
                    IqlQueryParser.processNewSelect(ast.getFirstChild(), q, modelPackage, iterator);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
                }
            }
        } while ((ast = ast.getNextSibling()) != null);
    }

    private static void processNewSelect(AST ast, Query q, String modelPackage, Iterator<?> iterator) {
        QuerySelectable node = null;
        String nodeAlias = null;
        block10: do {
            switch (ast.getType()) {
                case 12: {
                    nodeAlias = IqlQueryParser.unescape(ast.getFirstChild().getText());
                    break;
                }
                case 17: 
                case 18: 
                case 20: 
                case 21: 
                case 31: {
                    node = IqlQueryParser.processNewQuerySelectable(ast, q, modelPackage, iterator);
                    break;
                }
                case 33: {
                    if (node instanceof ObjectStoreBagCombination) {
                        ((ObjectStoreBagCombination)node).addBag(IqlQueryParser.processNewObjectStoreBag(ast.getFirstChild()));
                        break;
                    }
                    node = IqlQueryParser.processNewObjectStoreBag(ast.getFirstChild());
                    break;
                }
                case 52: {
                    ObjectStoreBagCombination osbc;
                    if (node instanceof ObjectStoreBag) {
                        osbc = new ObjectStoreBagCombination(879234);
                        osbc.addBag((ObjectStoreBag)node);
                        node = osbc;
                        break;
                    }
                    if (node instanceof ObjectStoreBagCombination) {
                        if (((ObjectStoreBagCombination)node).getOp() == 879234) continue block10;
                        throw new IllegalArgumentException("Cannot mix UNION, INTERSECT, EXCEPT, and ALLBUTINTERSECT in a bag fetch query");
                    }
                    throw new IllegalArgumentException("UNION can only apply to bag fetches");
                }
                case 53: {
                    ObjectStoreBagCombination osbc;
                    if (node instanceof ObjectStoreBag) {
                        osbc = new ObjectStoreBagCombination(519552);
                        osbc.addBag((ObjectStoreBag)node);
                        node = osbc;
                        break;
                    }
                    if (node instanceof ObjectStoreBagCombination) {
                        if (((ObjectStoreBagCombination)node).getOp() == 519552) continue block10;
                        throw new IllegalArgumentException("Cannot mix UNION, INTERSECT, EXCEPT, and ALLBUTINTERSECT in a bag fetch query");
                    }
                    throw new IllegalArgumentException("INTERSECT can only apply to bag fetches");
                }
                case 54: {
                    ObjectStoreBagCombination osbc;
                    if (node instanceof ObjectStoreBag) {
                        osbc = new ObjectStoreBagCombination(281056);
                        osbc.addBag((ObjectStoreBag)node);
                        node = osbc;
                        break;
                    }
                    if (node instanceof ObjectStoreBagCombination) {
                        if (((ObjectStoreBagCombination)node).getOp() == 281056) continue block10;
                        throw new IllegalArgumentException("Cannot mix UNION, INTERSECT, EXCEPT, and ALLBUTINTERSECT in a bag fetch query");
                    }
                    throw new IllegalArgumentException("EXCEPT can only apply to bag fetches");
                }
                case 55: {
                    ObjectStoreBagCombination osbc;
                    if (node instanceof ObjectStoreBag) {
                        osbc = new ObjectStoreBagCombination(853915);
                        osbc.addBag((ObjectStoreBag)node);
                        node = osbc;
                        break;
                    }
                    if (node instanceof ObjectStoreBagCombination) {
                        if (((ObjectStoreBagCombination)node).getOp() == 853915) continue block10;
                        throw new IllegalArgumentException("Cannot mix UNION, INTERSECT, EXCEPT, and ALLBUTINTERSECT in a bag fetch query");
                    }
                    throw new IllegalArgumentException("ALLBUTINTERSECT can only apply to bag fetches");
                }
                case 35: {
                    node = IqlQueryParser.processNewBagsFor(ast.getFirstChild(), iterator);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
                }
            }
        } while ((ast = ast.getNextSibling()) != null);
        if (nodeAlias == null != (node instanceof QueryClass || node instanceof ObjectStoreBag || node instanceof ObjectStoreBagCombination || node instanceof ObjectStoreBagsForObject)) {
            throw new IllegalArgumentException("No alias for item in SELECT list, or an alias present for a QueryClass");
        }
        q.addToSelect(node, nodeAlias);
    }

    private static QueryNode processNewQueryNode(AST ast, Query q, String modelPackage, Iterator<?> iterator) {
        Object retval = IqlQueryParser.processNewQueryNodeOrReference(ast, q, false, modelPackage, iterator);
        if (retval instanceof QueryObjectReference) {
            QueryObjectReference qor = (QueryObjectReference)retval;
            throw new IllegalArgumentException("Object reference " + qor.getQueryClass().getType().getName() + "." + qor.getFieldName() + " present where a QueryNode is" + " required.");
        }
        return (QueryNode)retval;
    }

    private static QuerySelectable processNewQuerySelectable(AST ast, Query q, String modelPackage, Iterator<?> iterator) {
        return (QuerySelectable)IqlQueryParser.processNewQueryNodeOrReference(ast, q, true, modelPackage, iterator);
    }

    private static Object processNewQueryNodeOrReference(AST ast, Query q, boolean isSelect, String modelPackage, Iterator<?> iterator) {
        switch (ast.getType()) {
            case 18: {
                return IqlQueryParser.processNewField(ast.getFirstChild(), q, isSelect, modelPackage, iterator);
            }
            case 17: {
                return IqlQueryParser.processNewQueryValue(ast.getFirstChild());
            }
            case 21: {
                return IqlQueryParser.processNewUnsafeFunction(ast.getFirstChild(), q, modelPackage, iterator);
            }
            case 20: {
                return IqlQueryParser.processNewSafeFunction(ast.getFirstChild(), q, modelPackage, iterator);
            }
            case 31: {
                return IqlQueryParser.processNewTypeCast(ast.getFirstChild(), q, modelPackage, iterator);
            }
            case 34: {
                return new OrderDescending((QueryOrderable)IqlQueryParser.processNewQueryNodeOrReference(ast.getFirstChild(), q, isSelect, modelPackage, iterator));
            }
        }
        throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
    }

    private static QueryValue processNewQueryValue(AST ast) {
        String value = IqlQueryParser.unescape(ast.getText());
        return new QueryValue(new UnknownTypeValue(value));
    }

    private static ObjectStoreBag processNewObjectStoreBag(AST ast) {
        String value = IqlQueryParser.unescape(ast.getText());
        return new ObjectStoreBag(Integer.parseInt(value));
    }

    private static ObjectStoreBagsForObject processNewBagsFor(AST ast, Iterator<?> iterator) {
        String value = IqlQueryParser.unescape(ast.getText());
        AST sibling = ast.getNextSibling();
        if (sibling != null) {
            if (64 == sibling.getType()) {
                Collection param = (Collection)iterator.next();
                return new ObjectStoreBagsForObject(new Integer(Integer.parseInt(value)), param);
            }
            throw new IllegalArgumentException("Unknown AST node: " + sibling.getText() + " [" + sibling.getType() + "]");
        }
        return new ObjectStoreBagsForObject(new Integer(Integer.parseInt(value)));
    }

    private static Object processNewField(AST ast, Query q, boolean isSelect, String modelPackage, Iterator<?> iterator) {
        Object obj;
        block44: {
            QueryPathExpressionWithSelect col;
            if (ast.getType() != 49) {
                throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
            }
            obj = q.getReverseAliases().get(IqlQueryParser.unescape(ast.getText()));
            String text = ast.getText();
            if (!(obj instanceof QueryClass) && !(obj instanceof QueryClassBag)) break block44;
            if ((ast = ast.getNextSibling()) == null) {
                return obj;
            }
            if (obj instanceof QueryClassBag) {
                if ("id".equals(ast.getText()) && ast.getNextSibling() == null) {
                    return new QueryField((QueryClassBag)obj);
                }
                throw new IllegalArgumentException("Can only access the \"id\" attribute of QueryClassBag \"" + text + "\"");
            }
            AST collectionSelectAst = null;
            while (ast != null) {
                block43: {
                    block47: {
                        Set<Integer> empty;
                        block46: {
                            block45: {
                                text = text + "." + ast.getText();
                                if (!(obj instanceof QueryClass)) break block45;
                                try {
                                    obj = new QueryField((QueryClass)obj, IqlQueryParser.unescape(ast.getText()));
                                }
                                catch (IllegalArgumentException e) {
                                    if (isSelect) {
                                        try {
                                            obj = new QueryObjectPathExpression((QueryClass)obj, IqlQueryParser.unescape(ast.getText()));
                                        }
                                        catch (IllegalArgumentException e2) {
                                            obj = new QueryCollectionPathExpression((QueryClass)obj, IqlQueryParser.unescape(ast.getText()));
                                        }
                                        break block43;
                                    }
                                    obj = new QueryObjectReference((QueryClass)obj, IqlQueryParser.unescape(ast.getText()));
                                }
                                break block43;
                            }
                            if (!(obj instanceof QueryObjectPathExpression)) break block46;
                            if ("id".equals(ast.getText())) {
                                obj = new QueryForeignKey(((QueryObjectPathExpression)obj).getQueryClass(), ((QueryObjectPathExpression)obj).getFieldName());
                            } else {
                                QueryObjectPathExpression ref = (QueryObjectPathExpression)obj;
                                empty = Collections.emptySet();
                                switch (ast.getType()) {
                                    case 49: {
                                        throw new IllegalArgumentException("Path expression " + text + " extends beyond a reference");
                                    }
                                    case 36: {
                                        collectionSelectAst = ast.getFirstChild();
                                        break;
                                    }
                                    case 7: {
                                        ref.setConstraint(IqlQueryParser.processConstraint(ast.getFirstChild(), ref.getQuery(empty, false), modelPackage, iterator));
                                        break;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("Unknown AST node " + ast);
                                    }
                                }
                            }
                            break block43;
                        }
                        if (obj instanceof QueryField) {
                            throw new IllegalArgumentException("Path expression " + text + " extends " + "beyond a field");
                        }
                        if (obj instanceof QueryForeignKey) {
                            throw new IllegalArgumentException("Path expression " + text + " extends " + "beyond a foreign key");
                        }
                        if (!(obj instanceof QueryCollectionPathExpression)) break block47;
                        col = (QueryCollectionPathExpression)obj;
                        empty = Collections.emptySet();
                        switch (ast.getType()) {
                            case 49: {
                                throw new IllegalArgumentException("Path expression " + text + " extends beyond a collection");
                            }
                            case 71: {
                                ((QueryCollectionPathExpression)col).setSingleton(true);
                                break;
                            }
                            case 36: {
                                collectionSelectAst = ast.getFirstChild();
                                break;
                            }
                            case 7: {
                                ((QueryCollectionPathExpression)col).setConstraint(IqlQueryParser.processConstraint(ast.getFirstChild(), ((QueryCollectionPathExpression)col).getQuery(empty), modelPackage, iterator));
                                break;
                            }
                            case 6: {
                                Query colQuery = new Query();
                                IqlQueryParser.processFromList(ast.getFirstChild(), colQuery, modelPackage, iterator);
                                for (FromElement from : colQuery.getFrom()) {
                                    String alias = colQuery.getAliases().get(from);
                                    ((QueryCollectionPathExpression)col).addFrom(from, alias);
                                }
                                break block43;
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown AST node " + ast);
                            }
                        }
                        break block43;
                    }
                    throw new IllegalArgumentException("Unknown type");
                }
                ast = ast.getNextSibling();
            }
            if (collectionSelectAst != null) {
                Query colQuery;
                Set<Integer> empty;
                col = (QueryPathExpressionWithSelect)obj;
                if (col instanceof QueryCollectionPathExpression) {
                    empty = Collections.emptySet();
                    colQuery = ((QueryCollectionPathExpression)col).getQuery(empty);
                } else {
                    empty = Collections.emptySet();
                    colQuery = ((QueryObjectPathExpression)col).getQuery(empty, false);
                }
                do {
                    switch (collectionSelectAst.getType()) {
                        case 17: 
                        case 18: 
                        case 20: 
                        case 21: 
                        case 31: {
                            col.addToSelect(IqlQueryParser.processNewQuerySelectable(collectionSelectAst, colQuery, modelPackage, iterator));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown AST node " + collectionSelectAst);
                        }
                    }
                } while ((collectionSelectAst = collectionSelectAst.getNextSibling()) != null);
            }
            return obj;
        }
        if (obj instanceof Query) {
            AST secondAst = ast.getNextSibling();
            Query q2 = (Query)obj;
            if (secondAst == null) {
                throw new IllegalArgumentException("Path expression " + ast.getText() + " cannot end at a subquery");
            }
            AST thirdAst = secondAst.getNextSibling();
            Object secondObj = q2.getReverseAliases().get(IqlQueryParser.unescape(secondAst.getText()));
            if (secondObj instanceof QueryClass) {
                if (thirdAst == null) {
                    throw new IllegalArgumentException("Cannot reference classes inside subqueries - only QueryEvaluables, and fields inside classes inside subqueries, for path expression " + ast.getText() + "." + secondAst.getText());
                }
                AST fourthAst = thirdAst.getNextSibling();
                if (fourthAst == null) {
                    if (q2.getSelect().contains(secondObj)) {
                        return new QueryField(q2, (QueryClass)secondObj, IqlQueryParser.unescape(thirdAst.getText()));
                    }
                    throw new IllegalArgumentException(ast.getText() + "." + secondAst.getText() + "." + thirdAst.getText() + " is not available, because " + secondAst.getText() + " is not in the SELECT list of subquery " + ast.getText());
                }
                throw new IllegalArgumentException("Path expression " + ast.getText() + "." + secondAst.getText() + "." + thirdAst.getText() + "." + fourthAst.getText() + " extends beyond a field");
            }
            if (secondObj instanceof QueryEvaluable) {
                if (thirdAst == null) {
                    return new QueryField(q2, (QueryEvaluable)secondObj);
                }
                throw new IllegalArgumentException("Path expression " + ast.getText() + "." + secondAst.getText() + "." + thirdAst.getText() + " extends " + "beyond a field");
            }
            if (secondObj instanceof Query) {
                throw new IllegalArgumentException("Cannot reference subquery " + secondAst.getText() + " inside subquery " + ast.getText());
            }
            throw new IllegalArgumentException("No such object " + secondAst.getText() + " found in subquery " + ast.getText());
        }
        throw new IllegalArgumentException("No such object " + ast.getText());
    }

    /*
     * Unable to fully structure code
     */
    private static QueryExpression processNewUnsafeFunction(AST ast, Query q, String modelPackage, Iterator<?> iterator) {
        firstObj = null;
        secondObj = null;
        type = -1;
        block9: do {
            switch (ast.getType()) {
                case 17: 
                case 18: 
                case 20: 
                case 21: 
                case 31: {
                    try {
                        if (firstObj == null) {
                            firstObj = (QueryEvaluable)IqlQueryParser.processNewQueryNode(ast, q, modelPackage, iterator);
                            ** break;
                        }
                        if (secondObj == null) {
                            secondObj = (QueryEvaluable)IqlQueryParser.processNewQueryNode(ast, q, modelPackage, iterator);
                            ** break;
                        }
                        throw new IllegalArgumentException("QueryExpressions can only have two arguments");
lbl15:
                        // 2 sources

                        continue block9;
                    }
                    catch (ClassCastException e) {
                        throw new IllegalArgumentException("Expressions cannot contain classes as arguments");
                    }
                }
                case 83: {
                    type = 0;
                    break;
                }
                case 87: {
                    type = 1;
                    break;
                }
                case 73: {
                    type = 2;
                    break;
                }
                case 85: {
                    type = 3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
                }
            }
        } while ((ast = ast.getNextSibling()) != null);
        return new QueryExpression(firstObj, type, secondObj);
    }

    /*
     * Unable to fully structure code
     */
    private static QueryEvaluable processNewSafeFunction(AST ast, Query q, String modelPackage, Iterator<?> iterator) {
        firstObj = null;
        secondObj = null;
        thirdObj = null;
        type = -1;
        block15: do {
            switch (ast.getType()) {
                case 17: 
                case 18: 
                case 20: 
                case 21: 
                case 31: {
                    try {
                        if (type == 4) {
                            throw new IllegalArgumentException("Count() does not take an argument");
                        }
                        if (firstObj == null) {
                            firstObj = (QueryEvaluable)IqlQueryParser.processNewQueryNode(ast, q, modelPackage, iterator);
                            ** break;
                        }
                        if (type > -2) {
                            throw new IllegalArgumentException("Too many arguments for aggregate function");
                        }
                        if (secondObj == null) {
                            secondObj = (QueryEvaluable)IqlQueryParser.processNewQueryNode(ast, q, modelPackage, iterator);
                            ** break;
                        }
                        if (thirdObj == null) {
                            thirdObj = (QueryEvaluable)IqlQueryParser.processNewQueryNode(ast, q, modelPackage, iterator);
                            ** break;
                        }
                        throw new IllegalArgumentException("Too many arguments in substring");
lbl23:
                        // 3 sources

                        continue block15;
                    }
                    catch (ClassCastException e) {
                        throw new IllegalArgumentException("Functions cannot contain classes as arguments");
                    }
                }
                case 72: {
                    type = 4;
                    break;
                }
                case 76: {
                    type = 0;
                    break;
                }
                case 77: {
                    type = 1;
                    break;
                }
                case 75: {
                    type = 2;
                    break;
                }
                case 74: {
                    type = 3;
                    break;
                }
                case 78: {
                    type = -2;
                    break;
                }
                case 79: {
                    type = -3;
                    break;
                }
                case 80: {
                    type = -4;
                    break;
                }
                case 81: {
                    type = -5;
                    break;
                }
                case 82: {
                    type = 5;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
                }
            }
        } while ((ast = ast.getNextSibling()) != null);
        if (type == -2) {
            if (secondObj == null) {
                throw new IllegalArgumentException("Not enough arguments for substring function");
            }
            if (thirdObj == null) {
                return new QueryExpression(firstObj, 4, secondObj);
            }
            return new QueryExpression(firstObj, secondObj, thirdObj);
        }
        if (type == -3) {
            if (thirdObj != null) {
                throw new IllegalArgumentException("Too many arguments for indexof function");
            }
            if (secondObj == null) {
                throw new IllegalArgumentException("Too few arguments for indexof function");
            }
            return new QueryExpression(firstObj, 5, secondObj);
        }
        if (type == -4) {
            return new QueryExpression(6, firstObj);
        }
        if (type == -5) {
            return new QueryExpression(7, firstObj);
        }
        if (type == 4) {
            return new QueryFunction();
        }
        if (firstObj == null) {
            throw new IllegalArgumentException("Need an argument for this function");
        }
        if (firstObj instanceof QueryField) {
            return new QueryFunction(firstObj, type);
        }
        if (firstObj instanceof QueryExpression) {
            return new QueryFunction(firstObj, type);
        }
        throw new IllegalArgumentException("Arguments to aggregate functions may be fields or expressions only");
    }

    private static QueryCast processNewTypeCast(AST ast, Query q, String modelPackage, Iterator<?> iterator) {
        QueryEvaluable value = null;
        String type = null;
        do {
            switch (ast.getType()) {
                case 17: 
                case 18: 
                case 20: 
                case 21: 
                case 31: {
                    try {
                        value = (QueryEvaluable)IqlQueryParser.processNewQueryNode(ast, q, modelPackage, iterator);
                        break;
                    }
                    catch (ClassCastException e) {
                        throw new IllegalArgumentException("TypeCasts cannot contains classes as arguments");
                    }
                }
                case 49: {
                    type = IqlQueryParser.unescape(ast.getText());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown AST node " + ast.getText() + " [" + ast.getType() + "]");
                }
            }
        } while ((ast = ast.getNextSibling()) != null);
        Class typeClass = null;
        if ("String".equals(type)) {
            typeClass = String.class;
        } else if ("Boolean".equals(type)) {
            typeClass = Boolean.class;
        } else if ("Short".equals(type)) {
            typeClass = Short.class;
        } else if ("Integer".equals(type)) {
            typeClass = Integer.class;
        } else if ("Long".equals(type)) {
            typeClass = Long.class;
        } else if ("Float".equals(type)) {
            typeClass = Float.class;
        } else if ("Double".equals(type)) {
            typeClass = Double.class;
        } else if ("BigDecimal".equals(type)) {
            typeClass = BigDecimal.class;
        } else if ("Date".equals(type)) {
            typeClass = Date.class;
        } else {
            throw new IllegalArgumentException("Invalid type cast to " + type);
        }
        return new QueryCast(value, typeClass);
    }

    private static void processOrderClause(AST ast, Query q, String modelPackage, Iterator<?> iterator) {
        do {
            QueryOrderable qo = (QueryOrderable)IqlQueryParser.processNewQueryNodeOrReference(ast, q, false, modelPackage, iterator);
            for (QuerySelectable qs : q.getSelect()) {
                if (!qo.equals(qs)) continue;
                qo = (QueryOrderable)((Object)qs);
                break;
            }
            q.addToOrderBy(qo);
        } while ((ast = ast.getNextSibling()) != null);
    }

    private static void processGroupClause(AST ast, Query q, String modelPackage, Iterator<?> iterator) {
        do {
            q.addToGroupBy(IqlQueryParser.processNewQueryNode(ast, q, modelPackage, iterator));
        } while ((ast = ast.getNextSibling()) != null);
    }

    private static Constraint processConstraintSet(AST ast, ConstraintOp op, Query q, String modelPackage, Iterator<?> iterator) {
        Constraint retval = null;
        boolean isSet = false;
        do {
            Constraint temp = IqlQueryParser.processConstraint(ast, q, modelPackage, iterator);
            if (retval == null) {
                retval = temp;
                continue;
            }
            if (!isSet) {
                Constraint temp2 = retval;
                retval = new ConstraintSet(op);
                ((ConstraintSet)retval).addConstraint(temp2);
                ((ConstraintSet)retval).addConstraint(temp);
                isSet = true;
                continue;
            }
            ((ConstraintSet)retval).addConstraint(temp);
        } while ((ast = ast.getNextSibling()) != null);
        return retval;
    }

    private static Constraint processConstraint(AST ast, Query q, String modelPackage, Iterator<?> iterator) {
        switch (ast.getType()) {
            case 24: {
                return IqlQueryParser.processConstraintSet(ast.getFirstChild(), ConstraintOp.AND, q, modelPackage, iterator);
            }
            case 25: {
                return IqlQueryParser.processConstraintSet(ast.getFirstChild(), ConstraintOp.OR, q, modelPackage, iterator);
            }
            case 68: {
                return new ConstraintSet(ConstraintOp.AND);
            }
            case 69: {
                return new ConstraintSet(ConstraintOp.OR);
            }
            case 22: {
                return IqlQueryParser.processSimpleConstraint(ast, q, modelPackage, iterator);
            }
            case 26: {
                AST subAST = ast.getFirstChild();
                QueryNode leftb = IqlQueryParser.processNewQueryNode(subAST, q, modelPackage, iterator);
                subAST = subAST.getNextSibling();
                if (subAST.getType() != 4) {
                    throw new IllegalArgumentException("Expected: an IQL SELECT statement");
                }
                Query rightb = new Query();
                rightb.setDistinct(false);
                IqlQueryParser.processIqlStatementAST(subAST, rightb, modelPackage, iterator);
                if (leftb instanceof QueryClass) {
                    return new SubqueryConstraint((QueryClass)leftb, ConstraintOp.IN, rightb);
                }
                return new SubqueryConstraint((QueryEvaluable)leftb, ConstraintOp.IN, rightb);
            }
            case 27: {
                AST subAST = ast.getFirstChild();
                if (subAST.getType() != 4) {
                    throw new IllegalArgumentException("Expected: an IQL SELECT statement");
                }
                Query subquery = new Query();
                subquery.setDistinct(false);
                IqlQueryParser.processIqlStatementAST(subAST, subquery, modelPackage, iterator);
                return new SubqueryExistsConstraint(ConstraintOp.EXISTS, subquery);
            }
            case 28: {
                AST subAST = ast.getFirstChild();
                if (subAST.getType() != 18) {
                    throw new IllegalArgumentException("Expected a Collection or Object Reference as the first argument of the ContainsConstraint");
                }
                AST subSubAST = subAST.getFirstChild();
                String firstString = IqlQueryParser.unescape(subSubAST.getText());
                if ("?".equals(firstString)) {
                    if ((subSubAST = subSubAST.getNextSibling()) != null) {
                        String secondString = IqlQueryParser.unescape(subSubAST.getText());
                        if (subSubAST.getNextSibling() != null) {
                            throw new IllegalArgumentException("Path expression " + firstString + "." + secondString + "." + subSubAST.getNextSibling().getText() + " extends beyond a " + " collection");
                        }
                        QueryCollectionReference ref = null;
                        try {
                            ref = new QueryCollectionReference((InterMineObject)iterator.next(), secondString);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Object " + firstString + "." + secondString + " does not exist, or is not a collection");
                        }
                        if (subAST.getNextSibling().getType() == 64) {
                            return new ContainsConstraint((QueryReference)ref, ConstraintOp.CONTAINS, (InterMineObject)iterator.next());
                        }
                        QueryNode qc = IqlQueryParser.processNewQueryNode(subAST.getNextSibling(), q, modelPackage, iterator);
                        if (qc instanceof QueryClass) {
                            return new ContainsConstraint((QueryReference)ref, ConstraintOp.CONTAINS, (QueryClass)qc);
                        }
                        throw new IllegalArgumentException("Collection " + firstString + "." + secondString + " cannot contain anything but a " + "QueryClass or InterMineObject");
                    }
                    throw new IllegalArgumentException("Path expression for collection cannot end on a QueryClass");
                }
                FromElement firstObj = (FromElement)q.getReverseAliases().get(firstString);
                if (firstObj instanceof QueryClass || firstObj instanceof QueryClassBag) {
                    if ((subSubAST = subSubAST.getNextSibling()) != null) {
                        String secondString = IqlQueryParser.unescape(subSubAST.getText());
                        if (subSubAST.getNextSibling() != null) {
                            throw new IllegalArgumentException("Path expression " + firstString + "." + secondString + "." + subSubAST.getNextSibling().getText() + " extends beyond a" + " collection or object reference");
                        }
                        QueryReference ref = null;
                        try {
                            if (firstObj instanceof QueryClass) {
                                try {
                                    ref = new QueryObjectReference((QueryClass)firstObj, secondString);
                                }
                                catch (IllegalArgumentException e) {
                                    ref = new QueryCollectionReference((QueryClass)firstObj, secondString);
                                }
                            } else {
                                ref = new QueryCollectionReference((QueryClassBag)firstObj, secondString);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Object " + firstString + "." + secondString + " does not exist, or is not a collection or " + "object reference");
                        }
                        if (subAST.getNextSibling().getType() == 64) {
                            return new ContainsConstraint(ref, ConstraintOp.CONTAINS, (InterMineObject)iterator.next());
                        }
                        QueryNode qc = IqlQueryParser.processNewQueryNode(subAST.getNextSibling(), q, modelPackage, iterator);
                        if (qc instanceof QueryClass) {
                            return new ContainsConstraint(ref, ConstraintOp.CONTAINS, (QueryClass)qc);
                        }
                        throw new IllegalArgumentException("Collection or object reference " + firstString + "." + secondString + " cannot contain anything but a QueryClass or " + "InterMineObject");
                    }
                    throw new IllegalArgumentException("Path expression for collection cannot end on a QueryClass");
                }
                if (firstObj instanceof Query) {
                    throw new IllegalArgumentException("Cannot access a collection or object reference inside subquery " + firstString);
                }
                throw new IllegalArgumentException("No such object " + firstString + " while looking for a collection or object reference");
            }
            case 30: {
                AST subAST = ast.getFirstChild();
                QueryNode leftd = IqlQueryParser.processNewQueryNode(subAST, q, modelPackage, iterator);
                ObjectStoreBag osb = null;
                if (subAST.getNextSibling() != null) {
                    if (subAST.getNextSibling().getType() == 33) {
                        osb = IqlQueryParser.processNewObjectStoreBag(subAST.getNextSibling().getFirstChild());
                        if (subAST.getNextSibling().getNextSibling() != null) {
                            throw new IllegalArgumentException("Expected no further data after ObjectStoreBag");
                        }
                        return new BagConstraint(leftd, ConstraintOp.IN, osb);
                    }
                    throw new IllegalArgumentException("Invalid AST node for BagConstraint: " + subAST.getNextSibling().getText());
                }
                Object nextParam = iterator.next();
                if (nextParam instanceof Collection) {
                    return new BagConstraint(leftd, ConstraintOp.IN, (Collection)nextParam);
                }
                throw new ClassCastException("Parameter " + nextParam + " not a Collection or ObjectStoreBag");
            }
            case 23: {
                AST subAST = ast.getFirstChild();
                Constraint retval = IqlQueryParser.processConstraint(subAST, q, modelPackage, iterator);
                retval.negate();
                return retval;
            }
        }
        throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
    }

    private static Constraint processSimpleConstraint(AST ast, Query q, String modelPackage, Iterator<?> iterator) {
        AST subAST = ast.getFirstChild();
        Object left = IqlQueryParser.processNewQueryNodeOrReference(subAST, q, false, modelPackage, iterator);
        subAST = subAST.getNextSibling();
        ConstraintOp op = null;
        switch (subAST.getType()) {
            case 90: {
                op = ConstraintOp.EQUALS;
                break;
            }
            case 91: {
                op = ConstraintOp.NOT_EQUALS;
                break;
            }
            case 100: {
                op = ConstraintOp.LESS_THAN;
                break;
            }
            case 102: {
                op = ConstraintOp.LESS_THAN_EQUALS;
                break;
            }
            case 101: {
                op = ConstraintOp.GREATER_THAN;
                break;
            }
            case 103: {
                op = ConstraintOp.GREATER_THAN_EQUALS;
                break;
            }
            case 104: {
                op = ConstraintOp.MATCHES;
                break;
            }
            case 29: {
                op = ConstraintOp.DOES_NOT_MATCH;
                break;
            }
            case 88: {
                op = ConstraintOp.IS_NULL;
                break;
            }
            case 89: {
                op = ConstraintOp.IS_NOT_NULL;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown AST node: " + ast.getText() + " [" + ast.getType() + "]");
            }
        }
        subAST = subAST.getNextSibling();
        if (op == ConstraintOp.IS_NULL || op == ConstraintOp.IS_NOT_NULL) {
            if (subAST != null) {
                throw new IllegalArgumentException("IS (NOT) NULL only takes one argument");
            }
            if (left instanceof QueryClass) {
                throw new IllegalArgumentException("Cannot compare a class to null");
            }
            if (left instanceof QueryObjectReference) {
                return new ContainsConstraint((QueryObjectReference)left, op);
            }
            return new SimpleConstraint((QueryEvaluable)left, op);
        }
        if (subAST == null) {
            throw new IllegalArgumentException("Most simple constraints require two arguments");
        }
        if (64 == subAST.getType()) {
            if (left instanceof QueryClass) {
                try {
                    if (op == ConstraintOp.EQUALS) {
                        return new ClassConstraint((QueryClass)left, ConstraintOp.EQUALS, (InterMineObject)iterator.next());
                    }
                    if (op == ConstraintOp.NOT_EQUALS) {
                        return new ClassConstraint((QueryClass)left, ConstraintOp.NOT_EQUALS, (InterMineObject)iterator.next());
                    }
                    throw new IllegalArgumentException("Operation is not valid for comparing a class to an object");
                }
                catch (NoSuchElementException e) {
                    throw new IllegalArgumentException("Not enough parameters in IqlQuery object");
                }
            }
            throw new IllegalArgumentException("Cannot compare a field to an object");
        }
        QueryNode right = IqlQueryParser.processNewQueryNode(subAST, q, modelPackage, iterator);
        if (left instanceof QueryClass) {
            if (right instanceof QueryClass) {
                if (op == ConstraintOp.EQUALS) {
                    return new ClassConstraint((QueryClass)left, ConstraintOp.EQUALS, (QueryClass)right);
                }
                if (op == ConstraintOp.NOT_EQUALS) {
                    return new ClassConstraint((QueryClass)left, ConstraintOp.NOT_EQUALS, (QueryClass)right);
                }
                throw new IllegalArgumentException("Operation is not valid for comparing two classes");
            }
            throw new IllegalArgumentException("Cannot compare a class to a value");
        }
        if (left instanceof QueryEvaluable) {
            if (right instanceof QueryClass) {
                throw new IllegalArgumentException("Cannot compare a value to a class");
            }
            return new SimpleConstraint((QueryEvaluable)left, op, (QueryEvaluable)right);
        }
        throw new IllegalArgumentException("Cannot compare a QueryObjectReference using a SimpleConstraint - use CONTAINS or DOES NOT CONTAIN instead");
    }

    public static String unescape(String word) {
        if (word != null) {
            if (word.charAt(0) == '\"' && word.charAt(word.length() - 1) == '\"') {
                return word.substring(1, word.length() - 1);
            }
            if (word.charAt(0) == '\"' || word.charAt(word.length() - 1) == '\"') {
                throw new IllegalArgumentException("Identifier " + word + " is not properly escaped" + " by surrounding with double quotes");
            }
        }
        return word;
    }
}

