/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query.iql;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.intermine.model.FastPathObject;
import org.intermine.objectstore.query.BagConstraint;
import org.intermine.objectstore.query.ClassConstraint;
import org.intermine.objectstore.query.Clob;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.MultipleInBagConstraint;
import org.intermine.objectstore.query.ObjectStoreBag;
import org.intermine.objectstore.query.ObjectStoreBagCombination;
import org.intermine.objectstore.query.ObjectStoreBagsForObject;
import org.intermine.objectstore.query.OrderDescending;
import org.intermine.objectstore.query.OverlapConstraint;
import org.intermine.objectstore.query.PathExpressionField;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryCast;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryClassBag;
import org.intermine.objectstore.query.QueryCollectionPathExpression;
import org.intermine.objectstore.query.QueryCollectionReference;
import org.intermine.objectstore.query.QueryEvaluable;
import org.intermine.objectstore.query.QueryExpression;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryForeignKey;
import org.intermine.objectstore.query.QueryFunction;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.objectstore.query.QueryObjectPathExpression;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryOrderable;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.QueryValue;
import org.intermine.objectstore.query.SimpleConstraint;
import org.intermine.objectstore.query.SubqueryConstraint;
import org.intermine.objectstore.query.SubqueryExistsConstraint;
import org.intermine.objectstore.query.iql.IqlQueryParser;
import org.intermine.util.DynamicUtil;
import org.intermine.util.Util;

public class IqlQuery {
    private String queryString;
    private String packageName;
    private List<?> parameters;
    private static final String[] RESERVED_WORDS = new String[]{"EXPLAIN", "SELECT", "ALL", "DISTINCT", "FROM", "WHERE", "GROUP", "BY", "ORDER", "AS", "TRUE", "FALSE", "OR", "AND", "NOT", "IN", "CONTAINS", "DOES", "CONTAIN", "LIKE", "IS", "COUNT", "MAX", "MIN", "SUM", "AVG", "SUBSTR", "INDEXOF"};
    private static Set<String> reservedWords = new HashSet<String>();

    public IqlQuery() {
    }

    public IqlQuery(String queryString, String packageName, List<?> parameters) {
        if (queryString == null) {
            throw new NullPointerException("queryString should not be null");
        }
        if ("".equals(queryString)) {
            throw new IllegalArgumentException("queryString should not be empty");
        }
        if ("".equals(packageName)) {
            throw new IllegalArgumentException("packageName should not be empty");
        }
        this.queryString = queryString;
        this.packageName = packageName;
        this.parameters = parameters != null ? parameters : new ArrayList();
    }

    public IqlQuery(String queryString, String packageName) {
        this(queryString, packageName, null);
    }

    public IqlQuery(Query q) {
        ArrayList<Object> newParameters = new ArrayList<Object>();
        if (q == null) {
            throw new NullPointerException("query should not be null");
        }
        boolean needComma = false;
        StringBuffer retval = new StringBuffer(q.isDistinct() ? "SELECT DISTINCT " : "SELECT ");
        HashSet<QueryObjectPathExpression> pathList = new HashSet<QueryObjectPathExpression>();
        for (QuerySelectable querySelectable : q.getSelect()) {
            if (needComma) {
                retval.append(", ");
            }
            needComma = true;
            String nodeAlias = q.getAliases().get(querySelectable);
            if (querySelectable instanceof QueryClass || querySelectable instanceof ObjectStoreBag || querySelectable instanceof ObjectStoreBagCombination || querySelectable instanceof ObjectStoreBagsForObject || querySelectable instanceof Clob) {
                retval.append(IqlQuery.nodeToString(q, querySelectable, newParameters, null));
                continue;
            }
            retval.append(IqlQuery.nodeToString(q, querySelectable, newParameters, pathList)).append(nodeAlias == null ? "" : " AS " + IqlQuery.escapeReservedWord(nodeAlias));
        }
        needComma = false;
        for (FromElement fromElement : q.getFrom()) {
            String classAlias = IqlQuery.escapeReservedWord(q.getAliases().get(fromElement));
            retval.append(needComma ? ", " : " FROM ");
            needComma = true;
            if (fromElement instanceof QueryClass) {
                retval.append(fromElement.toString()).append(classAlias == null ? "" : " AS " + classAlias);
                continue;
            }
            if (fromElement instanceof QueryClassBag) {
                retval.append(fromElement.toString()).append(classAlias == null ? "" : " AS " + classAlias);
                Collection<?> coll = ((QueryClassBag)fromElement).getBag();
                if (coll == null) continue;
                newParameters.add(coll);
                continue;
            }
            retval.append("(").append(fromElement.toString()).append(")").append(classAlias == null ? "" : " AS " + classAlias);
        }
        if (q.getConstraint() != null) {
            retval.append(" WHERE ").append(IqlQuery.constraintToString(q, q.getConstraint(), newParameters));
        }
        needComma = false;
        for (QueryNode queryNode : q.getGroupBy()) {
            retval.append(needComma ? ", " : " GROUP BY ");
            needComma = true;
            retval.append(IqlQuery.nodeToString(q, queryNode, newParameters, null));
        }
        needComma = false;
        for (QueryOrderable queryOrderable : q.getOrderBy()) {
            retval.append(needComma ? ", " : " ORDER BY ");
            needComma = true;
            retval.append(IqlQuery.nodeToString(q, queryOrderable, newParameters, null));
        }
        if (q.getLimit() != Integer.MAX_VALUE) {
            retval.append(" LIMIT " + q.getLimit());
        }
        needComma = false;
        for (QueryObjectPathExpression queryObjectPathExpression : pathList) {
            retval.append(needComma ? ", " : " PATH ");
            needComma = true;
            retval.append(IqlQuery.nodeToString(q, queryObjectPathExpression, newParameters, null)).append(" AS ").append(q.getAliases().get(queryObjectPathExpression));
        }
        this.parameters = newParameters;
        this.queryString = retval.toString();
    }

    public static String nodeToString(Query q, Object qn, List<Object> parameters, Set<QueryObjectPathExpression> pathList) {
        if (qn instanceof QueryClass) {
            String nodeAlias = q.getAliases().get(qn);
            return IqlQuery.escapeReservedWord(nodeAlias);
        }
        if (qn instanceof QueryField) {
            QueryField qf = (QueryField)qn;
            return IqlQuery.escapeReservedWord(q.getAliases().get(qf.getFromElement())) + "." + IqlQuery.escapeReservedWord(qf.getFieldName()) + (qf.getSecondFieldName() == null ? "" : "." + IqlQuery.escapeReservedWord(qf.getSecondFieldName()));
        }
        if (qn instanceof QueryValue) {
            Object obj = ((QueryValue)qn).getValue();
            if (obj instanceof String) {
                return "'" + obj + "'";
            }
            if (obj instanceof Date) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                return "'" + format.format((Date)obj) + "'";
            }
            if (obj instanceof Class) {
                return "'" + ((Class)obj).getName() + "'";
            }
            return obj.toString();
        }
        if (qn instanceof QueryExpression) {
            return IqlQuery.queryExpressionToString(q, (QueryExpression)qn, parameters);
        }
        if (qn instanceof QueryFunction) {
            QueryFunction qf = (QueryFunction)qn;
            if (qf.getOperation() == 4) {
                return "COUNT(*)";
            }
            String retval = null;
            switch (qf.getOperation()) {
                case 0: {
                    retval = "SUM(";
                    break;
                }
                case 1: {
                    retval = "AVG(";
                    break;
                }
                case 2: {
                    retval = "MIN(";
                    break;
                }
                case 3: {
                    retval = "MAX(";
                    break;
                }
                case 5: {
                    retval = "STDDEV(";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid QueryFunction operation: " + qf.getOperation());
                }
            }
            retval = retval + IqlQuery.nodeToString(q, qf.getParam(), parameters, null) + ")";
            return retval;
        }
        if (qn instanceof QueryCast) {
            QueryCast qc = (QueryCast)qn;
            String type = qc.getType().getName();
            return "(" + IqlQuery.nodeToString(q, qc.getValue(), parameters, null) + ")::" + type.substring(type.lastIndexOf(46) + 1);
        }
        if (qn instanceof QueryObjectReference) {
            QueryObjectReference ref = (QueryObjectReference)qn;
            return q.getAliases().get(ref.getQueryClass()) + "." + ref.getFieldName();
        }
        if (qn instanceof QueryForeignKey) {
            QueryForeignKey key = (QueryForeignKey)qn;
            return q.getAliases().get(key.getQueryClass()) + "." + key.getFieldName() + ".id";
        }
        if (qn instanceof QueryObjectPathExpression) {
            return IqlQuery.queryObjectPathExpressionToString(q, parameters, (QueryObjectPathExpression)qn);
        }
        if (qn instanceof QueryCollectionPathExpression) {
            return IqlQuery.queryCollectionPathExpressionToString(q, parameters, (QueryCollectionPathExpression)qn);
        }
        if (qn instanceof PathExpressionField) {
            QueryObjectPathExpression qope = ((PathExpressionField)qn).getQope();
            pathList.add(qope);
            return q.getAliases().get(qope) + "." + ((PathExpressionField)qn).getFieldNumber();
        }
        if (qn instanceof ObjectStoreBag) {
            return "BAG(" + ((ObjectStoreBag)qn).getBagId() + ")";
        }
        if (qn instanceof ObjectStoreBagCombination) {
            StringBuffer retval = new StringBuffer();
            ObjectStoreBagCombination osbc = (ObjectStoreBagCombination)qn;
            boolean needComma = false;
            for (ObjectStoreBag osb : osbc.getBags()) {
                if (needComma) {
                    switch (osbc.getOp()) {
                        case 879234: {
                            retval.append(" UNION ");
                            break;
                        }
                        case 519552: {
                            retval.append(" INTERSECT ");
                            break;
                        }
                        case 281056: {
                            retval.append(" EXCEPT ");
                            break;
                        }
                        case 853915: {
                            retval.append(" ALLBUTINTERSECT ");
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Illegal op: " + osbc.getOp());
                        }
                    }
                }
                needComma = true;
                retval.append(IqlQuery.nodeToString(q, osb, parameters, null));
            }
            return retval.toString();
        }
        if (qn instanceof ObjectStoreBagsForObject) {
            ObjectStoreBagsForObject osbfo = (ObjectStoreBagsForObject)qn;
            StringBuffer retval = new StringBuffer("BAGS FOR " + osbfo.getValue());
            Collection<ObjectStoreBag> bags = osbfo.getBags();
            if (bags != null) {
                retval.append(" IN BAGS ?");
                parameters.add(bags);
            }
            return retval.toString();
        }
        if (qn instanceof Clob) {
            return "CLOB(" + ((Clob)qn).getClobId() + ")";
        }
        if (qn instanceof OrderDescending) {
            return IqlQuery.nodeToString(q, ((OrderDescending)qn).getQueryOrderable(), parameters, null) + " DESC";
        }
        throw new IllegalArgumentException("Invalid Object for nodeToString: " + qn);
    }

    public static String queryCollectionPathExpressionToString(Query q, List<Object> parameters, QueryCollectionPathExpression col) {
        StringBuffer retval = new StringBuffer();
        retval.append(q.getAliases().get(col.getQueryClass())).append(".").append(col.getFieldName());
        if (col.getSubclass() != null) {
            Class<? extends FastPathObject> subclass = col.getSubclass();
            Set<Class<?>> subclasses = DynamicUtil.decomposeClass(subclass);
            if (subclasses.size() == 1) {
                retval.append("::").append(((Class)subclasses.iterator().next()).getName());
            } else {
                boolean needComma = false;
                for (Class clazz : subclasses) {
                    retval.append(needComma ? ", " : "::(");
                    needComma = true;
                    retval.append(clazz.getName());
                }
                retval.append(")");
            }
        }
        if (!col.getSelect().isEmpty() || !col.getFrom().isEmpty() || col.getConstraint() != null) {
            Set empty = Collections.emptySet();
            Query subQ = col.getQuery(empty);
            retval.append("(");
            boolean needSpace = false;
            HashSet<QueryObjectPathExpression> pathList2 = new HashSet<QueryObjectPathExpression>();
            if (!col.getSelect().isEmpty()) {
                retval.append("SELECT ");
                if (col.isSingleton()) {
                    retval.append("SINGLETON ");
                }
                boolean bl = false;
                for (QuerySelectable selectable : col.getSelect()) {
                    boolean bl2;
                    if (bl2) {
                        retval.append(", ");
                    }
                    bl2 = true;
                    retval.append(IqlQuery.nodeToString(subQ, selectable, parameters, pathList2));
                }
                needSpace = true;
            }
            if (!col.getFrom().isEmpty()) {
                if (needSpace) {
                    retval.append(" ");
                }
                retval.append("FROM ");
                boolean bl = false;
                for (FromElement node : col.getFrom()) {
                    boolean bl3;
                    if (bl3) {
                        retval.append(", ");
                    }
                    bl3 = true;
                    String classAlias = IqlQuery.escapeReservedWord(subQ.getAliases().get(node));
                    if (node instanceof QueryClass) {
                        retval.append(node.toString()).append(classAlias == null ? "" : " AS " + classAlias);
                        continue;
                    }
                    if (node instanceof QueryClassBag) {
                        retval.append(node.toString()).append(classAlias == null ? "" : " AS " + classAlias);
                        continue;
                    }
                    retval.append("(").append(node.toString()).append(")").append(classAlias == null ? "" : " AS " + classAlias);
                }
                needSpace = true;
            }
            if (col.getConstraint() != null) {
                if (needSpace) {
                    retval.append(" ");
                }
                retval.append("WHERE ").append(IqlQuery.constraintToString(subQ, col.getConstraint(), parameters));
            }
            boolean bl = false;
            for (QueryObjectPathExpression qope : pathList2) {
                boolean bl4;
                retval.append(bl4 ? ", " : " PATH ");
                bl4 = true;
                retval.append(IqlQuery.nodeToString(subQ, qope, parameters, null)).append(" AS ").append(subQ.getAliases().get(qope));
            }
            retval.append(")");
        }
        return retval.toString();
    }

    public static String queryObjectPathExpressionToString(Query q, List<Object> parameters, QueryObjectPathExpression ref) {
        StringBuffer retval = new StringBuffer();
        retval.append(q.getAliases().get(ref.getQueryClass())).append(".").append(ref.getFieldName());
        if (ref.getSubclass() != null) {
            Class<? extends FastPathObject> subclass = ref.getSubclass();
            Set<Class<?>> subclasses = DynamicUtil.decomposeClass(subclass);
            if (subclasses.size() == 1) {
                retval.append("::").append(((Class)subclasses.iterator().next()).getName());
            } else {
                boolean needComma = false;
                for (Class clazz : subclasses) {
                    retval.append(needComma ? ", " : "::(");
                    needComma = true;
                    retval.append(clazz.getName());
                }
                retval.append(")");
            }
        }
        if (!ref.getSelect().isEmpty() || ref.getConstraint() != null) {
            Set<Integer> empty = Collections.emptySet();
            Query subQ = ref.getQuery(empty, true);
            retval.append("(");
            boolean needSpace = false;
            HashSet<QueryObjectPathExpression> subPathList = new HashSet<QueryObjectPathExpression>();
            if (!ref.getSelect().isEmpty()) {
                retval.append("SELECT ");
                boolean bl = false;
                for (QuerySelectable selectable : ref.getSelect()) {
                    boolean bl2;
                    if (bl2) {
                        retval.append(", ");
                    }
                    bl2 = true;
                    retval.append(IqlQuery.nodeToString(subQ, selectable, parameters, subPathList));
                }
                needSpace = true;
            }
            if (ref.getConstraint() != null) {
                if (needSpace) {
                    retval.append(" ");
                }
                retval.append("WHERE ").append(IqlQuery.constraintToString(subQ, ref.getConstraint(), parameters));
            }
            boolean bl = false;
            for (QueryObjectPathExpression qope : subPathList) {
                boolean bl3;
                retval.append(bl3 ? ", " : " PATH ");
                bl3 = true;
                retval.append(IqlQuery.nodeToString(subQ, qope, parameters, null)).append(" AS ").append(subQ.getAliases().get(qope));
            }
            retval.append(")");
        }
        return retval.toString();
    }

    public static String queryExpressionToString(Query q, QueryExpression qe, List<Object> parameters) {
        if (qe.getOperation() == 4) {
            return "SUBSTR(" + IqlQuery.nodeToString(q, qe.getArg1(), parameters, null) + ", " + IqlQuery.nodeToString(q, qe.getArg2(), parameters, null) + (qe.getArg3() == null ? "" : ", " + IqlQuery.nodeToString(q, qe.getArg3(), parameters, null)) + ")";
        }
        if (qe.getOperation() == 5) {
            return "INDEXOF(" + IqlQuery.nodeToString(q, qe.getArg1(), parameters, null) + ", " + IqlQuery.nodeToString(q, qe.getArg2(), parameters, null) + ")";
        }
        if (qe.getOperation() == 7) {
            return "UPPER(" + IqlQuery.nodeToString(q, qe.getArg1(), parameters, null) + ")";
        }
        if (qe.getOperation() == 6) {
            return "LOWER(" + IqlQuery.nodeToString(q, qe.getArg1(), parameters, null) + ")";
        }
        String retval = IqlQuery.nodeToString(q, qe.getArg1(), parameters, null);
        switch (qe.getOperation()) {
            case 0: {
                retval = retval + " + ";
                break;
            }
            case 1: {
                retval = retval + " - ";
                break;
            }
            case 2: {
                retval = retval + " * ";
                break;
            }
            case 3: {
                retval = retval + " / ";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid QueryExpression operation: " + qe.getOperation());
            }
        }
        retval = retval + IqlQuery.nodeToString(q, qe.getArg2(), parameters, null);
        return retval;
    }

    /*
     * WARNING - void declaration
     */
    public static String constraintToString(Query q, Constraint cc, List<Object> parameters) {
        if (cc instanceof SimpleConstraint) {
            SimpleConstraint c = (SimpleConstraint)cc;
            if (c.getArg2() == null) {
                return IqlQuery.nodeToString(q, c.getArg1(), parameters, null) + " " + c.getOp().toString();
            }
            return IqlQuery.nodeToString(q, c.getArg1(), parameters, null) + " " + c.getOp().toString() + " " + IqlQuery.nodeToString(q, c.getArg2(), parameters, null);
        }
        if (cc instanceof SubqueryConstraint) {
            SubqueryConstraint c = (SubqueryConstraint)cc;
            IqlQuery subquery = c.getQuery().getIqlQuery();
            parameters.addAll(subquery.getParameters());
            return (c.getQueryEvaluable() == null ? IqlQuery.nodeToString(q, c.getQueryClass(), parameters, null) : IqlQuery.nodeToString(q, c.getQueryEvaluable(), parameters, null)) + " " + c.getOp().toString() + " (" + subquery.getQueryString() + ")";
        }
        if (cc instanceof ClassConstraint) {
            ClassConstraint c = (ClassConstraint)cc;
            String retval = IqlQuery.nodeToString(q, c.getArg1(), parameters, null) + " " + c.getOp().toString() + " ";
            if (c.getArg2QueryClass() == null) {
                retval = retval + "?";
                parameters.add(c.getArg2Object());
            } else {
                retval = retval + IqlQuery.nodeToString(q, c.getArg2QueryClass(), parameters, null);
            }
            return retval;
        }
        if (cc instanceof ContainsConstraint) {
            ContainsConstraint c = (ContainsConstraint)cc;
            QueryReference ref = c.getReference();
            ConstraintOp op = c.getOp();
            String refString = IqlQuery.queryReferenceToString(q, ref, parameters);
            if (op.equals(ConstraintOp.IS_NULL) || op.equals(ConstraintOp.IS_NOT_NULL)) {
                return refString + "." + ref.getFieldName() + " " + op.toString();
            }
            if (c.getQueryClass() == null) {
                parameters.add(c.getObject());
                return refString + "." + ref.getFieldName() + " " + op.toString() + " ?";
            }
            return refString + "." + ref.getFieldName() + " " + op.toString() + " " + q.getAliases().get(c.getQueryClass());
        }
        if (cc instanceof ConstraintSet) {
            boolean disjunctive;
            ConstraintSet c = (ConstraintSet)cc;
            ConstraintOp op = c.getOp();
            boolean negate = op == ConstraintOp.NAND || op == ConstraintOp.NOR;
            boolean bl = disjunctive = op == ConstraintOp.OR || op == ConstraintOp.NOR;
            if (!c.getConstraints().isEmpty()) {
                void var8_27;
                boolean needComma = false;
                String string = negate ? "( NOT (" : "(";
                for (Constraint subC : c.getConstraints()) {
                    void var8_29;
                    if (needComma) {
                        String string2 = (String)var8_27 + (disjunctive ? " OR " : " AND ");
                    }
                    needComma = true;
                    String string3 = (String)var8_29 + IqlQuery.constraintToString(q, subC, parameters);
                }
                return (String)var8_27 + (negate ? "))" : ")");
            }
            return disjunctive == negate ? "true" : "false";
        }
        if (cc instanceof BagConstraint) {
            BagConstraint c = (BagConstraint)cc;
            Collection<?> coll = c.getBag();
            if (coll == null) {
                return IqlQuery.nodeToString(q, c.getQueryNode(), parameters, null) + " " + c.getOp().toString() + " BAG(" + c.getOsb().getBagId() + ")";
            }
            parameters.add(coll);
            return IqlQuery.nodeToString(q, c.getQueryNode(), parameters, null) + " " + c.getOp().toString() + " ?";
        }
        if (cc instanceof MultipleInBagConstraint) {
            MultipleInBagConstraint c = (MultipleInBagConstraint)cc;
            Collection<?> coll = c.getBag();
            parameters.add(coll);
            StringBuilder retval = new StringBuilder("(");
            boolean needComma = false;
            for (QueryEvaluable queryEvaluable : c.getEvaluables()) {
                if (needComma) {
                    retval.append(", ");
                }
                needComma = true;
                retval.append(IqlQuery.nodeToString(q, queryEvaluable, parameters, null));
            }
            retval.append(") IN ?");
            return retval.toString();
        }
        if (cc instanceof SubqueryExistsConstraint) {
            IqlQuery subquery = ((SubqueryExistsConstraint)cc).getQuery().getIqlQuery();
            parameters.addAll(subquery.getParameters());
            return (cc.getOp().equals(ConstraintOp.EXISTS) ? "EXISTS (" : "DOES NOT EXIST (") + subquery.getQueryString() + ")";
        }
        if (cc instanceof OverlapConstraint) {
            OverlapConstraint oc = (OverlapConstraint)cc;
            return "RANGE(" + IqlQuery.nodeToString(q, oc.getLeft().getStart(), parameters, null) + ", " + IqlQuery.nodeToString(q, oc.getLeft().getEnd(), parameters, null) + ", " + IqlQuery.nodeToString(q, oc.getLeft().getParent(), parameters, null) + ") OVERLAPS RANGE(" + IqlQuery.nodeToString(q, oc.getRight().getStart(), parameters, null) + ", " + IqlQuery.nodeToString(q, oc.getRight().getEnd(), parameters, null) + ", " + IqlQuery.nodeToString(q, oc.getRight().getParent(), parameters, null) + ")";
        }
        throw new IllegalArgumentException("Unknown constraint type: " + cc);
    }

    public static String queryReferenceToString(Query q, QueryReference ref, List<Object> parameters) {
        if (ref.getQueryClass() != null) {
            return q.getAliases().get(ref.getQueryClass());
        }
        if (((QueryCollectionReference)ref).getQcb() != null) {
            return q.getAliases().get(((QueryCollectionReference)ref).getQcb());
        }
        Object param = ((QueryCollectionReference)ref).getQcObject();
        if (param == null) {
            param = ((QueryCollectionReference)ref).getQcb();
        }
        parameters.add(param);
        return "?";
    }

    public Query toQuery() {
        return IqlQueryParser.parse(this);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public List<?> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<?> parameters) {
        this.parameters = parameters;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.queryString);
        int i = 0;
        for (Object o : this.parameters) {
            ret.append(" ").append(++i).append(": ").append(o.toString());
        }
        return ret.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof IqlQuery)) {
            return false;
        }
        IqlQuery f = (IqlQuery)o;
        return f.queryString.equals(this.queryString) && Util.equals(f.packageName, this.packageName) && Util.equals(f.parameters, this.parameters);
    }

    public int hashCode() {
        return 2 * this.queryString.hashCode() + 3 * Util.hashCode(this.packageName) + 5 * Util.hashCode(this.parameters);
    }

    public static boolean isReservedWord(String word) {
        if (word != null) {
            return reservedWords.contains(word.toUpperCase());
        }
        return false;
    }

    public static String escapeReservedWord(String word) {
        if (word != null && (IqlQuery.isReservedWord(word) || word.charAt(0) == '\"' || word.charAt(word.length() - 1) == '\"')) {
            return "\"" + word + "\"";
        }
        return word;
    }

    static {
        for (int i = 0; i < RESERVED_WORDS.length; ++i) {
            reservedWords.add(RESERVED_WORDS[i]);
        }
    }
}

