/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class UnknownTypeValue {
    public static final int TYPE_NUMBER = 0;
    public static final int TYPE_BOOLEAN = 1;
    public static final int TYPE_STRING = 2;
    private String value;

    public UnknownTypeValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public Object getConvertedValue(Class<?> cls) {
        try {
            if (cls.equals(Boolean.class)) {
                if ("true".equals(this.value)) {
                    return Boolean.TRUE;
                }
                if ("false".equals(this.value)) {
                    return Boolean.FALSE;
                }
            } else if (cls.equals(String.class)) {
                if (this.value.charAt(0) == '\'' && this.value.charAt(this.value.length() - 1) == '\'') {
                    return this.value.substring(1, this.value.length() - 1);
                }
            } else if (cls.equals(Date.class)) {
                if (this.value.charAt(0) == '\'' && this.value.charAt(this.value.length() - 1) == '\'') {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                    return format.parse(this.value.substring(1, this.value.length() - 1));
                }
            } else {
                if (cls.equals(Short.class)) {
                    return Short.valueOf(this.value);
                }
                if (cls.equals(Integer.class)) {
                    return Integer.valueOf(this.value);
                }
                if (cls.equals(Long.class)) {
                    return Long.valueOf(this.value);
                }
                if (cls.equals(Float.class)) {
                    return Float.valueOf(this.value);
                }
                if (cls.equals(Double.class)) {
                    return Double.valueOf(this.value);
                }
                if (cls.equals(BigDecimal.class)) {
                    return new BigDecimal(this.value);
                }
                if (cls.equals(Class.class) && this.value.charAt(0) == '\'' && this.value.charAt(this.value.length() - 1) == '\'') {
                    return Class.forName(this.value.substring(1, this.value.length() - 1));
                }
            }
        }
        catch (ParseException e) {
        }
        catch (NumberFormatException e) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new ClassCastException("Cannot parse value \"" + this.value + "\" into " + cls.toString());
    }

    public String toString() {
        return this.value;
    }

    public int getApproximateType() {
        if (this.value.charAt(0) == '\'' && this.value.charAt(this.value.length() - 1) == '\'') {
            return 2;
        }
        if ("true".equals(this.value) || "false".equals(this.value)) {
            return 1;
        }
        try {
            new BigDecimal(this.value);
            return 0;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ClassCastException("Value \"" + this.value + "\" has no sane type");
        }
    }

    public static int classToType(Class<?> cls) {
        if (String.class.equals(cls)) {
            return 2;
        }
        if (Boolean.class.equals(cls)) {
            return 1;
        }
        if (Number.class.isAssignableFrom(cls)) {
            return 0;
        }
        throw new ClassCastException(cls.toString() + " has no associated type");
    }
}

