/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.util.Arrays;
import java.util.List;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.SubqueryConstraint;

public class SubqueryExistsConstraint
extends Constraint {
    protected Query subquery;
    protected static final List<ConstraintOp> VALID_OPS = Arrays.asList(ConstraintOp.EXISTS, ConstraintOp.DOES_NOT_EXIST);

    public SubqueryExistsConstraint(ConstraintOp op, Query query) {
        if (query == null) {
            throw new NullPointerException("query cannot be null");
        }
        if (op == null) {
            throw new NullPointerException("op cannot be null");
        }
        if (!VALID_OPS.contains(op)) {
            throw new IllegalArgumentException("op cannot be " + op);
        }
        this.subquery = query;
        this.op = op;
    }

    public Query getQuery() {
        return this.subquery;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SubqueryConstraint) {
            SubqueryConstraint sc = (SubqueryConstraint)obj;
            return this.subquery.equals(sc.subquery) && this.op == sc.op;
        }
        return false;
    }

    public int hashCode() {
        return this.subquery.hashCode() + 3 * this.op.hashCode();
    }
}

