/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.util.Arrays;
import java.util.List;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryEvaluable;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.util.Util;

public class SubqueryConstraint
extends Constraint {
    protected Query subquery;
    protected QueryEvaluable qe;
    protected QueryClass cls;
    protected static final List<ConstraintOp> VALID_OPS = Arrays.asList(ConstraintOp.IN, ConstraintOp.NOT_IN);

    public SubqueryConstraint(QueryEvaluable qe, ConstraintOp op, Query query) {
        if (query == null) {
            throw new NullPointerException("query cannot be null");
        }
        if (op == null) {
            throw new NullPointerException("op cannot be null");
        }
        if (!VALID_OPS.contains(op)) {
            throw new IllegalArgumentException("op cannot be " + op);
        }
        if (qe == null) {
            throw new NullPointerException("qe cannot be null");
        }
        List<QuerySelectable> select = query.getSelect();
        if (select.size() < 1) {
            throw new IllegalArgumentException("Query has no items in select list.");
        }
        if (select.size() > 1) {
            throw new IllegalArgumentException("Subquery must have only one select item.");
        }
        QuerySelectable selectNode = select.get(0);
        if (!QueryEvaluable.class.isAssignableFrom(selectNode.getClass())) {
            throw new IllegalArgumentException("Subquery select item is not a QueryEvaluable");
        }
        if (!selectNode.getType().isAssignableFrom(qe.getType()) && !qe.getType().isAssignableFrom(selectNode.getType())) {
            throw new IllegalArgumentException("Type of select from subquery (" + selectNode.getType() + ") not comparable with type from argument (" + qe.getType() + ")");
        }
        this.subquery = query;
        this.op = op;
        this.qe = qe;
    }

    public SubqueryConstraint(QueryClass cls, ConstraintOp op, Query query) {
        if (query == null) {
            throw new NullPointerException("query cannot be null");
        }
        if (op == null) {
            throw new NullPointerException("op cannot be null");
        }
        if (!VALID_OPS.contains(op)) {
            throw new NullPointerException("op cannot be " + op);
        }
        if (cls == null) {
            throw new NullPointerException("cls cannot be null");
        }
        List<QuerySelectable> select = query.getSelect();
        if (select.size() < 1) {
            throw new IllegalArgumentException("Query has no items in select list.");
        }
        if (select.size() > 1) {
            throw new IllegalArgumentException("Subquery must have only one item in select list.");
        }
        QuerySelectable selectNode = select.get(0);
        if (!QueryClass.class.isAssignableFrom(selectNode.getClass())) {
            throw new IllegalArgumentException("Select item of subquery is not a QueryClass");
        }
        if (!selectNode.getType().isAssignableFrom(cls.getType()) && !cls.getType().isAssignableFrom(selectNode.getType())) {
            throw new IllegalArgumentException("QueryClass select from subquery (" + selectNode.getType() + ") not comparable with QueryClass (" + cls.getType() + ")");
        }
        this.subquery = query;
        this.op = op;
        this.cls = cls;
    }

    public Query getQuery() {
        return this.subquery;
    }

    public QueryEvaluable getQueryEvaluable() {
        return this.qe;
    }

    public QueryClass getQueryClass() {
        return this.cls;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SubqueryConstraint) {
            SubqueryConstraint sc = (SubqueryConstraint)obj;
            return this.subquery.equals(sc.subquery) && this.op == sc.op && Util.equals(sc.qe, this.qe) && Util.equals(sc.cls, this.cls);
        }
        return false;
    }

    public int hashCode() {
        return this.subquery.hashCode() + 3 * this.op.hashCode() + 7 * Util.hashCode(this.qe) + 11 * Util.hashCode(this.cls);
    }
}

