/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsBatches;

public class SingletonResults
extends Results
implements Set<Object> {
    public SingletonResults(Query q, ObjectStore os, Map<Object, Integer> sequence) {
        super(q, os, sequence);
        if (q.getSelect().size() != 1) {
            throw new IllegalArgumentException("Query must return a single column");
        }
    }

    public SingletonResults(ResultsBatches batches, boolean optimise, boolean explain, boolean prefetch) {
        super(batches, optimise, explain, prefetch);
    }

    @Override
    public List<Object> range(int start, int end) throws ObjectStoreException {
        List<Object> rows = super.range(start, end);
        for (int i = 0; i < rows.size(); ++i) {
            rows.set(i, ((List)rows.get(i)).get(0));
        }
        return rows;
    }
}

