/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.objectstore.query.QueryEvaluable;
import org.intermine.objectstore.query.UnknownTypeValue;
import org.intermine.util.Util;

public class SimpleConstraint
extends Constraint {
    protected QueryEvaluable qe1;
    protected QueryEvaluable qe2;
    protected static final List<ConstraintOp> NUMBER_OPS = Arrays.asList(ConstraintOp.EQUALS, ConstraintOp.NOT_EQUALS, ConstraintOp.LESS_THAN, ConstraintOp.LESS_THAN_EQUALS, ConstraintOp.GREATER_THAN, ConstraintOp.GREATER_THAN_EQUALS);
    protected static final List<ConstraintOp> DATE_OPS = NUMBER_OPS;
    protected static final List<ConstraintOp> STRING_OPS = Arrays.asList(ConstraintOp.EQUALS, ConstraintOp.NOT_EQUALS, ConstraintOp.CONTAINS, ConstraintOp.LESS_THAN, ConstraintOp.LESS_THAN_EQUALS, ConstraintOp.GREATER_THAN, ConstraintOp.GREATER_THAN_EQUALS, ConstraintOp.MATCHES, ConstraintOp.DOES_NOT_MATCH);
    protected static final List<ConstraintOp> BOOLEAN_OPS = Arrays.asList(ConstraintOp.EQUALS, ConstraintOp.NOT_EQUALS);
    protected static final List<ConstraintOp> ALL_OPS = Arrays.asList(ConstraintOp.EQUALS, ConstraintOp.NOT_EQUALS, ConstraintOp.LESS_THAN, ConstraintOp.LESS_THAN_EQUALS, ConstraintOp.GREATER_THAN, ConstraintOp.GREATER_THAN_EQUALS, ConstraintOp.CONTAINS, ConstraintOp.MATCHES, ConstraintOp.DOES_NOT_MATCH);

    public SimpleConstraint(QueryEvaluable qe1, ConstraintOp op, QueryEvaluable qe2) {
        if (qe1 == null) {
            throw new NullPointerException("qe1 cannot be null");
        }
        if (op == null) {
            throw new NullPointerException("op cannot be null");
        }
        if (qe2 == null) {
            throw new NullPointerException("qe2 cannot be null");
        }
        if (qe1.getType().equals(UnknownTypeValue.class) && !qe2.getType().equals(UnknownTypeValue.class)) {
            qe1.youAreType(qe2.getType());
        }
        if (qe2.getType().equals(UnknownTypeValue.class) && !qe1.getType().equals(UnknownTypeValue.class)) {
            qe2.youAreType(qe1.getType());
        }
        if (!SimpleConstraint.validComparison(qe1.getType(), op, qe2.getType())) {
            throw new IllegalArgumentException("Invalid constraint: " + qe1 + " (a " + qe1.getType().getName() + ") " + op + " " + qe2 + " (a " + qe2.getType().getName() + ")");
        }
        this.qe1 = qe1;
        this.op = op;
        this.qe2 = qe2;
    }

    public SimpleConstraint(QueryEvaluable qe1, ConstraintOp op) {
        if (qe1 == null) {
            throw new NullPointerException("qe1 cannot be null");
        }
        if (op == null) {
            throw new NullPointerException("op cannot be null");
        }
        if (!SimpleConstraint.validComparison(qe1.getType(), op, null)) {
            throw new IllegalArgumentException("Invalid constraint: " + qe1.getType().getName() + " " + op);
        }
        this.qe1 = qe1;
        this.op = op;
    }

    public QueryEvaluable getArg1() {
        return this.qe1;
    }

    public QueryEvaluable getArg2() {
        return this.qe2;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimpleConstraint) {
            SimpleConstraint sc = (SimpleConstraint)obj;
            return this.qe1.equals(sc.qe1) && this.op == sc.op && Util.equals(this.qe2, sc.qe2);
        }
        return false;
    }

    public int hashCode() {
        return this.qe1.hashCode() + 3 * this.op.hashCode() + 7 * Util.hashCode(this.qe2);
    }

    public static boolean validComparison(Class<?> arg1, ConstraintOp op, Class<?> arg2) {
        if (arg2 == null) {
            return op == ConstraintOp.IS_NULL || op == ConstraintOp.IS_NOT_NULL;
        }
        if (SimpleConstraint.comparable(arg1, arg2)) {
            return SimpleConstraint.validOps(arg1).contains(op);
        }
        return false;
    }

    public static boolean comparable(Class<?> arg1, Class<?> arg2) {
        return arg1.equals(arg2) && (arg1.equals(String.class) || arg1.equals(Boolean.class) || arg1.equals(Date.class) || arg1.equals(Short.class) || arg1.equals(Integer.class) || arg1.equals(Long.class) || arg1.equals(Float.class) || arg1.equals(Double.class) || arg1.equals(BigDecimal.class) || arg1.equals(UnknownTypeValue.class) || arg1.equals(Class.class));
    }

    public static List<ConstraintOp> validOps(Class<?> arg) {
        if (Number.class.isAssignableFrom(arg)) {
            return NUMBER_OPS;
        }
        if (String.class.equals(arg)) {
            return STRING_OPS;
        }
        if (Boolean.class.equals(arg) || Boolean.TYPE.equals(arg)) {
            return BOOLEAN_OPS;
        }
        if (Date.class.equals(arg)) {
            return DATE_OPS;
        }
        if (Class.class.equals(arg)) {
            return BOOLEAN_OPS;
        }
        if (UnknownTypeValue.class.equals(arg)) {
            return ALL_OPS;
        }
        return null;
    }

    public static List<ConstraintOp> fixedEnumOps(Class<?> arg) {
        if (Number.class.isAssignableFrom(arg)) {
            return NUMBER_OPS;
        }
        if (String.class.equals(arg)) {
            return STRING_OPS;
        }
        if (Boolean.class.equals(arg)) {
            return BOOLEAN_OPS;
        }
        if (Date.class.equals(arg)) {
            return DATE_OPS;
        }
        if (Class.class.equals(arg)) {
            return BOOLEAN_OPS;
        }
        return ALL_OPS;
    }

    public String toString() {
        if (ConstraintOp.IS_NULL.equals(this.op) || ConstraintOp.IS_NOT_NULL.equals(this.op)) {
            return "SimpleConstraint(" + this.qe1 + " " + this.op + ")";
        }
        return "SimpleConstraint(" + this.qe1 + " " + this.op + " " + this.qe2 + ")";
    }
}

