/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

public class ResultsInfo {
    protected long start;
    protected long complete;
    protected int min;
    protected int rows;
    protected int max;
    public static final int SIZE = 0;
    public static final int AT_MOST = 1;
    public static final int AT_LEAST = 2;
    public static final int ESTIMATE = 3;

    public ResultsInfo() {
    }

    public ResultsInfo(long start, long complete, int rows) {
        this(start, complete, rows, 0, Integer.MAX_VALUE);
    }

    public ResultsInfo(long start, long complete, int rows, int min, int max) {
        this.start = start;
        this.complete = complete;
        this.rows = rows;
        this.min = min;
        this.max = max;
    }

    public ResultsInfo(ResultsInfo old, int min, int max) {
        this.start = old.start;
        this.complete = old.complete;
        this.rows = old.rows;
        this.min = old.min > min ? old.min : min;
        this.max = old.max > max ? max : old.max;
    }

    public int getStatus() {
        if (this.min == this.max) {
            return 0;
        }
        if (this.min >= this.rows) {
            return 2;
        }
        if (this.max <= this.rows) {
            return 1;
        }
        return 3;
    }

    public int getRows() {
        return this.rows > this.min ? (this.rows < this.max ? this.rows : this.max) : this.min;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public long getComplete() {
        return this.complete;
    }

    public void setComplete(long complete) {
        this.complete = complete;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public boolean equals(Object o) {
        if (o instanceof ResultsInfo) {
            ResultsInfo i = (ResultsInfo)o;
            return i.start == this.start && i.complete == this.complete && i.rows == this.rows && i.min == this.min && i.max == this.max;
        }
        return false;
    }

    public int hashCode() {
        return (int)(2L * this.start + 3L * this.complete + (long)(5 * this.rows) + (long)(7 * this.min) + (long)(9 * this.max));
    }

    public String toString() {
        return "ResultsInfo(start=" + this.start + ", complete=" + this.complete + ", rows=" + this.rows + ", min=" + this.min + ", max=" + this.max + ")";
    }
}

