/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import org.intermine.objectstore.DataChangedException;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.query.PrefetchManager;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.ResultsInfo;
import org.intermine.util.CacheMap;

public class ResultsBatches {
    public static final int DEFAULT_BATCH_SIZE = 1000;
    protected Query query;
    protected ObjectStore os;
    protected Map<Object, Integer> sequence;
    protected int minSize = 0;
    protected int maxSize = Integer.MAX_VALUE;
    protected int batchSize = 1000;
    protected boolean initialised = false;
    protected ResultsInfo info;
    protected Map<Integer, List<Object>> batches = Collections.synchronizedMap(new CacheMap("Results batches"));

    public ResultsBatches(Query query, ObjectStore os, Map<Object, Integer> sequence) {
        this.query = query;
        this.os = os;
        this.sequence = sequence;
    }

    public Query getQuery() {
        return this.query;
    }

    public Map<Object, Integer> getSequence() {
        return this.sequence;
    }

    public ObjectStore getObjectStore() {
        return this.os;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public void prefetch(int batchNo, boolean optimise, boolean explain) {
        if (!this.batches.containsKey(new Integer(batchNo))) {
            PrefetchManager.addRequest(this, batchNo, optimise, explain);
        }
    }

    protected List<Object> getRowsFromBatch(int batchNo, int start, int end, boolean optimise, boolean explain) throws ObjectStoreException {
        List<Object> batchList = this.getBatch(batchNo, optimise, explain);
        int startRowInBatch = batchNo * this.batchSize;
        int endRowInBatch = startRowInBatch + this.batchSize - 1;
        start = Math.max(start, startRowInBatch);
        end = Math.min(end, endRowInBatch);
        return batchList.subList(start - startRowInBatch, end - startRowInBatch + 1);
    }

    protected List<Object> getBatch(int batchNo, boolean optimise, boolean explain) throws ObjectStoreException {
        List<Object> retval = this.batches.get(new Integer(batchNo));
        if (retval == null) {
            retval = PrefetchManager.doRequest(this, batchNo, optimise, explain);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Object> fetchBatchFromObjectStore(int batchNo, boolean optimise, boolean explain) throws ObjectStoreException {
        int start = batchNo * this.batchSize;
        int limit = this.batchSize;
        this.initialised = true;
        List<Object> rows = null;
        try {
            List<Object> tmpRows;
            rows = tmpRows = this.os.execute(this.query, start, limit, optimise, explain, this.sequence);
            ResultsBatches resultsBatches = this;
            synchronized (resultsBatches) {
                int size;
                if (rows.size() != this.batchSize) {
                    size = start + rows.size();
                    int n = this.maxSize = this.maxSize > size ? size : this.maxSize;
                }
                if (!rows.isEmpty()) {
                    size = start + rows.size();
                    this.minSize = this.minSize > size ? this.minSize : size;
                }
                Integer key = new Integer(batchNo);
                this.batches.put(key, rows);
            }
        }
        catch (IndexOutOfBoundsException e) {
            ResultsBatches resultsBatches = this;
            synchronized (resultsBatches) {
                if (rows == null) {
                    this.maxSize = this.maxSize > start ? start : this.maxSize;
                }
            }
            throw e;
        }
        return rows;
    }

    public int size(boolean optimise, boolean explain) {
        if (this.minSize == 0 && this.maxSize == Integer.MAX_VALUE) {
            try {
                this.getBatch(0, optimise, explain);
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException("ObjectStore error has occurred in size()", e);
            }
            return this.size(optimise, explain);
        }
        if (this.minSize < this.maxSize) {
            try {
                this.maxSize = this.os.count(this.query, this.sequence);
            }
            catch (DataChangedException e) {
                ConcurrentModificationException e2 = new ConcurrentModificationException("ObjectStore error has occurred (in size) - data changed");
                e2.initCause(e);
                throw e2;
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException("ObjectStore error has occured (in size)", e);
            }
            this.minSize = this.maxSize;
        }
        return this.maxSize;
    }

    public boolean isEmpty(boolean optimise, boolean explain) {
        if (this.minSize > 0) {
            return false;
        }
        if (this.maxSize <= 0) {
            return true;
        }
        try {
            this.getBatch(0, optimise, explain);
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException("ObjectStore error has occurred in isEmpty()", e);
        }
        return this.isEmpty(optimise, explain);
    }

    public ResultsInfo getInfo() throws ObjectStoreException {
        if (this.info == null) {
            this.info = this.os.estimate(this.query);
        }
        return new ResultsInfo(this.info, this.minSize, this.maxSize);
    }

    public synchronized void setBatchSize(int size) {
        if (this.initialised) {
            throw new IllegalStateException("Cannot set batchSize if rows have been retrieved");
        }
        if (size > this.os.getMaxLimit()) {
            throw new IllegalArgumentException("Batch size cannot be greater os.query.max-limit property (" + this.os.getMaxLimit() + ") tried to set to: " + size);
        }
        if (size <= 0) {
            throw new IllegalArgumentException("Batch size must be greater than zero - tried to set to " + size);
        }
        this.batchSize = size;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    protected int getBatchNoForRow(int row) {
        return row / this.batchSize;
    }

    public boolean isSingleBatch() {
        return this.maxSize < this.batchSize;
    }

    public ResultsBatches makeWithDifferentBatchSize(int newBatchSize) {
        ResultsBatches retval = new ResultsBatches(this.query, this.os, this.sequence);
        retval.setBatchSize(newBatchSize);
        List<Object> firstBatch = this.batches.get(new Integer(0));
        if (firstBatch != null && (this.isSingleBatch() || firstBatch.size() >= newBatchSize)) {
            if (firstBatch.size() > newBatchSize) {
                ArrayList<Object> newFirstBatch = new ArrayList<Object>();
                for (int i = 0; i < newBatchSize; ++i) {
                    newFirstBatch.add(firstBatch.get(i));
                }
                firstBatch = newFirstBatch;
            }
            retval.batches.put(new Integer(0), firstBatch);
            retval.minSize = this.minSize;
            retval.maxSize = this.maxSize;
            retval.initialised = true;
        }
        return retval;
    }

    public List<Object> getBatchFromCache(int batchNo) {
        List<Object> retval = this.batches.get(batchNo);
        if (retval != null) {
            return Collections.unmodifiableList(retval);
        }
        return null;
    }
}

