/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.intermine.objectstore.DataChangedException;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.proxy.LazyCollection;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.ResultsBatches;
import org.intermine.objectstore.query.ResultsInfo;

public class Results
extends AbstractList<Object>
implements LazyCollection<Object> {
    private static final Logger LOG = Logger.getLogger(Results.class);
    protected ResultsBatches resultsBatches;
    protected boolean optimise = true;
    protected boolean explain = true;
    protected boolean prefetch = true;
    protected boolean immutable = false;
    protected int lastGet = -1;
    protected int sequential = 0;
    private static final int PREFETCH_SEQUENTIAL_THRESHOLD = 6;

    protected Results() {
    }

    public Results(Query query, ObjectStore os, Map<Object, Integer> sequence) {
        if (query == null) {
            throw new NullPointerException("query must not be null");
        }
        if (os == null) {
            throw new NullPointerException("os must not be null");
        }
        this.resultsBatches = new ResultsBatches(query, os, sequence);
    }

    public Results(ResultsBatches batches, boolean optimise, boolean explain, boolean prefetch) {
        this.resultsBatches = batches;
        this.optimise = optimise;
        this.explain = explain;
        this.prefetch = prefetch;
    }

    @Override
    public synchronized void setNoOptimise() {
        if (this.immutable) {
            throw new IllegalArgumentException("Cannot change settings of Results object in cache");
        }
        this.optimise = false;
    }

    @Override
    public synchronized void setNoExplain() {
        if (this.immutable) {
            throw new IllegalArgumentException("Cannot change settings of Results object in cache");
        }
        this.explain = false;
    }

    public synchronized void setNoPrefetch() {
        if (this.immutable) {
            throw new IllegalArgumentException("Cannot change settings of Results object in cache");
        }
        this.prefetch = false;
    }

    public synchronized void setImmutable() {
        this.immutable = true;
    }

    @Override
    public Query getQuery() {
        return this.resultsBatches.getQuery();
    }

    public Map<Object, Integer> getSequence() {
        return this.resultsBatches.getSequence();
    }

    @Override
    public ObjectStore getObjectStore() {
        return this.resultsBatches.getObjectStore();
    }

    public List<Object> range(int start, int end) throws ObjectStoreException {
        if (start > end + 1) {
            throw new IllegalArgumentException("start=" + start + " > (end + 1)=" + (end + 1));
        }
        if (end >= this.resultsBatches.getMaxSize()) {
            throw new IndexOutOfBoundsException("(end + 1)=" + (end + 1) + " > size=" + this.resultsBatches.getMaxSize());
        }
        int startBatch = this.getBatchNoForRow(start);
        int endBatch = this.getBatchNoForRow(end);
        ArrayList<Object> ret = new ArrayList<Object>();
        for (int i = startBatch; i <= endBatch; ++i) {
            ret.addAll(this.resultsBatches.getRowsFromBatch(i, start, end, this.optimise, this.explain));
        }
        this.sequential = start - 1 == this.lastGet ? (this.sequential += end - start + 1) : 0;
        if (this.resultsBatches.getObjectStore() != null && this.prefetch && this.resultsBatches.getObjectStore().isMultiConnection() && this.sequential > 6 && this.getBatchNoForRow(this.resultsBatches.getMaxSize()) > endBatch) {
            this.resultsBatches.prefetch(endBatch + 1, this.optimise, this.explain);
        }
        this.lastGet = end;
        return ret;
    }

    @Override
    public Object get(int index) {
        List<Object> resultList = null;
        try {
            resultList = this.range(index, index);
        }
        catch (DataChangedException e) {
            ConcurrentModificationException e2 = new ConcurrentModificationException("ObjectStore error has occurred (in get) - data changed");
            e2.initCause(e);
            throw e2;
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException("ObjectStore error has occurred (in get)", e);
        }
        return resultList.get(0);
    }

    @Override
    public List<Object> subList(int start, int end) {
        List<Object> ret = null;
        try {
            ret = this.range(start, end - 1);
        }
        catch (DataChangedException e) {
            ConcurrentModificationException e2 = new ConcurrentModificationException("ObjectStore error has occurred (in subList) - data changed");
            e2.initCause(e);
            throw e2;
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException("ObjectStore error has occured (in subList)", e);
        }
        return ret;
    }

    @Override
    public int size() {
        return this.resultsBatches.size(this.optimise, this.explain);
    }

    @Override
    public boolean isEmpty() {
        return this.resultsBatches.isEmpty(this.optimise, this.explain);
    }

    @Override
    public ResultsInfo getInfo() throws ObjectStoreException {
        return this.resultsBatches.getInfo();
    }

    @Override
    public synchronized void setBatchSize(int size) {
        if (this.immutable) {
            throw new IllegalArgumentException("Cannot change settings of Results object in cache");
        }
        this.resultsBatches.setBatchSize(size);
    }

    public int getBatchSize() {
        return this.resultsBatches.getBatchSize();
    }

    protected int getBatchNoForRow(int row) {
        return this.resultsBatches.getBatchNoForRow(row);
    }

    @Override
    public List<Object> asList() {
        return this;
    }

    public boolean isSingleBatch() {
        return this.resultsBatches.isSingleBatch();
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iter();
    }

    public Iterator<Object> iteratorFrom(int from) {
        Iter iter = new Iter();
        iter.cursor = from;
        return iter;
    }

    public ResultsBatches getResultsBatches() {
        return this.resultsBatches;
    }

    private class Iter
    implements Iterator<Object> {
        int cursor = 0;
        Object nextObject = null;
        Object thisBatch;
        Object nextBatch;

        private Iter() {
        }

        @Override
        public boolean hasNext() {
            if (this.cursor < Results.this.resultsBatches.getMinSize()) {
                return true;
            }
            if (this.nextObject != null) {
                return true;
            }
            try {
                this.nextObject = Results.this.get(this.cursor);
                return true;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return false;
            }
        }

        @Override
        public Object next() {
            Object retval = null;
            if (this.nextObject != null) {
                retval = this.nextObject;
                this.nextObject = null;
            } else {
                try {
                    retval = Results.this.get(this.cursor);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }
            ++this.cursor;
            int currentBatchNo = Results.this.getBatchNoForRow(this.cursor);
            this.thisBatch = Results.this.resultsBatches.batches.get(currentBatchNo);
            this.nextBatch = Results.this.resultsBatches.batches.get(currentBatchNo + 1);
            return retval;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

