/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.math.BigDecimal;
import java.util.Date;
import org.intermine.objectstore.query.QueryEvaluable;
import org.intermine.objectstore.query.UnknownTypeValue;

public class QueryValue
implements QueryEvaluable {
    private Object value;

    public QueryValue(Object value) {
        if (value == null) {
            throw new NullPointerException("Cannot create a QueryValue with null");
        }
        if (!(value instanceof Number || value instanceof String || value instanceof Boolean || value instanceof Date || value instanceof UnknownTypeValue || value instanceof Class)) {
            throw new IllegalArgumentException("value (" + value + ") must be a Number, String, Boolean, Date, Class or unknown but was: " + value.getClass());
        }
        this.value = value;
    }

    @Override
    public Class<?> getType() {
        return this.value.getClass();
    }

    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof QueryValue) {
            Object objValue = ((QueryValue)obj).getValue();
            if (this.value instanceof Number && objValue instanceof Number) {
                if (this.value instanceof BigDecimal || objValue instanceof BigDecimal) {
                    BigDecimal bd1 = null;
                    BigDecimal bd2 = null;
                    bd1 = this.value instanceof BigDecimal ? (BigDecimal)this.value : new BigDecimal(this.value.toString());
                    bd2 = objValue instanceof BigDecimal ? (BigDecimal)objValue : new BigDecimal(objValue.toString());
                    return bd1.compareTo(bd2) == 0;
                }
                if (this.value instanceof Float || this.value instanceof Double || objValue instanceof Float || objValue instanceof Double) {
                    return ((Number)this.value).doubleValue() == ((Number)objValue).doubleValue();
                }
                return ((Number)this.value).longValue() == ((Number)objValue).longValue();
            }
            return this.value.equals(objValue);
        }
        return false;
    }

    public int hashCode() {
        if (this.value instanceof Number) {
            return ((Number)this.value).intValue();
        }
        return this.value.hashCode();
    }

    @Override
    public void youAreType(Class<?> cls) {
        if (!this.value.getClass().equals(UnknownTypeValue.class)) {
            throw new ClassCastException("youAreType called where type already known");
        }
        this.value = ((UnknownTypeValue)this.value).getConvertedValue(cls);
    }

    @Override
    public int getApproximateType() {
        if (this.value.getClass().equals(UnknownTypeValue.class)) {
            return ((UnknownTypeValue)this.value).getApproximateType();
        }
        throw new ClassCastException("getApproximateType called when type is known");
    }

    public String toString() {
        return this.value.getClass().getName() + ": \"" + this.value + "\"";
    }
}

