/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.lang.reflect.Method;
import java.util.Collection;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryOrderable;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.util.TypeUtil;

public class QueryObjectReference
extends QueryReference
implements QueryOrderable {
    public QueryObjectReference(QueryClass qc, String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("Field name parameter is null");
        }
        Method field = TypeUtil.getGetter(qc.getType(), fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Field " + fieldName + " not found in " + qc.getType());
        }
        if (Collection.class.isAssignableFrom(field.getReturnType())) {
            throw new IllegalArgumentException("Field " + fieldName + " is a collection type");
        }
        if (!InterMineObject.class.isAssignableFrom(field.getReturnType())) {
            throw new IllegalArgumentException("Field " + fieldName + " is not a separate database " + "object");
        }
        this.qc = qc;
        this.fieldName = fieldName;
        this.type = field.getReturnType();
    }

    public Class<? extends InterMineObject> getType() {
        return this.type;
    }
}

