/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.query.BagConstraint;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.objectstore.query.QueryPathExpressionWithSelect;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.Queryable;
import org.intermine.util.DynamicUtil;
import org.intermine.util.TypeUtil;

public class QueryObjectPathExpression
implements QueryPathExpressionWithSelect,
Queryable {
    private QueryClass qc;
    private String fieldName;
    private Class<? extends InterMineObject> type;
    private Class<? extends FastPathObject> subclass = null;
    private QueryClass defaultClass;
    private List<QuerySelectable> selectList = new ArrayList<QuerySelectable>();
    private Constraint constraint = null;

    public QueryObjectPathExpression(QueryClass qc, String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("Field name parameter is null");
        }
        if (qc == null) {
            throw new NullPointerException("QueryClass parameter is null");
        }
        Method field = TypeUtil.getGetter(qc.getType(), fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Field " + fieldName + " not found in " + qc.getType());
        }
        if (Collection.class.isAssignableFrom(field.getReturnType())) {
            throw new IllegalArgumentException("Field " + fieldName + " is a collection type");
        }
        if (!InterMineObject.class.isAssignableFrom(field.getReturnType())) {
            throw new IllegalArgumentException("Field " + fieldName + " is not an object reference" + " type - was " + field.getReturnType() + " instead");
        }
        this.qc = qc;
        this.fieldName = fieldName;
        Class<?> tmpType = field.getReturnType();
        this.type = tmpType;
        this.defaultClass = new QueryClass((Class<? extends FastPathObject>)this.type);
    }

    public QueryObjectPathExpression(QueryClass qc, String fieldName, Class<?> ... subclasses) {
        this.subclass = DynamicUtil.composeDescriptiveClass(subclasses);
        if (fieldName == null) {
            throw new NullPointerException("Field name parameter is null");
        }
        if (qc == null) {
            throw new NullPointerException("QueryClass parameter is null");
        }
        if (this.subclass == null) {
            throw new NullPointerException("Subclass parameter is null");
        }
        Method field = TypeUtil.getGetter(qc.getType(), fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Field " + fieldName + " not found in " + qc.getType());
        }
        if (Collection.class.isAssignableFrom(field.getReturnType())) {
            throw new IllegalArgumentException("Field " + fieldName + " is a collection type");
        }
        if (!InterMineObject.class.isAssignableFrom(field.getReturnType())) {
            throw new IllegalArgumentException("Field " + fieldName + " is not an object reference" + " type - was " + field.getReturnType() + " instead");
        }
        if (!field.getReturnType().isAssignableFrom(this.subclass)) {
            throw new IllegalArgumentException("subclass parameter " + this.subclass.getName() + " is not a subclass of reference type " + this.type.getName());
        }
        this.qc = qc;
        this.fieldName = fieldName;
        Class<?> tmpType = field.getReturnType();
        this.type = tmpType;
        this.defaultClass = new QueryClass(this.subclass);
        if (this.subclass.equals(this.type)) {
            this.subclass = null;
        }
    }

    @Override
    public QueryClass getQueryClass() {
        return this.qc;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Class<? extends FastPathObject> getSubclass() {
        return this.subclass;
    }

    @Override
    public Class<?> getType() {
        if (this.selectList.isEmpty()) {
            return this.type;
        }
        return this.selectList.get(0).getType();
    }

    public QueryClass getDefaultClass() {
        return this.defaultClass;
    }

    @Override
    public void addToSelect(QuerySelectable selectable) {
        this.selectList.add(selectable);
    }

    @Override
    public List<QuerySelectable> getSelect() {
        return Collections.unmodifiableList(this.selectList);
    }

    @Override
    public void setConstraint(Constraint c) {
        this.constraint = c;
    }

    @Override
    public Constraint getConstraint() {
        return this.constraint;
    }

    public Query getQuery(Collection<Integer> bag, boolean isNoNotXml) {
        if (isNoNotXml && this.constraint == null && this.selectList.isEmpty() && this.subclass == null) {
            Query q = new Query();
            QueryClass newQc = new QueryClass((Class<? extends FastPathObject>)InterMineObject.class);
            q.addFrom(newQc);
            q.addToSelect(new QueryField(newQc, "id"));
            q.addToSelect(newQc);
            if (bag != null) {
                q.setConstraint(new BagConstraint((QueryNode)new QueryField(newQc, "id"), ConstraintOp.IN, bag));
            }
            q.setDistinct(false);
            return q;
        }
        Query q = new Query();
        q.addFrom(this.defaultClass, "default");
        QueryField defaultId = new QueryField(this.defaultClass, "id");
        q.addToSelect(defaultId);
        if (this.selectList.isEmpty()) {
            q.addToSelect(this.defaultClass);
        } else {
            for (QuerySelectable selectable : this.selectList) {
                q.addToSelect(selectable);
            }
        }
        if (!q.getSelect().contains(this.defaultClass)) {
            q.addToSelect(this.defaultClass);
        }
        if (bag != null) {
            if (this.constraint == null) {
                q.setConstraint(new BagConstraint((QueryNode)defaultId, ConstraintOp.IN, bag));
            } else {
                ConstraintSet cs = new ConstraintSet(ConstraintOp.AND);
                cs.addConstraint(this.constraint);
                cs.addConstraint(new BagConstraint((QueryNode)defaultId, ConstraintOp.IN, bag));
                q.setConstraint(cs);
            }
        }
        q.setDistinct(false);
        return q;
    }
}

