/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.util.ArrayList;
import java.util.List;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QuerySelectable;

public abstract class QueryHelper {
    private QueryHelper() {
    }

    public static void addAndConstraint(Query q, Constraint constraint) {
        if (q == null) {
            throw new NullPointerException("q cannot be null");
        }
        if (constraint == null) {
            throw new NullPointerException("constraint cannot be null");
        }
        Constraint queryConstraint = q.getConstraint();
        if (queryConstraint == null) {
            q.setConstraint(constraint);
        } else if (queryConstraint instanceof ConstraintSet && queryConstraint.getOp().equals(ConstraintOp.AND)) {
            if (constraint instanceof ConstraintSet && constraint.getOp().equals(ConstraintOp.AND)) {
                for (Constraint subC : ((ConstraintSet)constraint).getConstraints()) {
                    ((ConstraintSet)queryConstraint).addConstraint(subC);
                }
            } else {
                ((ConstraintSet)queryConstraint).addConstraint(constraint);
            }
        } else {
            ConstraintSet constraints = new ConstraintSet(ConstraintOp.AND);
            constraints.addConstraint(queryConstraint);
            if (constraint instanceof ConstraintSet && constraint.getOp().equals(ConstraintOp.AND)) {
                for (Constraint subC : ((ConstraintSet)constraint).getConstraints()) {
                    constraints.addConstraint(subC);
                }
            } else {
                constraints.addConstraint(constraint);
            }
            q.setConstraint(constraints);
        }
    }

    public static List<String> getColumnAliases(Query query) {
        ArrayList<String> columnAliases = new ArrayList<String>();
        for (QuerySelectable node : query.getSelect()) {
            String alias = query.getAliases().get(node);
            columnAliases.add(alias);
        }
        return columnAliases;
    }

    public static List<Class<?>> getColumnTypes(Query query) {
        ArrayList columnTypes = new ArrayList();
        for (QuerySelectable node : query.getSelect()) {
            Class<?> type = node.getType();
            columnTypes.add(type);
        }
        return columnTypes;
    }
}

