/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import org.intermine.objectstore.query.QueryCast;
import org.intermine.objectstore.query.QueryEvaluable;
import org.intermine.objectstore.query.QueryExpression;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryForeignKey;
import org.intermine.objectstore.query.UnknownTypeValue;

public class QueryFunction
implements QueryEvaluable {
    public static final int SUM = 0;
    public static final int AVERAGE = 1;
    public static final int MIN = 2;
    public static final int MAX = 3;
    public static final int COUNT = 4;
    public static final int STDDEV = 5;
    private QueryEvaluable obj;
    private int op;

    public QueryFunction(QueryEvaluable qe, int op) {
        if (!(qe instanceof QueryField || qe instanceof QueryExpression || qe instanceof QueryCast || qe instanceof QueryForeignKey)) {
            throw new IllegalArgumentException("Value unsuitable for QueryFunction: " + qe);
        }
        this.constructNonCount(qe, op);
    }

    public QueryFunction() {
        this.op = 4;
        this.obj = null;
    }

    @Override
    public Class<?> getType() {
        if (this.op == 4) {
            return Long.class;
        }
        return this.obj.getType();
    }

    public int getOperation() {
        return this.op;
    }

    public QueryEvaluable getParam() {
        return this.obj;
    }

    private void constructNonCount(QueryEvaluable qe, int op) {
        if (op != 0 && op != 1 && op != 2 && op != 3 && op != 5) {
            throw new IllegalArgumentException("Invalid operation for specified argument");
        }
        if (!Number.class.isAssignableFrom(qe.getType()) && !qe.getType().equals(UnknownTypeValue.class)) {
            throw new IllegalArgumentException("Invalid argument type for specified operation");
        }
        this.obj = qe;
        this.op = op;
    }

    @Override
    public void youAreType(Class<?> cls) {
        if (!this.obj.getType().equals(UnknownTypeValue.class)) {
            throw new ClassCastException("youAreType called on function that already has type");
        }
        this.obj.youAreType(cls);
    }

    @Override
    public int getApproximateType() {
        if (this.obj.getType().equals(UnknownTypeValue.class)) {
            return this.obj.getApproximateType();
        }
        throw new ClassCastException("getApproximateType called when type is known");
    }
}

