/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.lang.reflect.Method;
import java.util.Collection;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryEvaluable;
import org.intermine.util.TypeUtil;

public class QueryForeignKey
implements QueryEvaluable {
    protected QueryClass qc = null;
    protected String fieldName;

    public QueryForeignKey(QueryClass qc, String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("Field name parameter is null");
        }
        Method field = TypeUtil.getGetter(qc.getType(), fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Field " + fieldName + " not found in " + qc.getType());
        }
        if (Collection.class.isAssignableFrom(field.getReturnType())) {
            throw new IllegalArgumentException("Field " + fieldName + " is a collection type");
        }
        if (!InterMineObject.class.isAssignableFrom(field.getReturnType())) {
            throw new IllegalArgumentException("Field " + fieldName + " is not a separate database " + "object");
        }
        this.qc = qc;
        this.fieldName = fieldName;
    }

    public QueryClass getQueryClass() {
        return this.qc;
    }

    @Override
    public Class<?> getType() {
        return Integer.class;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public void youAreType(Class<?> cls) {
        throw new ClassCastException("youAreType called on Foreign Key");
    }

    @Override
    public int getApproximateType() {
        throw new ClassCastException("getApproximateType called on a Foreign Key");
    }
}

