/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryClassBag;
import org.intermine.objectstore.query.QueryEvaluable;
import org.intermine.util.TypeUtil;
import org.intermine.util.Util;

public class QueryField
implements QueryEvaluable {
    private FromElement qc;
    private String fieldName;
    private String secondFieldName;
    private Class<?> type;

    public QueryField(QueryClass qc, String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("Field name parameter is null");
        }
        if (qc == null) {
            throw new NullPointerException("QueryClass parameter is null");
        }
        if ("class".equals(fieldName)) {
            this.qc = qc;
            this.fieldName = "class";
            this.secondFieldName = null;
            this.type = Class.class;
        } else {
            Method field = TypeUtil.getGetter(qc.getType(), fieldName);
            if (field == null) {
                throw new IllegalArgumentException("Field '" + fieldName + "' not found in " + qc.getType());
            }
            if (Collection.class.isAssignableFrom(field.getReturnType())) {
                throw new IllegalArgumentException("Field '" + fieldName + "' is a collection type");
            }
            if (InterMineObject.class.isAssignableFrom(field.getReturnType())) {
                throw new IllegalArgumentException("Field '" + fieldName + "' is an object reference");
            }
            this.qc = qc;
            this.fieldName = fieldName;
            this.secondFieldName = null;
            Class<?> fieldType = field.getReturnType();
            this.type = fieldType.isPrimitive() ? TypeUtil.instantiate(fieldType.toString()) : fieldType;
        }
    }

    public QueryField(Query q, QueryClass qc, String fieldName) {
        if (q == null) {
            throw new NullPointerException("Subquery parameter is null");
        }
        Method field = TypeUtil.getGetter(qc.getType(), fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Field '" + fieldName + "' not found in " + qc.getType());
        }
        if (Collection.class.isAssignableFrom(field.getReturnType())) {
            throw new IllegalArgumentException("Field '" + fieldName + "' is a collection type");
        }
        if (!(Number.class.isAssignableFrom(field.getReturnType()) || String.class.isAssignableFrom(field.getReturnType()) || Boolean.class.isAssignableFrom(field.getReturnType()) || Date.class.isAssignableFrom(field.getReturnType()) || field.getReturnType().isPrimitive())) {
            throw new IllegalArgumentException("Field '" + fieldName + "' is an object reference");
        }
        this.qc = q;
        this.fieldName = q.getAliases().get(qc);
        this.secondFieldName = fieldName;
        Class<?> fieldType = field.getReturnType();
        this.type = fieldType.isPrimitive() ? TypeUtil.instantiate(fieldType.toString()) : fieldType;
    }

    public QueryField(Query q, QueryEvaluable v) {
        if (q == null) {
            throw new NullPointerException("Subquery parameter is null");
        }
        this.qc = q;
        this.fieldName = q.getAliases().get(v);
        if (this.fieldName == null) {
            throw new NullPointerException("Field not found in subquery");
        }
        this.secondFieldName = null;
        this.type = v.getType();
    }

    public QueryField(QueryClassBag qcb) {
        if (qcb == null) {
            throw new NullPointerException("QueryClassBag parameter is null");
        }
        this.qc = qcb;
        this.fieldName = "id";
        this.secondFieldName = null;
        this.type = Integer.class;
    }

    protected QueryField(FromElement qc, String fieldName, String secondFieldName, Class<?> type) {
        this.qc = qc;
        this.fieldName = fieldName;
        this.secondFieldName = secondFieldName;
        this.type = type;
    }

    public FromElement getFromElement() {
        return this.qc;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getSecondFieldName() {
        return this.secondFieldName;
    }

    public String toString() {
        return "QueryField(" + this.qc + ", " + this.fieldName + (this.secondFieldName == null ? "" : ", " + this.secondFieldName) + ")";
    }

    @Override
    public void youAreType(Class<?> cls) {
        throw new ClassCastException("youAreType called on a QueryField");
    }

    @Override
    public int getApproximateType() {
        throw new ClassCastException("getApproximateType called on a QueryField");
    }

    public boolean equals(Object o) {
        if (o instanceof QueryField) {
            QueryField qf = (QueryField)o;
            return this.qc.equals(qf.qc) && this.fieldName.equals(qf.fieldName) && Util.equals(this.secondFieldName, qf.secondFieldName);
        }
        return false;
    }

    public int hashCode() {
        return 3 * this.qc.hashCode() + 5 * this.fieldName.hashCode() + (this.secondFieldName == null ? 0 : 7 * this.secondFieldName.hashCode());
    }
}

