/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import org.intermine.objectstore.query.ClobAccess;
import org.intermine.objectstore.query.QueryEvaluable;
import org.intermine.objectstore.query.QueryValue;
import org.intermine.objectstore.query.UnknownTypeValue;

public class QueryExpression
implements QueryEvaluable {
    public static final int ADD = 0;
    public static final int SUBTRACT = 1;
    public static final int MULTIPLY = 2;
    public static final int DIVIDE = 3;
    public static final int SUBSTRING = 4;
    public static final int INDEX_OF = 5;
    public static final int LOWER = 6;
    public static final int UPPER = 7;
    private QueryEvaluable arg1;
    private int op;
    private QueryEvaluable arg2;
    private QueryEvaluable arg3;
    private Class<?> type;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QueryExpression(QueryEvaluable arg1, int op, QueryEvaluable arg2) {
        if (op == 0 || op == 1 || op == 2 || op == 3) {
            if (Number.class.isAssignableFrom(arg1.getType()) && Number.class.isAssignableFrom(arg2.getType()) && arg1.getType().equals(arg2.getType())) {
                this.type = arg1.getType();
            } else if (arg1.getType().equals(UnknownTypeValue.class) && !arg2.getType().equals(UnknownTypeValue.class)) {
                arg1.youAreType(arg2.getType());
                this.type = arg1.getType();
            } else if (arg2.getType().equals(UnknownTypeValue.class) && !arg1.getType().equals(UnknownTypeValue.class)) {
                arg2.youAreType(arg1.getType());
                this.type = arg2.getType();
            } else {
                if (!arg1.getType().equals(UnknownTypeValue.class) || !arg2.getType().equals(UnknownTypeValue.class)) throw new ClassCastException("Invalid arguments (" + arg1.getType() + ", " + arg2.getType() + ") for specified operation");
                if (arg1.getApproximateType() != arg2.getApproximateType()) {
                    throw new ClassCastException("Incompatible expression with unknown type values");
                }
                this.type = UnknownTypeValue.class;
            }
        } else if (op == 5) {
            if (arg1.getType().equals(UnknownTypeValue.class)) {
                arg1.youAreType(String.class);
            }
            if (arg2.getType().equals(UnknownTypeValue.class)) {
                arg2.youAreType(String.class);
            }
            if (!String.class.isAssignableFrom(arg1.getType()) || !String.class.isAssignableFrom(arg2.getType())) throw new ClassCastException("Invalid arguments (" + arg1.getType() + ", " + arg2.getType() + ") for indexof operation");
            this.type = Integer.class;
        } else {
            if (op != 4) throw new IllegalArgumentException("Invalid operation for specified arguments");
            if (arg1.getType().equals(UnknownTypeValue.class)) {
                arg1.youAreType(String.class);
            } else if (!arg1.getType().equals(String.class)) {
                throw new ClassCastException("Invalid arguments (" + arg1.getType() + ", " + arg2.getType() + ") for substring operation");
            }
            if (arg2.getType().equals(UnknownTypeValue.class)) {
                arg2.youAreType(Integer.class);
            } else if (!Number.class.isAssignableFrom(arg2.getType())) {
                throw new ClassCastException("Invalid arguments (" + arg1.getType() + ", " + arg2.getType() + ") for substring operation");
            }
            if (arg2 instanceof QueryValue && (Integer)((QueryValue)arg2).getValue() <= 0) {
                throw new IllegalArgumentException("Invalid pos argument less than or equal to zero for substring");
            }
            this.type = String.class;
        }
        this.arg1 = arg1;
        this.op = op;
        this.arg2 = arg2;
    }

    public QueryExpression(QueryEvaluable arg, QueryEvaluable pos, QueryEvaluable len) {
        if (arg.getType().equals(UnknownTypeValue.class)) {
            arg.youAreType(String.class);
        } else if (!arg.getType().equals(String.class)) {
            throw new ClassCastException("Invalid arguments (" + arg.getType() + ", " + pos.getType() + ", " + len.getType() + ") for substring operation");
        }
        if (pos.getType().equals(UnknownTypeValue.class)) {
            pos.youAreType(Integer.class);
        } else if (!Number.class.isAssignableFrom(pos.getType())) {
            throw new ClassCastException("Invalid arguments (" + arg.getType() + ", " + pos.getType() + ", " + len.getType() + ") for substring operation");
        }
        if (len.getType().equals(UnknownTypeValue.class)) {
            len.youAreType(Integer.class);
        } else if (!Number.class.isAssignableFrom(len.getType())) {
            throw new ClassCastException("Invalid arguments (" + arg.getType() + ", " + pos.getType() + ", " + len.getType() + ") for substring operation");
        }
        if (pos instanceof QueryValue && (Integer)((QueryValue)pos).getValue() <= 0) {
            throw new IllegalArgumentException("Invalid pos argument less than or equal to zero for substring");
        }
        if (len instanceof QueryValue && (Integer)((QueryValue)len).getValue() < 0) {
            throw new IllegalArgumentException("Invalid len argument less than zero for substring");
        }
        this.arg1 = arg;
        this.op = 4;
        this.arg2 = pos;
        this.arg3 = len;
        this.type = String.class;
    }

    public QueryExpression(int op, QueryEvaluable arg) {
        if (op != 7 && op != 6) {
            throw new IllegalArgumentException("Invalid operation for specified arguments");
        }
        if (arg.getType().equals(UnknownTypeValue.class)) {
            arg.youAreType(String.class);
        } else if (!arg.getType().equals(String.class) && !arg.getType().equals(ClobAccess.class)) {
            throw new ClassCastException("Invalid argument (" + arg.getType() + ") for " + (op == 7 ? "UPPER()" : "LOWER()") + " operation");
        }
        this.arg1 = arg;
        this.op = op;
        this.type = String.class;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public int getOperation() {
        return this.op;
    }

    public QueryEvaluable getArg1() {
        return this.arg1;
    }

    public QueryEvaluable getArg2() {
        return this.arg2;
    }

    public QueryEvaluable getArg3() {
        return this.arg3;
    }

    @Override
    public void youAreType(Class<?> cls) {
        if (!this.type.equals(UnknownTypeValue.class)) {
            throw new ClassCastException("youAreType called on QueryExpression that already has type");
        }
        this.arg1.youAreType(cls);
        this.arg2.youAreType(cls);
        this.type = cls;
    }

    @Override
    public int getApproximateType() {
        if (this.type.equals(UnknownTypeValue.class)) {
            return this.arg1.getApproximateType();
        }
        throw new ClassCastException("getApproximateType called when type is known");
    }
}

