/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.CollectionDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.query.BagConstraint;
import org.intermine.objectstore.query.ClassConstraint;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryCloner;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QueryValue;
import org.intermine.objectstore.query.SimpleConstraint;

public final class QueryCreator {
    private QueryCreator() {
    }

    public static Query createQueryForId(Integer id, Class<? extends InterMineObject> clazz) {
        Query q = new Query();
        QueryClass qc = new QueryClass((Class<? extends FastPathObject>)clazz);
        q.addFrom(qc);
        q.addToSelect(qc);
        q.setConstraint(new SimpleConstraint(new QueryField(qc, "id"), ConstraintOp.EQUALS, new QueryValue(id)));
        return q;
    }

    public static Query createQueryForIds(Collection<Integer> ids, Class<? extends InterMineObject> clazz) {
        Query q = new Query();
        q.setDistinct(false);
        QueryClass qc = new QueryClass((Class<? extends FastPathObject>)clazz);
        q.addFrom(qc);
        q.addToSelect(qc);
        QueryField qf = new QueryField(qc, "id");
        q.setConstraint(new BagConstraint((QueryNode)qf, ConstraintOp.IN, ids));
        return q;
    }

    public static Query createQueryForQueryNodeValues(Query q, QueryNode qn) {
        QueryNode qnNew;
        Query ret = QueryCloner.cloneQuery(q);
        ret.clearSelect();
        if (qn instanceof QueryClass) {
            String origAlias = q.getAliases().get(qn);
            qnNew = (QueryNode)ret.getReverseAliases().get(origAlias);
        } else if (qn instanceof QueryField) {
            QueryField qf = (QueryField)qn;
            String origAlias = q.getAliases().get(qf.getFromElement());
            qnNew = new QueryField((QueryClass)ret.getReverseAliases().get(origAlias), qf.getFieldName());
        } else {
            throw new IllegalArgumentException("Method can only deal with QueryClass and QueryField");
        }
        ret.addToSelect(qnNew);
        ret.setDistinct(true);
        ret.clearOrderBy();
        ret.addToOrderBy(qnNew);
        return ret;
    }

    public static Query createQueryForExampleObject(Model model, InterMineObject obj, Set<String> fieldNames) throws ObjectStoreException {
        Query q = new Query();
        Class<?> cls = obj.getClass();
        Map<String, FieldDescriptor> fields = model.getFieldDescriptorsForClass(cls);
        QueryClass qc = new QueryClass((Class<? extends FastPathObject>)cls);
        q.addFrom(qc);
        q.addToSelect(qc);
        ConstraintSet cs = new ConstraintSet(ConstraintOp.AND);
        try {
            for (String fieldName : fieldNames) {
                FieldDescriptor fd = fields.get(fieldName);
                if (fd instanceof AttributeDescriptor) {
                    QueryField qf = new QueryField(qc, fieldName);
                    cs.addConstraint(new SimpleConstraint(qf, ConstraintOp.EQUALS, new QueryValue(obj.getFieldValue(fieldName))));
                    continue;
                }
                if (fd instanceof CollectionDescriptor) {
                    throw new IllegalArgumentException("Cannot include a collection in the example fields");
                }
                if (fd instanceof ReferenceDescriptor) {
                    ReferenceDescriptor ref = (ReferenceDescriptor)fd;
                    QueryClass subQc = new QueryClass(ref.getReferencedClassDescriptor().getType());
                    q.addFrom(subQc);
                    QueryObjectReference qor = new QueryObjectReference(qc, fieldName);
                    cs.addConstraint(new ContainsConstraint((QueryReference)qor, ConstraintOp.CONTAINS, subQc));
                    cs.addConstraint(new ClassConstraint(subQc, ConstraintOp.EQUALS, (InterMineObject)obj.getFieldValue(fieldName)));
                    continue;
                }
                throw new IllegalArgumentException("Illegal field name for example: " + fieldName);
            }
            q.setConstraint(cs);
        }
        catch (Exception e) {
            throw new ObjectStoreException(e);
        }
        return q;
    }
}

