/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.lang.reflect.Method;
import java.util.Collection;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryClassBag;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.util.TypeUtil;

public class QueryCollectionReference
extends QueryReference {
    protected InterMineObject qcObj = null;
    protected QueryClassBag qcb = null;

    public QueryCollectionReference(QueryClass qc, String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("Field name parameter is null");
        }
        Method field = TypeUtil.getGetter(qc.getType(), fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Field " + fieldName + " not found in " + qc.getType());
        }
        if (!Collection.class.isAssignableFrom(field.getReturnType())) {
            throw new IllegalArgumentException("Field " + fieldName + " in " + qc.getType() + " is not a collection type");
        }
        this.qc = qc;
        this.fieldName = fieldName;
        this.type = field.getReturnType();
    }

    public QueryCollectionReference(QueryClassBag qcb, String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("Field name parameter is null");
        }
        Method field = TypeUtil.getGetter(qcb.getType(), fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Field " + fieldName + " not found in " + qcb.getType());
        }
        if (!Collection.class.isAssignableFrom(field.getReturnType())) {
            throw new IllegalArgumentException("Field " + fieldName + " in " + qcb.getType() + " is not a collection type");
        }
        this.qcb = qcb;
        this.fieldName = fieldName;
        this.type = field.getReturnType();
    }

    public QueryCollectionReference(InterMineObject qcObj, String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("Field name parameter is null");
        }
        Method field = TypeUtil.getGetter(qcObj.getClass(), fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Field " + fieldName + " not found in " + qcObj.getClass());
        }
        if (!Collection.class.isAssignableFrom(field.getReturnType())) {
            throw new IllegalArgumentException("Field " + fieldName + " in " + qcObj.getClass() + " is not a collection type");
        }
        this.qcObj = qcObj;
        this.fieldName = fieldName;
        this.type = field.getReturnType();
    }

    public Class<? extends Collection<?>> getType() {
        return this.type;
    }

    public InterMineObject getQcObject() {
        return this.qcObj;
    }

    public QueryClassBag getQcb() {
        return this.qcb;
    }

    @Override
    public Class<? extends FastPathObject> getQcType() {
        if (this.qc != null) {
            return this.qc.getType();
        }
        if (this.qcObj != null) {
            return this.qcObj.getClass();
        }
        return this.qcb.getType();
    }
}

