/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.query.BagConstraint;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryClassBag;
import org.intermine.objectstore.query.QueryCollectionReference;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.objectstore.query.QueryPathExpressionWithSelect;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.Queryable;
import org.intermine.util.DynamicUtil;
import org.intermine.util.TypeUtil;

public class QueryCollectionPathExpression
implements QueryPathExpressionWithSelect,
Queryable {
    private QueryClass qc;
    private String fieldName;
    private Class<?> type;
    private Class<? extends FastPathObject> subclass = null;
    private QueryClass defaultClass;
    private List<QuerySelectable> selectList = new ArrayList<QuerySelectable>();
    private List<FromElement> additionalFromList = new ArrayList<FromElement>();
    private Constraint constraint = null;
    private boolean singleton = false;
    private boolean isCollection;
    private Map<FromElement, String> aliases = new HashMap<FromElement, String>();

    public QueryCollectionPathExpression(QueryClass qc, String fieldName) {
        if (qc == null) {
            throw new NullPointerException("QueryClass parameter is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("Collection name parameter is null");
        }
        this.type = TypeUtil.getFieldType(qc.getType(), fieldName);
        if (this.type == null) {
            throw new IllegalArgumentException("Field " + fieldName + " not found in " + qc.getType());
        }
        if (Collection.class.isAssignableFrom(this.type)) {
            this.isCollection = true;
            this.defaultClass = new QueryClass(TypeUtil.getElementType(qc.getType(), fieldName));
        } else if (InterMineObject.class.isAssignableFrom(this.type)) {
            this.isCollection = false;
            this.defaultClass = new QueryClass(new Class[]{this.type});
        } else {
            throw new IllegalArgumentException("Field " + qc.getType().getName() + "." + fieldName + " is not a collection or reference");
        }
        this.qc = qc;
        this.fieldName = fieldName;
    }

    public QueryCollectionPathExpression(QueryClass qc, String fieldName, Class<?> ... subclasses) {
        Class<FastPathObject> referenceType;
        this.subclass = DynamicUtil.composeDescriptiveClass(subclasses);
        if (qc == null) {
            throw new NullPointerException("QueryClass parameter is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("Collection name parameter is null");
        }
        if (this.subclass == null) {
            throw new NullPointerException("Subclass parameter is null");
        }
        this.type = TypeUtil.getFieldType(qc.getType(), fieldName);
        if (this.type == null) {
            throw new IllegalArgumentException("Field " + fieldName + " not found in " + qc.getType());
        }
        if (Collection.class.isAssignableFrom(this.type)) {
            this.isCollection = true;
            referenceType = TypeUtil.getElementType(qc.getType(), fieldName);
            if (!referenceType.isAssignableFrom(this.subclass)) {
                throw new IllegalArgumentException("subclass parameter " + this.subclass.getName() + " is not a subclass of collection element type " + TypeUtil.getElementType(qc.getType(), fieldName).getName());
            }
            this.defaultClass = new QueryClass(this.subclass);
        } else if (InterMineObject.class.isAssignableFrom(this.type)) {
            Class<?> tmpType = this.type;
            referenceType = tmpType;
            if (!this.type.isAssignableFrom(this.subclass)) {
                throw new IllegalArgumentException("subclass parameter " + this.subclass.getName() + " is not a subclass of reference type " + this.type.getName());
            }
            this.isCollection = false;
            this.defaultClass = new QueryClass(this.subclass);
        } else {
            throw new IllegalArgumentException("Field " + qc.getType().getName() + "." + fieldName + " is not a collection or reference");
        }
        this.qc = qc;
        this.fieldName = fieldName;
        if (this.subclass.equals(referenceType)) {
            this.subclass = null;
        }
    }

    @Override
    public QueryClass getQueryClass() {
        return this.qc;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Class<? extends FastPathObject> getSubclass() {
        return this.subclass;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public QueryClass getDefaultClass() {
        return this.defaultClass;
    }

    @Override
    public void addToSelect(QuerySelectable selectable) {
        if (this.singleton && this.selectList.size() >= 1) {
            throw new IllegalArgumentException("Cannot have a singleton collection with more than one element on the SELECT list");
        }
        this.selectList.add(selectable);
    }

    @Override
    public List<QuerySelectable> getSelect() {
        return Collections.unmodifiableList(this.selectList);
    }

    public void addFrom(FromElement node) {
        this.additionalFromList.add(node);
    }

    public void addFrom(FromElement node, String alias) {
        this.additionalFromList.add(node);
        this.aliases.put(node, alias);
    }

    public List<FromElement> getFrom() {
        return Collections.unmodifiableList(this.additionalFromList);
    }

    @Override
    public void setConstraint(Constraint c) {
        this.constraint = c;
    }

    @Override
    public Constraint getConstraint() {
        return this.constraint;
    }

    public Query getQuery(Collection<? extends InterMineObject> bag) {
        if (this.isCollection) {
            Query q = new Query();
            Class<? extends FastPathObject> tmpType = this.qc.getType();
            QueryClassBag qcb = new QueryClassBag(tmpType, bag);
            q.addFrom(qcb, "bag");
            q.addFrom(this.defaultClass, "default");
            for (FromElement node : this.additionalFromList) {
                if (this.aliases.containsKey(node)) {
                    q.addFrom(node, this.aliases.get(node));
                    continue;
                }
                q.addFrom(node);
            }
            q.addToSelect(new QueryField(qcb), "bagId");
            if (this.selectList.isEmpty()) {
                q.addToSelect(this.defaultClass);
            } else {
                for (QuerySelectable selectable : this.selectList) {
                    q.addToSelect(selectable);
                }
            }
            if (this.constraint == null) {
                q.setConstraint(new ContainsConstraint((QueryReference)new QueryCollectionReference(qcb, this.fieldName), ConstraintOp.CONTAINS, this.defaultClass));
            } else {
                ConstraintSet cs = new ConstraintSet(ConstraintOp.AND);
                cs.addConstraint(this.constraint);
                cs.addConstraint(new ContainsConstraint((QueryReference)new QueryCollectionReference(qcb, this.fieldName), ConstraintOp.CONTAINS, this.defaultClass));
                q.setConstraint(cs);
            }
            q.setDistinct(false);
            return q;
        }
        Query q = new Query();
        q.addFrom(this.defaultClass, "default");
        q.addToSelect(new QueryField(this.defaultClass, "id"));
        for (FromElement node : this.additionalFromList) {
            if (this.aliases.containsKey(node)) {
                q.addFrom(node, this.aliases.get(node));
                continue;
            }
            q.addFrom(node);
        }
        if (this.selectList.isEmpty()) {
            q.addToSelect(this.defaultClass);
        } else {
            for (QuerySelectable selectable : this.selectList) {
                q.addToSelect(selectable);
            }
        }
        if (bag != null) {
            if (this.constraint == null) {
                q.setConstraint(new BagConstraint((QueryNode)this.defaultClass, ConstraintOp.IN, bag));
            } else {
                ConstraintSet cs = new ConstraintSet(ConstraintOp.AND);
                cs.addConstraint(this.constraint);
                cs.addConstraint(new BagConstraint((QueryNode)this.defaultClass, ConstraintOp.IN, bag));
                q.setConstraint(cs);
            }
        } else if (this.constraint != null) {
            q.setConstraint(this.constraint);
        }
        q.setDistinct(false);
        return q;
    }

    public boolean isSingleton() {
        return this.singleton || this.selectList.isEmpty();
    }

    public void setSingleton(boolean singleton) {
        if (singleton && this.selectList.size() > 1) {
            throw new IllegalArgumentException("Cannot have a singleton collection with more than one element on the SELECT list");
        }
        this.singleton = singleton;
    }

    public boolean isCollection() {
        return this.isCollection;
    }
}

