/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.query.BagConstraint;
import org.intermine.objectstore.query.ClassConstraint;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.MultipleInBagConstraint;
import org.intermine.objectstore.query.ObjectStoreBag;
import org.intermine.objectstore.query.ObjectStoreBagCombination;
import org.intermine.objectstore.query.ObjectStoreBagsForObject;
import org.intermine.objectstore.query.OrderDescending;
import org.intermine.objectstore.query.OverlapConstraint;
import org.intermine.objectstore.query.OverlapRange;
import org.intermine.objectstore.query.PathExpressionField;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryCast;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryClassBag;
import org.intermine.objectstore.query.QueryCollectionPathExpression;
import org.intermine.objectstore.query.QueryCollectionReference;
import org.intermine.objectstore.query.QueryEvaluable;
import org.intermine.objectstore.query.QueryExpression;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryForeignKey;
import org.intermine.objectstore.query.QueryFunction;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.objectstore.query.QueryObjectPathExpression;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryOrderable;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.QueryValue;
import org.intermine.objectstore.query.SimpleConstraint;
import org.intermine.objectstore.query.SubqueryConstraint;
import org.intermine.objectstore.query.SubqueryExistsConstraint;

public final class QueryCloner {
    private QueryCloner() {
    }

    public static Query cloneQuery(Query query) {
        Query newQuery = new Query();
        try {
            Map<Object, String> aliases = query.getAliases();
            HashMap<FromElement, FromElement> fromElementMap = new HashMap<FromElement, FromElement>();
            HashMap<QueryObjectPathExpression, QueryObjectPathExpression> qopeMap = new HashMap<QueryObjectPathExpression, QueryObjectPathExpression>();
            for (FromElement origFrom : query.getFrom()) {
                FromElement newFrom = null;
                if (origFrom instanceof QueryClass) {
                    newFrom = origFrom;
                } else if (origFrom instanceof Query) {
                    newFrom = QueryCloner.cloneQuery((Query)origFrom);
                } else if (origFrom instanceof QueryClassBag) {
                    Collection<?> bag = ((QueryClassBag)origFrom).getBag();
                    Class<? extends InterMineObject> type = ((QueryClassBag)origFrom).getType();
                    newFrom = bag == null ? new QueryClassBag(type, ((QueryClassBag)origFrom).getOsb()) : new QueryClassBag(type, (Collection)QueryCloner.cloneThing(((QueryClassBag)origFrom).getBag(), null, null));
                } else {
                    throw new IllegalArgumentException("Unknown type of FromElement " + origFrom);
                }
                newQuery.addFrom(newFrom, aliases.get(origFrom));
                fromElementMap.put(origFrom, newFrom);
            }
            for (QuerySelectable origSelect : query.getSelect()) {
                QuerySelectable newSelect = (QuerySelectable)QueryCloner.cloneThing(origSelect, fromElementMap, qopeMap);
                newQuery.addToSelect(newSelect, aliases.get(origSelect));
            }
            for (QueryOrderable origOrder : query.getOrderBy()) {
                QueryOrderable newOrder = (QueryOrderable)QueryCloner.cloneThing(origOrder, fromElementMap, qopeMap);
                newQuery.addToOrderBy(newOrder);
            }
            for (QueryNode origGroup : query.getGroupBy()) {
                QueryNode newGroup = (QueryNode)QueryCloner.cloneThing(origGroup, fromElementMap, qopeMap);
                newQuery.addToGroupBy(newGroup);
            }
            newQuery.setConstraint((Constraint)QueryCloner.cloneThing(query.getConstraint(), fromElementMap, qopeMap));
            newQuery.setDistinct(query.isDistinct());
            newQuery.setLimit(query.getLimit());
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("No such field: " + e.getMessage());
        }
        return newQuery;
    }

    private static Object cloneThing(Object orig, Map<FromElement, FromElement> fromElementMap, Map<QueryObjectPathExpression, QueryObjectPathExpression> qopeMap) throws NoSuchFieldException {
        if (orig == null) {
            return null;
        }
        if (orig instanceof FromElement) {
            return fromElementMap.get(orig);
        }
        if (orig instanceof QueryField) {
            QueryField origF = (QueryField)orig;
            return new QueryField(fromElementMap.get(origF.getFromElement()), origF.getFieldName(), origF.getSecondFieldName(), origF.getType());
        }
        if (orig instanceof QueryObjectReference) {
            QueryObjectReference origR = (QueryObjectReference)orig;
            return new QueryObjectReference((QueryClass)fromElementMap.get(origR.getQueryClass()), origR.getFieldName());
        }
        if (orig instanceof QueryForeignKey) {
            QueryForeignKey origK = (QueryForeignKey)orig;
            return new QueryForeignKey((QueryClass)fromElementMap.get(origK.getQueryClass()), origK.getFieldName());
        }
        if (orig instanceof QueryCollectionReference) {
            QueryCollectionReference origR = (QueryCollectionReference)orig;
            if (origR.getQueryClass() != null) {
                return new QueryCollectionReference((QueryClass)fromElementMap.get(origR.getQueryClass()), origR.getFieldName());
            }
            if (origR.getQcb() != null) {
                return new QueryCollectionReference((QueryClassBag)fromElementMap.get(origR.getQcb()), origR.getFieldName());
            }
            return new QueryCollectionReference(origR.getQcObject(), origR.getFieldName());
        }
        if (orig instanceof QueryValue) {
            return new QueryValue(((QueryValue)orig).getValue());
        }
        if (orig instanceof QueryFunction) {
            QueryFunction origF = (QueryFunction)orig;
            if (origF.getOperation() == 4) {
                return orig;
            }
            if (origF.getParam() instanceof QueryField) {
                return new QueryFunction((QueryField)QueryCloner.cloneThing(origF.getParam(), fromElementMap, qopeMap), origF.getOperation());
            }
            return new QueryFunction((QueryExpression)QueryCloner.cloneThing(origF.getParam(), fromElementMap, qopeMap), origF.getOperation());
        }
        if (orig instanceof QueryExpression) {
            QueryExpression origE = (QueryExpression)orig;
            if (origE.getOperation() == 4 && origE.getArg3() != null) {
                return new QueryExpression((QueryEvaluable)QueryCloner.cloneThing(origE.getArg1(), fromElementMap, qopeMap), (QueryEvaluable)QueryCloner.cloneThing(origE.getArg2(), fromElementMap, qopeMap), (QueryEvaluable)QueryCloner.cloneThing(origE.getArg3(), fromElementMap, qopeMap));
            }
            if (origE.getOperation() == 6 || origE.getOperation() == 7) {
                return new QueryExpression(origE.getOperation(), (QueryEvaluable)QueryCloner.cloneThing(origE.getArg1(), fromElementMap, qopeMap));
            }
            return new QueryExpression((QueryEvaluable)QueryCloner.cloneThing(origE.getArg1(), fromElementMap, qopeMap), origE.getOperation(), (QueryEvaluable)QueryCloner.cloneThing(origE.getArg2(), fromElementMap, qopeMap));
        }
        if (orig instanceof QueryCast) {
            return new QueryCast((QueryEvaluable)QueryCloner.cloneThing(((QueryCast)orig).getValue(), fromElementMap, qopeMap), ((QueryCast)orig).getType());
        }
        if (orig instanceof PathExpressionField) {
            PathExpressionField origP = (PathExpressionField)orig;
            QueryObjectPathExpression origQope = origP.getQope();
            QueryObjectPathExpression newQope = qopeMap.get(origQope);
            if (newQope == null) {
                newQope = (QueryObjectPathExpression)QueryCloner.cloneThing(origQope, fromElementMap, qopeMap);
                qopeMap.put(origQope, newQope);
            }
            return new PathExpressionField(newQope, origP.getFieldNumber());
        }
        if (orig instanceof QueryObjectPathExpression) {
            QueryObjectPathExpression origC = (QueryObjectPathExpression)orig;
            QueryObjectPathExpression retval = new QueryObjectPathExpression((QueryClass)fromElementMap.get(origC.getQueryClass()), origC.getFieldName());
            HashMap<FromElement, FromElement> subFromElementMap = new HashMap<FromElement, FromElement>();
            subFromElementMap.put(origC.getDefaultClass(), retval.getDefaultClass());
            for (QuerySelectable selectable : origC.getSelect()) {
                retval.addToSelect((QuerySelectable)QueryCloner.cloneThing(selectable, subFromElementMap, qopeMap));
            }
            retval.setConstraint((Constraint)QueryCloner.cloneThing(origC.getConstraint(), subFromElementMap, qopeMap));
            return retval;
        }
        if (orig instanceof QueryCollectionPathExpression) {
            QueryCollectionPathExpression retval;
            QueryCollectionPathExpression origC = (QueryCollectionPathExpression)orig;
            try {
                retval = origC.getSubclass() == null ? new QueryCollectionPathExpression((QueryClass)fromElementMap.get(origC.getQueryClass()), origC.getFieldName()) : new QueryCollectionPathExpression((QueryClass)fromElementMap.get(origC.getQueryClass()), origC.getFieldName(), origC.getSubclass());
            }
            catch (NullPointerException e) {
                throw new NullPointerException("oldQc: " + origC.getQueryClass() + ", fromElementMap: " + fromElementMap);
            }
            retval.setSingleton(origC.isSingleton());
            HashMap<FromElement, FromElement> subFromElementMap = new HashMap<FromElement, FromElement>();
            for (FromElement origFrom : origC.getFrom()) {
                FromElement newFrom = null;
                if (origFrom instanceof QueryClass) {
                    newFrom = origFrom;
                } else if (origFrom instanceof Query) {
                    newFrom = QueryCloner.cloneQuery((Query)origFrom);
                } else if (origFrom instanceof QueryClassBag) {
                    Collection<?> bag = ((QueryClassBag)origFrom).getBag();
                    Class<? extends InterMineObject> type = ((QueryClassBag)origFrom).getType();
                    newFrom = bag == null ? new QueryClassBag(type, ((QueryClassBag)origFrom).getOsb()) : new QueryClassBag(type, (Collection)QueryCloner.cloneThing(((QueryClassBag)origFrom).getBag(), null, qopeMap));
                } else {
                    throw new IllegalArgumentException("Unknown type of FromElement " + origFrom);
                }
                retval.addFrom(newFrom);
                subFromElementMap.put(origFrom, newFrom);
            }
            subFromElementMap.put(origC.getDefaultClass(), retval.getDefaultClass());
            for (QuerySelectable selectable : origC.getSelect()) {
                retval.addToSelect((QuerySelectable)QueryCloner.cloneThing(selectable, subFromElementMap, qopeMap));
            }
            retval.setConstraint((Constraint)QueryCloner.cloneThing(origC.getConstraint(), subFromElementMap, qopeMap));
            return retval;
        }
        if (orig instanceof Constraint) {
            return QueryCloner.cloneConstraint((Constraint)orig, fromElementMap, qopeMap);
        }
        if (orig instanceof OverlapRange) {
            OverlapRange or = (OverlapRange)orig;
            return new OverlapRange((QueryEvaluable)QueryCloner.cloneThing(or.getStart(), fromElementMap, qopeMap), (QueryEvaluable)QueryCloner.cloneThing(or.getEnd(), fromElementMap, qopeMap), (QueryObjectReference)QueryCloner.cloneThing(or.getParent(), fromElementMap, qopeMap));
        }
        if (orig instanceof Set) {
            return new HashSet((Set)orig);
        }
        if (orig instanceof List) {
            return new ArrayList((List)orig);
        }
        if (orig instanceof ObjectStoreBag) {
            return orig;
        }
        if (orig instanceof ObjectStoreBagCombination) {
            ObjectStoreBagCombination origO = (ObjectStoreBagCombination)orig;
            ObjectStoreBagCombination retval = new ObjectStoreBagCombination(origO.getOp());
            retval.getBags().addAll(origO.getBags());
            return retval;
        }
        if (orig instanceof ObjectStoreBagsForObject) {
            ObjectStoreBagsForObject origO = (ObjectStoreBagsForObject)orig;
            if (origO.getBags() == null) {
                return new ObjectStoreBagsForObject(origO.getValue());
            }
            return new ObjectStoreBagsForObject(origO.getValue(), origO.getBags());
        }
        if (orig instanceof OrderDescending) {
            return new OrderDescending((QueryOrderable)QueryCloner.cloneThing(((OrderDescending)orig).getQueryOrderable(), fromElementMap, qopeMap));
        }
        throw new IllegalArgumentException("Unknown object type: " + orig);
    }

    private static Constraint cloneConstraint(Constraint orig, Map<FromElement, FromElement> fromElementMap, Map<QueryObjectPathExpression, QueryObjectPathExpression> qopeMap) throws NoSuchFieldException {
        if (orig instanceof SimpleConstraint) {
            SimpleConstraint origC = (SimpleConstraint)orig;
            if (origC.getOp() == ConstraintOp.IS_NULL || origC.getOp() == ConstraintOp.IS_NOT_NULL) {
                return new SimpleConstraint((QueryEvaluable)QueryCloner.cloneThing(origC.getArg1(), fromElementMap, qopeMap), origC.getOp());
            }
            return new SimpleConstraint((QueryEvaluable)QueryCloner.cloneThing(origC.getArg1(), fromElementMap, qopeMap), origC.getOp(), (QueryEvaluable)QueryCloner.cloneThing(origC.getArg2(), fromElementMap, qopeMap));
        }
        if (orig instanceof ConstraintSet) {
            ConstraintSet origC = (ConstraintSet)orig;
            ConstraintSet newC = new ConstraintSet(origC.getOp());
            for (Constraint con : origC.getConstraints()) {
                newC.addConstraint((Constraint)QueryCloner.cloneThing(con, fromElementMap, qopeMap));
            }
            return newC;
        }
        if (orig instanceof ContainsConstraint) {
            ContainsConstraint origC = (ContainsConstraint)orig;
            if (origC.getOp().equals(ConstraintOp.IS_NULL) || origC.getOp().equals(ConstraintOp.IS_NOT_NULL)) {
                return new ContainsConstraint((QueryObjectReference)QueryCloner.cloneThing(origC.getReference(), fromElementMap, qopeMap), origC.getOp());
            }
            if (origC.getQueryClass() == null) {
                return new ContainsConstraint((QueryReference)QueryCloner.cloneThing(origC.getReference(), fromElementMap, qopeMap), origC.getOp(), origC.getObject());
            }
            return new ContainsConstraint((QueryReference)QueryCloner.cloneThing(origC.getReference(), fromElementMap, qopeMap), origC.getOp(), (QueryClass)QueryCloner.cloneThing(origC.getQueryClass(), fromElementMap, qopeMap));
        }
        if (orig instanceof ClassConstraint) {
            ClassConstraint origC = (ClassConstraint)orig;
            if (origC.getArg2QueryClass() == null) {
                return new ClassConstraint((QueryClass)fromElementMap.get(origC.getArg1()), origC.getOp(), origC.getArg2Object());
            }
            return new ClassConstraint((QueryClass)fromElementMap.get(origC.getArg1()), origC.getOp(), (QueryClass)fromElementMap.get(origC.getArg2QueryClass()));
        }
        if (orig instanceof SubqueryConstraint) {
            SubqueryConstraint origC = (SubqueryConstraint)orig;
            if (origC.getQueryEvaluable() == null) {
                return new SubqueryConstraint((QueryClass)fromElementMap.get(origC.getQueryClass()), origC.getOp(), QueryCloner.cloneQuery(origC.getQuery()));
            }
            return new SubqueryConstraint((QueryEvaluable)QueryCloner.cloneThing(origC.getQueryEvaluable(), fromElementMap, qopeMap), origC.getOp(), QueryCloner.cloneQuery(origC.getQuery()));
        }
        if (orig instanceof BagConstraint) {
            BagConstraint origC = (BagConstraint)orig;
            Collection<?> bag = origC.getBag();
            if (bag instanceof Set) {
                bag = new HashSet(bag);
            } else if (bag instanceof List) {
                bag = new ArrayList(bag);
            }
            if (bag == null) {
                return new BagConstraint((QueryNode)QueryCloner.cloneThing(origC.getQueryNode(), fromElementMap, qopeMap), origC.getOp(), origC.getOsb());
            }
            return new BagConstraint((QueryNode)QueryCloner.cloneThing(origC.getQueryNode(), fromElementMap, qopeMap), origC.getOp(), bag);
        }
        if (orig instanceof MultipleInBagConstraint) {
            MultipleInBagConstraint origC = (MultipleInBagConstraint)orig;
            Collection<?> bag = origC.getBag();
            if (bag instanceof Set) {
                bag = new HashSet(bag);
            } else if (bag instanceof List) {
                bag = new ArrayList(bag);
            }
            List evaluables = (List)QueryCloner.cloneThing(origC.getEvaluables(), fromElementMap, qopeMap);
            return new MultipleInBagConstraint(bag, evaluables);
        }
        if (orig instanceof SubqueryExistsConstraint) {
            SubqueryExistsConstraint origC = (SubqueryExistsConstraint)orig;
            return new SubqueryExistsConstraint(origC.getOp(), QueryCloner.cloneQuery(origC.getQuery()));
        }
        if (orig instanceof OverlapConstraint) {
            OverlapConstraint oc = (OverlapConstraint)orig;
            return new OverlapConstraint((OverlapRange)QueryCloner.cloneThing(oc.getLeft(), fromElementMap, qopeMap), oc.getOp(), (OverlapRange)QueryCloner.cloneThing(oc.getRight(), fromElementMap, qopeMap));
        }
        throw new IllegalArgumentException("Unknown constraint type " + orig.getClass().getName());
    }
}

