/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.ObjectStoreBag;
import org.intermine.util.DynamicUtil;

public class QueryClassBag
implements FromElement {
    private Class<? extends InterMineObject> type;
    private Set<Integer> ids;
    private Collection<?> bag;
    private ObjectStoreBag osb;

    public QueryClassBag(Class<? extends InterMineObject> type, Collection<?> bag) {
        this.type = type;
        this.bag = bag;
        this.ids = QueryClassBag.convertToIds(bag, this.type);
        this.osb = null;
    }

    public QueryClassBag(Set<Class<?>> types, Collection<?> bag) {
        Class<FastPathObject> clazz = types.size() == 1 ? types.iterator().next() : DynamicUtil.composeClass(types);
        if (!InterMineObject.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Cannot create a QueryClassBag with a class that is not a subclass of InterMineObject: " + DynamicUtil.getFriendlyName(clazz));
        }
        Class<FastPathObject> thisType = clazz;
        this.type = thisType;
        this.bag = bag;
        this.ids = QueryClassBag.convertToIds(bag, this.type);
        this.osb = null;
    }

    public QueryClassBag(Class<? extends InterMineObject> type, ObjectStoreBag osb) {
        this.type = type;
        this.osb = osb;
        this.ids = null;
        this.bag = null;
    }

    public QueryClassBag(Set<Class<?>> types, ObjectStoreBag osb) {
        Class<FastPathObject> clazz = types.size() == 1 ? types.iterator().next() : DynamicUtil.composeClass(types);
        if (!InterMineObject.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Cannot create a QueryClassBag with a class that is not a subclass of InterMineObject: " + DynamicUtil.getFriendlyName(clazz));
        }
        Class<FastPathObject> thisType = clazz;
        this.type = thisType;
        this.osb = osb;
        this.ids = null;
        this.bag = null;
    }

    private static Set<Integer> convertToIds(Collection<?> bag, Class<? extends InterMineObject> type) {
        if (bag == null) {
            return null;
        }
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Object o : bag) {
            if (!type.isInstance(o)) continue;
            ids.add(((InterMineObject)o).getId());
        }
        return ids;
    }

    public Class<? extends InterMineObject> getType() {
        return this.type;
    }

    public Collection<?> getBag() {
        return this.bag;
    }

    public ObjectStoreBag getOsb() {
        return this.osb;
    }

    public Set<Integer> getIds() {
        return this.ids;
    }

    public String toString() {
        Set<Class<?>> classes = DynamicUtil.decomposeClass(this.type);
        StringBuffer retval = new StringBuffer();
        if (this.osb != null) {
            retval.append("BAG(" + this.osb.getBagId() + ")::");
        } else if (this.bag != null) {
            retval.append("?::");
        } else {
            retval.append("!::");
        }
        if (classes.size() == 1) {
            retval.append(this.type.getName());
        } else {
            boolean needComma = false;
            for (Class<?> clazz : classes) {
                retval.append(needComma ? ", " : "(");
                needComma = true;
                retval.append(clazz.getName());
            }
            retval.append(")");
        }
        return retval.toString();
    }
}

