/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.util.Set;
import org.intermine.model.FastPathObject;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.util.DynamicUtil;

public class QueryClass
implements QueryNode,
FromElement {
    private Class<? extends FastPathObject> type;

    public QueryClass(Class<? extends FastPathObject> type) {
        this.type = type;
    }

    public QueryClass(Set<Class<?>> types) {
        this(types.toArray(new Class[0]));
    }

    public QueryClass(Class<?> ... types) {
        this.type = DynamicUtil.composeDescriptiveClass(types);
    }

    public Class<? extends FastPathObject> getType() {
        return this.type;
    }

    public String toString() {
        Set<Class<?>> classes = DynamicUtil.decomposeClass(this.type);
        if (classes.size() == 1) {
            return this.type.getName();
        }
        boolean needComma = false;
        StringBuffer retval = new StringBuffer();
        for (Class<?> clazz : classes) {
            retval.append(needComma ? ", " : "(");
            needComma = true;
            retval.append(clazz.getName());
        }
        return retval.toString() + ")";
    }
}

