/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.util.Date;
import org.intermine.objectstore.query.QueryEvaluable;

public class QueryCast
implements QueryEvaluable {
    private QueryEvaluable value;
    private Class<?> type;

    public QueryCast(QueryEvaluable value, Class<?> type) {
        if (value == null) {
            throw new NullPointerException("Cannot create a QueryCast with null");
        }
        if (!(Number.class.isAssignableFrom(type) || String.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Date.class.isAssignableFrom(type))) {
            throw new IllegalArgumentException("type must be a Number, String, Boolean, or Date");
        }
        this.value = value;
        this.type = type;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public QueryEvaluable getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof QueryCast) {
            QueryCast objCast = (QueryCast)obj;
            if (objCast.value.equals(this.value) && objCast.type.equals(this.type)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 3 * this.value.hashCode() + 5 * this.type.hashCode();
    }

    @Override
    public void youAreType(Class<?> cls) {
        throw new ClassCastException("youAreType called on a QueryCast");
    }

    @Override
    public int getApproximateType() {
        throw new ClassCastException("getApproximateType called on QueryCast");
    }
}

